/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.client.gui.ImmersivePaintingScreen;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.NetworkManager;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.s2c.OpenGuiRequest;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.network.s2c.PaintingModifyMessage;
import immersive_paintings.network.s2c.RegisterPaintingResponse;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class ClientNetworkManager
implements NetworkManager {
    @Override
    public void handleOpenGuiRequest(OpenGuiRequest request) {
        if (request.gui == OpenGuiRequest.Type.EDITOR) {
            class_310.method_1551().method_1507((class_437)new ImmersivePaintingScreen(request.entity, request.minResolution, request.maxResolution, request.showOtherPlayersPaintings, request.uploadPermissionLevel));
        }
    }

    @Override
    public void handlePaintingListResponse(PaintingListMessage response) {
        if (response.shouldClear()) {
            ClientPaintingManager.getPaintings().clear();
        }
        for (Map.Entry<class_2960, Painting> entry : response.getPaintings().entrySet()) {
            if (entry.getValue() == null) {
                ClientPaintingManager.getPaintings().remove(entry.getKey());
                continue;
            }
            ClientPaintingManager.getPaintings().put(entry.getKey(), entry.getValue());
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ImmersivePaintingScreen) {
            ImmersivePaintingScreen screen = (ImmersivePaintingScreen)class_4372;
            screen.refreshPage();
        }
    }

    @Override
    public void handlePaintingModifyMessage(PaintingModifyMessage message) {
        class_1297 class_12972;
        class_746 e = class_310.method_1551().field_1724;
        if (e != null && (class_12972 = e.method_37908().method_8469(message.getEntityId())) instanceof ImmersivePaintingEntity) {
            ImmersivePaintingEntity painting = (ImmersivePaintingEntity)class_12972;
            painting.setMotive(message.getMotive());
            painting.setFrame(message.getFrame());
            painting.setMaterial(message.getMaterial());
            painting.setFacing(message.getFacing(), message.getRotation());
            painting.setAttachmentPos(message.getPos());
        }
    }

    @Override
    public void handleRegisterPaintingResponse(RegisterPaintingResponse response) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ImmersivePaintingScreen) {
            ImmersivePaintingScreen screen = (ImmersivePaintingScreen)class_4372;
            if (response.error.isEmpty()) {
                if (screen.entity != null) {
                    screen.entity.setMotive(new class_2960(response.identifier));
                    NetworkHandler.sendToServer(new PaintingModifyRequest(screen.entity));
                    if (screen.entity.isGraffiti()) {
                        class_310.method_1551().method_1507(null);
                    } else {
                        screen.setPage(ImmersivePaintingScreen.Page.FRAME);
                    }
                }
            } else {
                screen.setPage(ImmersivePaintingScreen.Page.CREATE);
                screen.setError((class_2561)class_2561.method_43471((String)("immersive_paintings.error." + response.error)));
            }
        }
    }
}

