/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Logger;

public class PaintingsLoader
extends class_4080<Map<class_2960, Painting>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private final Gson gson = new GsonBuilder().create();
    final String dataType = "paintings";

    protected Map<class_2960, Painting> prepare(class_3300 manager, class_3695 profiler) {
        HashMap map = Maps.newHashMap();
        int dataTypeLength = "paintings".length() + 1;
        Map resources = manager.method_14488("paintings", path -> path.method_12832().endsWith(".png"));
        for (Map.Entry entry : resources.entrySet()) {
            String string = ((class_2960)entry.getKey()).method_12832();
            class_2960 imageIdentifier = new class_2960(((class_2960)entry.getKey()).method_12836(), string.substring(dataTypeLength, string.length() - FILE_SUFFIX_LENGTH));
            try {
                Painting painting;
                class_2960 jsonIdentifier = new class_2960(((class_2960)entry.getKey()).method_12836(), string.replace(".png", ".json"));
                String hash = ((class_2960)entry.getKey()).toString().replaceAll("[^a-zA-Z\\d]", "");
                Optional resource = manager.method_14486(jsonIdentifier);
                if (resource.isPresent()) {
                    InputStream inputStream = ((class_3298)resource.get()).method_14482();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    JsonObject jsonElement = Objects.requireNonNull((JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class)).getAsJsonObject();
                    int width = class_3518.method_15282((JsonObject)jsonElement, (String)"width", (int)1);
                    int height = class_3518.method_15282((JsonObject)jsonElement, (String)"height", (int)1);
                    int resolution = class_3518.method_15282((JsonObject)jsonElement, (String)"resolution", (int)32);
                    String name = class_3518.method_15253((JsonObject)jsonElement, (String)"name", (String)"unknown");
                    String author = class_3518.method_15253((JsonObject)jsonElement, (String)"author", (String)"unknown");
                    boolean graffiti = class_3518.method_15258((JsonObject)jsonElement, (String)"graffiti", (boolean)false);
                    painting = new Painting(null, width, height, resolution, name, author, true, false, graffiti, hash);
                } else {
                    painting = new Painting(null, 1, 1, 32, "unknown", "unknown", true, false, false, hash);
                }
                painting.texture.resource = (class_3298)entry.getValue();
                map.put((class_2960)entry.getKey(), painting);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load painting {} from {} ({})", new Object[]{imageIdentifier, entry.getKey(), exception});
            }
        }
        return map;
    }

    protected void apply(Map<class_2960, Painting> prepared, class_3300 manager, class_3695 profiler) {
        ServerPaintingManager.setDatapackPaintings(prepared);
    }
}

