/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.world.placement;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsbridges.module.PlacementModifierTypeModule;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_6797;
import net.minecraft.class_6798;

@class_6328
public class BridgePlacement
extends class_6797 {
    public static final Codec<BridgePlacement> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("length").forGetter(bridgePlacement -> bridgePlacement.length), (App)Codec.INT.fieldOf("width").forGetter(bridgePlacement -> bridgePlacement.width), (App)Codec.INT.fieldOf("min_water_z").forGetter(bridgePlacement -> bridgePlacement.minWaterZ), (App)Codec.INT.fieldOf("max_water_z").forGetter(bridgePlacement -> bridgePlacement.maxWaterZ), (App)Codec.INT.fieldOf("width_offset").forGetter(bridgePlacement -> bridgePlacement.widthOffset), (App)Codec.INT.fieldOf("num_solid_blocks_needed").forGetter(bridgePlacement -> bridgePlacement.numSolidBlocksNeeded), (App)Codec.BOOL.optionalFieldOf("is_z_axis", (Object)true).forGetter(bridgePlacement -> bridgePlacement.isZAxis)).apply((Applicative)codec, BridgePlacement::new));
    public final int length;
    public final int width;
    public final int minWaterZ;
    public final int maxWaterZ;
    public int widthOffset;
    public int numSolidBlocksNeeded;
    public boolean isZAxis;

    private BridgePlacement(int length, int width, int minWaterZ, int maxWaterZ, int widthOffset, int numSolidBlocksNeeded, boolean isZAxis) {
        this.length = length;
        this.width = width;
        this.minWaterZ = minWaterZ;
        this.maxWaterZ = maxWaterZ;
        this.widthOffset = widthOffset;
        this.numSolidBlocksNeeded = numSolidBlocksNeeded;
        this.isZAxis = isZAxis;
    }

    public Stream<class_2338> method_14452(class_5444 placementContext, class_5819 randomSource, class_2338 blockPos) {
        class_2338.class_2339 seaLevelMutable = blockPos.method_25503();
        int seaLevel = placementContext.method_34383().method_8615() - 1;
        seaLevelMutable.method_33098(seaLevel);
        for (int candidateMiddleMinorAxisOffset = this.width / 2 + this.widthOffset + 1; candidateMiddleMinorAxisOffset < 16 - this.width / 2 - this.widthOffset; ++candidateMiddleMinorAxisOffset) {
            for (int candidateStartMajorAxisOffset = 0; candidateStartMajorAxisOffset < 16; ++candidateStartMajorAxisOffset) {
                int minorAxisSolidOffset;
                int minorAxisSolidDist;
                int direction;
                class_2338 endingPos;
                class_2338 startingPos = this.isZAxis ? new class_2338(blockPos.method_10263() + candidateMiddleMinorAxisOffset, seaLevel, blockPos.method_10260() + candidateStartMajorAxisOffset) : new class_2338(blockPos.method_10263() + candidateStartMajorAxisOffset, seaLevel, blockPos.method_10260() + candidateMiddleMinorAxisOffset);
                class_2338 class_23382 = endingPos = this.isZAxis ? new class_2338(blockPos.method_10263() + candidateMiddleMinorAxisOffset, seaLevel, blockPos.method_10260() + candidateStartMajorAxisOffset + this.length + 1) : new class_2338(blockPos.method_10263() + candidateStartMajorAxisOffset + this.length + 1, seaLevel, blockPos.method_10260() + candidateMiddleMinorAxisOffset);
                if (!placementContext.method_30461(startingPos).method_26225() || !placementContext.method_30461(endingPos).method_26225() || placementContext.method_30460(class_2902.class_2903.field_13202, startingPos.method_10263(), startingPos.method_10260()) > seaLevel + 1 || placementContext.method_30460(class_2902.class_2903.field_13202, endingPos.method_10263(), endingPos.method_10260()) > seaLevel + 1) continue;
                int numSolidBlocks = 1;
                Iterator iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block2: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= this.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (this.isZAxis) {
                            seaLevelMutable.method_10103(startingPos.method_10263() + minorAxisSolidOffset, startingPos.method_10264(), startingPos.method_10260());
                        } else {
                            seaLevelMutable.method_10103(startingPos.method_10263(), startingPos.method_10264(), startingPos.method_10260() + minorAxisSolidOffset);
                        }
                        if (!placementContext.method_30461((class_2338)seaLevelMutable).method_26225() || placementContext.method_30460(class_2902.class_2903.field_13202, seaLevelMutable.method_10263(), seaLevelMutable.method_10260()) > seaLevel + 1) continue block2;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < this.numSolidBlocksNeeded) continue;
                numSolidBlocks = 1;
                iterator = Lists.newArrayList((Object[])new Integer[]{-1, 1}).iterator();
                block4: while (iterator.hasNext()) {
                    direction = (Integer)iterator.next();
                    for (minorAxisSolidDist = 1; minorAxisSolidDist <= this.width / 2; ++minorAxisSolidDist) {
                        minorAxisSolidOffset = direction * minorAxisSolidDist;
                        if (this.isZAxis) {
                            seaLevelMutable.method_10103(endingPos.method_10263() + minorAxisSolidOffset, endingPos.method_10264(), endingPos.method_10260());
                        } else {
                            seaLevelMutable.method_10103(endingPos.method_10263(), endingPos.method_10264(), endingPos.method_10260() + minorAxisSolidOffset);
                        }
                        if (!placementContext.method_30461((class_2338)seaLevelMutable).method_26225() || placementContext.method_30460(class_2902.class_2903.field_13202, seaLevelMutable.method_10263(), seaLevelMutable.method_10260()) > seaLevel + 1) continue block4;
                        ++numSolidBlocks;
                    }
                }
                if (numSolidBlocks < this.numSolidBlocksNeeded) continue;
                boolean isAllWater = true;
                block6: for (int minorAxisWaterOffset = -this.width / 2; minorAxisWaterOffset <= this.width / 2; ++minorAxisWaterOffset) {
                    for (int majorAxisWaterOffset = this.minWaterZ; majorAxisWaterOffset <= this.maxWaterZ; ++majorAxisWaterOffset) {
                        if (this.isZAxis) {
                            seaLevelMutable.method_10103(startingPos.method_10263() + minorAxisWaterOffset, seaLevel, startingPos.method_10260() + majorAxisWaterOffset);
                        } else {
                            seaLevelMutable.method_10103(startingPos.method_10263() + majorAxisWaterOffset, seaLevel, startingPos.method_10260() + minorAxisWaterOffset);
                        }
                        if (placementContext.method_30461((class_2338)seaLevelMutable).method_51176()) continue;
                        isAllWater = false;
                        continue block6;
                    }
                }
                if (!isAllWater) continue;
                return this.isZAxis ? Stream.of(new class_2338(startingPos.method_10263() - this.width / 2 - this.widthOffset, seaLevel, startingPos.method_10260() + 1)) : Stream.of(new class_2338(startingPos.method_10263() + 1, seaLevel, startingPos.method_10260() + this.width / 2 + this.widthOffset));
            }
        }
        return Stream.empty();
    }

    public class_6798<?> method_39615() {
        return PlacementModifierTypeModule.BRIDGE_PLACEMENT;
    }
}

