/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.ControllerManager;
import dev.isxander.controlify.config.GlobalSettings;
import dev.isxander.controlify.config.TypeAdapters;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.joystick.CompoundJoystickInfo;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ControlifyConfig {
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("controlify.json");
    private static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeHierarchyAdapter(Class.class, (Object)new TypeAdapters.ClassTypeAdapter()).registerTypeHierarchyAdapter(Version.class, (Object)new TypeAdapters.VersionTypeAdapter()).registerTypeHierarchyAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    private final Controlify controlify;
    private String currentControllerUid;
    private JsonObject controllerData = new JsonObject();
    private Map<String, CompoundJoystickInfo> compoundJoysticks = Map.of();
    private GlobalSettings globalSettings = new GlobalSettings();
    private boolean firstLaunch;
    private Version lastSeenVersion = null;
    private boolean dirty;

    public ControlifyConfig(Controlify controlify) {
        this.controlify = controlify;
    }

    public void save() {
        Log.LOGGER.info("Saving Controlify config...");
        try {
            Files.deleteIfExists(CONFIG_PATH);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)this.generateConfig()), StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
            this.dirty = false;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save config!", e);
        }
    }

    public void load() {
        Log.LOGGER.info("Loading Controlify config...");
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            this.firstLaunch = true;
            if (this.lastSeenVersion == null) {
                try {
                    this.lastSeenVersion = Version.parse((String)"0.0.0");
                }
                catch (VersionParsingException e) {
                    throw new RuntimeException(e);
                }
                this.setDirty();
            }
            this.save();
            return;
        }
        try {
            this.applyConfig((JsonObject)GSON.fromJson(Files.readString(CONFIG_PATH), JsonObject.class));
        }
        catch (Exception e) {
            Log.LOGGER.error("Failed to load Controlify config!", (Throwable)e);
        }
        if (this.dirty) {
            DebugLog.log("Config was dirty after load, saving...", new Object[0]);
            this.save();
        }
    }

    private JsonObject generateConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("last_seen_version", Log.VERSION.getFriendlyString());
        JsonObject newControllerData = this.controllerData.deepCopy();
        for (Controller<?, ?> controller : ControllerManager.getConnectedControllers()) {
            newControllerData.add(controller.uid(), (JsonElement)this.generateControllerConfig(controller));
        }
        this.controllerData = newControllerData;
        this.currentControllerUid = this.controlify.getCurrentController().map(Controller::uid).orElse(null);
        config.addProperty("current_controller", this.currentControllerUid);
        config.add("controllers", (JsonElement)this.controllerData);
        config.add("compound_joysticks", GSON.toJsonTree((Object)this.compoundJoysticks.values().toArray(new CompoundJoystickInfo[0])));
        config.add("global", GSON.toJsonTree((Object)this.globalSettings));
        return config;
    }

    private JsonObject generateControllerConfig(Controller<?, ?> controller) {
        JsonObject object = new JsonObject();
        object.add("config", GSON.toJsonTree(controller.config()));
        object.add("bindings", (JsonElement)controller.bindings().toJson());
        return object;
    }

    private void applyConfig(JsonObject object) throws VersionParsingException {
        JsonObject controllers;
        if (this.lastSeenVersion == null) {
            boolean hasLastSeenVersion = object.has("last_seen_version");
            Version version = this.lastSeenVersion = hasLastSeenVersion ? Version.parse((String)object.get("last_seen_version").getAsString()) : Version.parse((String)"0.0.0");
            if (!hasLastSeenVersion || this.lastSeenVersion.compareTo((Object)Log.VERSION) < 0) {
                this.setDirty();
            }
        }
        this.globalSettings = (GlobalSettings)GSON.fromJson((JsonElement)object.getAsJsonObject("global"), GlobalSettings.class);
        if (this.globalSettings == null) {
            this.globalSettings = new GlobalSettings();
            this.setDirty();
        }
        if ((controllers = object.getAsJsonObject("controllers")) != null) {
            this.controllerData = controllers;
            for (Controller<?, ?> controller : ControllerManager.getConnectedControllers()) {
                this.loadOrCreateControllerData(controller);
            }
        } else {
            this.setDirty();
        }
        this.compoundJoysticks = object.has("compound_joysticks") ? object.getAsJsonArray("compound_joysticks").asList().stream().map(element -> (CompoundJoystickInfo)GSON.fromJson(element, CompoundJoystickInfo.class)).collect(Collectors.toMap(info -> info.type().mappingId(), Function.identity())) : Map.of();
        if (object.has("current_controller")) {
            JsonElement element2 = object.get("current_controller");
            this.currentControllerUid = element2.isJsonNull() ? null : element2.getAsString();
        } else {
            this.currentControllerUid = this.controlify.getCurrentController().map(Controller::uid).orElse(null);
            this.setDirty();
        }
    }

    public boolean loadOrCreateControllerData(Controller<?, ?> controller) {
        String uid = controller.uid();
        if (this.controllerData.has(uid)) {
            DebugLog.log("Loading controller data for " + uid, new Object[0]);
            this.applyControllerConfig(controller, this.controllerData.getAsJsonObject(uid));
            return true;
        }
        DebugLog.log("New controller found, setting config dirty ({})", uid);
        this.setDirty();
        return false;
    }

    private void applyControllerConfig(Controller<?, ?> controller, JsonObject object) {
        try {
            this.dirty |= !controller.bindings().fromJson(object.getAsJsonObject("bindings"));
            controller.setConfig(GSON, (JsonElement)object.getAsJsonObject("config"));
        }
        catch (Exception e) {
            Log.LOGGER.error("Failed to load controller data for " + controller.uid() + ". Resetting to default!", (Throwable)e);
            controller.resetConfig();
            this.save();
        }
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void saveIfDirty() {
        if (this.dirty) {
            DebugLog.log("Config is dirty. Saving...", new Object[0]);
            this.save();
        }
    }

    public Map<String, CompoundJoystickInfo> getCompoundJoysticks() {
        return this.compoundJoysticks;
    }

    public GlobalSettings globalSettings() {
        return this.globalSettings;
    }

    public boolean isFirstLaunch() {
        return this.firstLaunch;
    }

    public boolean isLastSeenVersionLessThan(Version version) {
        return this.lastSeenVersion.compareTo((Object)version) < 0;
    }

    public boolean isLastSeenVersionLessThan(String version) {
        try {
            return this.isLastSeenVersionLessThan(Version.parse((String)version));
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public String currentControllerUid() {
        return this.currentControllerUid;
    }
}

