/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepad;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControllerBindings;
import dev.isxander.controlify.controller.AbstractController;
import dev.isxander.controlify.controller.BatteryLevel;
import dev.isxander.controlify.controller.gamepad.BuiltinGamepadTheme;
import dev.isxander.controlify.controller.gamepad.GamepadConfig;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.BasicGamepadInputDriver;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.GamepadDrivers;
import dev.isxander.controlify.driver.SteamDeckDriver;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.rumble.RumbleManager;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.Log;
import java.util.Set;
import net.minecraft.class_2960;
import org.lwjgl.glfw.GLFW;

public class GamepadController
extends AbstractController<GamepadState, GamepadConfig> {
    private GamepadState state = GamepadState.EMPTY;
    private GamepadState prevState = GamepadState.EMPTY;
    private final RumbleManager rumbleManager;
    private GamepadState.GyroState absoluteGyro = new GamepadState.GyroState();
    public final GamepadDrivers drivers;
    private final Set<Driver> uniqueDrivers;
    private int antiSnapbackTicksL;
    private int antiSnapbackTicksR;

    public GamepadController(int joystickId, ControllerHIDService.ControllerHIDInfo hidInfo) {
        super(joystickId, hidInfo);
        if (!GLFW.glfwJoystickIsGamepad((int)joystickId)) {
            throw new IllegalArgumentException("Joystick " + joystickId + " is not a gamepad!");
        }
        this.drivers = GamepadDrivers.forController(joystickId, hidInfo.hidDevice());
        this.uniqueDrivers = this.drivers.getUniqueDrivers();
        this.drivers.printDrivers();
        if (!this.name.startsWith(this.type().friendlyName())) {
            this.setName(this.drivers.nameProviderDriver().getName());
        }
        this.rumbleManager = new RumbleManager(this);
        this.defaultConfig = new GamepadConfig();
        this.config = new GamepadConfig();
        if (hidInfo.hidDevice().map(hid -> SteamDeckDriver.isSteamDeck(hid.vendorID(), hid.productID())).orElse(false).booleanValue()) {
            ((GamepadConfig)this.defaultConfig).mixedInput = true;
            ((GamepadConfig)this.config).mixedInput = true;
        }
        this.bindings = new ControllerBindings<GamepadState>(this);
        ((GamepadConfig)this.config).validateRadialActions(this.bindings);
        ((GamepadConfig)this.defaultConfig).validateRadialActions(this.bindings);
    }

    @Override
    public GamepadState state() {
        return this.state;
    }

    @Override
    public GamepadState prevState() {
        return this.prevState;
    }

    @Override
    public void updateState() {
        this.prevState = this.state;
        this.uniqueDrivers.forEach(Driver::update);
        BasicGamepadInputDriver.BasicGamepadState basicState = this.drivers.basicGamepadInputDriver().getBasicGamepadState();
        GamepadState.AxesState deadzoneAxesState = basicState.axes().leftJoystickDeadZone(((GamepadConfig)this.config()).getLeftStickDeadzone()).rightJoystickDeadZone(((GamepadConfig)this.config()).getRightStickDeadzone());
        if (DebugProperties.USE_SNAPBACK) {
            if (this.antiSnapbackTicksL > 0) {
                deadzoneAxesState = deadzoneAxesState.neutraliseLeft();
                --this.antiSnapbackTicksL;
            } else if (ControllerUtils.shouldApplyAntiSnapBack(deadzoneAxesState.leftStickX(), deadzoneAxesState.leftStickY(), this.prevState.gamepadAxes().leftStickX(), this.prevState.gamepadAxes().leftStickY(), 0.08f)) {
                this.antiSnapbackTicksL = 2;
                deadzoneAxesState = deadzoneAxesState.neutraliseLeft();
            }
            if (this.antiSnapbackTicksR > 0) {
                deadzoneAxesState = deadzoneAxesState.neutraliseRight();
                --this.antiSnapbackTicksR;
            } else if (ControllerUtils.shouldApplyAntiSnapBack(deadzoneAxesState.rightStickX(), deadzoneAxesState.rightStickY(), this.prevState.gamepadAxes().rightStickX(), this.prevState.gamepadAxes().rightStickY(), 0.08f)) {
                this.antiSnapbackTicksR = 2;
                deadzoneAxesState = deadzoneAxesState.neutraliseRight();
            }
        }
        GamepadState.GyroState gyroState = new GamepadState.GyroState(this.drivers.gyroDriver().getGyroState()).sub(((GamepadConfig)this.config()).gyroCalibration);
        this.absoluteGyro.add(gyroState);
        this.state = new GamepadState(deadzoneAxesState, basicState.axes(), basicState.buttons(), gyroState, this.absoluteGyro);
        if (DebugProperties.PRINT_TRIGGER_STATE) {
            Log.LOGGER.info("Left Trigger: " + this.state.gamepadAxes().leftTrigger());
            Log.LOGGER.info("Right Trigger: " + this.state.gamepadAxes().rightTrigger());
        }
    }

    public GamepadState.GyroState absoluteGyroState() {
        return this.absoluteGyro;
    }

    public boolean hasGyro() {
        return this.drivers.gyroDriver().isGyroSupported();
    }

    @Override
    public void clearState() {
        this.state = GamepadState.EMPTY;
    }

    @Override
    public boolean setRumble(float strongMagnitude, float weakMagnitude) {
        if (!this.supportsRumble() || !((GamepadConfig)this.config()).allowVibrations) {
            return false;
        }
        return this.drivers.rumbleDriver().rumble(Math.min(strongMagnitude, 1.0f), Math.min(weakMagnitude, 1.0f));
    }

    @Override
    public boolean supportsRumble() {
        return this.drivers.rumbleDriver().isRumbleSupported();
    }

    @Override
    public RumbleManager rumbleManager() {
        return this.rumbleManager;
    }

    @Override
    public BatteryLevel batteryLevel() {
        return this.drivers.batteryDriver().getBatteryLevel();
    }

    @Override
    public void close() {
        this.uniqueDrivers.forEach(Driver::close);
    }

    @Override
    public class_2960 icon() {
        String theme = ((GamepadConfig)this.config()).theme == BuiltinGamepadTheme.DEFAULT ? this.type().themeId() : ((GamepadConfig)this.config()).theme.id();
        return Controlify.id("textures/gui/gamepad/" + theme + "/icon.png");
    }

    @Override
    public int axisCount() {
        return 6;
    }

    @Override
    public int buttonCount() {
        return 15;
    }

    @Override
    public int hatCount() {
        return 0;
    }
}

