/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.driver.BasicGamepadInputDriver;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.NameProviderDriver;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class GLFWGamepadDriver
implements BasicGamepadInputDriver,
NameProviderDriver,
GUIDProvider {
    private final int jid;
    private final String guid;
    private BasicGamepadInputDriver.BasicGamepadState state = new BasicGamepadInputDriver.BasicGamepadState(GamepadState.AxesState.EMPTY, GamepadState.ButtonState.EMPTY);

    public GLFWGamepadDriver(int jid) {
        this.jid = jid;
        this.guid = GLFW.glfwGetJoystickGUID((int)jid);
    }

    @Override
    public void update() {
        GLFWGamepadState state = GLFWGamepadState.create();
        GLFW.glfwGetGamepadState((int)this.jid, (GLFWGamepadState)state);
        GamepadState.AxesState axes = new GamepadState.AxesState(state.axes(0), state.axes(1), state.axes(2), state.axes(3), (1.0f + state.axes(4)) / 2.0f, (1.0f + state.axes(5)) / 2.0f);
        GamepadState.ButtonState buttons = new GamepadState.ButtonState(state.buttons(0) == 1, state.buttons(1) == 1, state.buttons(2) == 1, state.buttons(3) == 1, state.buttons(4) == 1, state.buttons(5) == 1, state.buttons(6) == 1, state.buttons(7) == 1, state.buttons(8) == 1, state.buttons(11) == 1, state.buttons(13) == 1, state.buttons(14) == 1, state.buttons(12) == 1, state.buttons(9) == 1, state.buttons(10) == 1);
        this.state = new BasicGamepadInputDriver.BasicGamepadState(axes, buttons);
    }

    @Override
    public BasicGamepadInputDriver.BasicGamepadState getBasicGamepadState() {
        return this.state;
    }

    @Override
    public String getBasicGamepadDetails() {
        return "GLFW Gamepad";
    }

    @Override
    public String getName() {
        String name = GLFW.glfwGetGamepadName((int)this.jid);
        if ("XInput Gamepad (GLFW)".equals(name)) {
            return GLFW.glfwGetJoystickName((int)this.jid);
        }
        return name;
    }

    @Override
    public String getNameProviderDetails() {
        return "GLFW Gamepad";
    }

    @Override
    public String getGUID() {
        return this.guid;
    }

    @Override
    public String getGUIDProviderDetails() {
        return "GLFW Gamepad";
    }
}

