/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.utils.Log;
import io.github.libsdl4j.api.error.SdlError;
import io.github.libsdl4j.api.joystick.SDL_Joystick;
import io.github.libsdl4j.api.joystick.SdlJoystick;

public class SDL2JoystickDriver
implements RumbleDriver {
    private final SDL_Joystick ptrJoystick;
    private final boolean isRumbleSupported;

    public SDL2JoystickDriver(int jid) {
        this.ptrJoystick = SdlJoystick.SDL_JoystickOpen((int)jid);
        this.isRumbleSupported = SdlJoystick.SDL_JoystickHasRumble((SDL_Joystick)this.ptrJoystick);
    }

    @Override
    public void update() {
    }

    @Override
    public boolean rumble(float strongMagnitude, float weakMagnitude) {
        if (SdlJoystick.SDL_JoystickRumble((SDL_Joystick)this.ptrJoystick, (short)((short)(strongMagnitude * 65535.0f)), (short)((short)(weakMagnitude * 65535.0f)), (int)0) != 0) {
            Log.LOGGER.error("Could not rumble controller: " + SdlError.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public boolean isRumbleSupported() {
        return this.isRumbleSupported;
    }

    @Override
    public String getRumbleDetails() {
        return "SDL2joy supported=" + this.isRumbleSupported();
    }

    @Override
    public void close() {
        SdlJoystick.SDL_JoystickClose((SDL_Joystick)this.ptrJoystick);
    }
}

