/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.controllers;

import dev.isxander.controlify.bindings.GamepadBind;
import dev.isxander.controlify.bindings.GamepadBinds;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.gui.controllers.AbstractBindController;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.Optional;

public class GamepadBindController
extends AbstractBindController<GamepadState> {
    public GamepadBindController(Option<IBind<GamepadState>> option, GamepadController controller) {
        super(option, controller);
    }

    @Override
    public AbstractBindController.AbstractBindControllerElement<GamepadState> provideWidget(YACLScreen yaclScreen, Dimension<Integer> dimension) {
        return new BindButtonWidget(this, yaclScreen, dimension);
    }

    public static class BindButtonWidget
    extends AbstractBindController.AbstractBindControllerElement<GamepadState> {
        public BindButtonWidget(GamepadBindController control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim);
        }

        @Override
        public Optional<IBind<GamepadState>> getPressedBind() {
            GamepadController gamepad = (GamepadController)((AbstractBindController)this.control).controller;
            for (GamepadBinds bindType : GamepadBinds.values()) {
                GamepadBind bind = bindType.forGamepad(gamepad);
                if (!bind.held(gamepad.state()) || bind.held(gamepad.prevState())) continue;
                return Optional.of(bind);
            }
            return Optional.empty();
        }
    }
}

