/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.ControllerManager;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.gamepad.GamepadConfig;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.controller.joystick.JoystickConfig;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.mapping.UnmappedJoystickMapping;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_7919;

public class ControllerCalibrationScreen
extends class_437
implements DontInteruptScreen {
    private static final int CALIBRATION_TIME = 100;
    private static final class_2960 GUI_BARS_LOCATION = new class_2960("textures/gui/bars.png");
    protected final Controller<?, ?> controller;
    private final Supplier<class_437> parent;
    private class_5489 waitLabel;
    private class_5489 infoLabel;
    private class_5489 completeLabel;
    protected class_4185 readyButton;
    protected class_4185 laterButton;
    protected boolean calibrating = false;
    protected boolean calibrated = false;
    protected int calibrationTicks = 0;
    private final double[] axisData;
    private GamepadState.GyroState accumulatedGyroVelocity = new GamepadState.GyroState();

    public ControllerCalibrationScreen(Controller<?, ?> controller, class_437 parent) {
        this(controller, () -> parent);
    }

    public ControllerCalibrationScreen(Controller<?, ?> controller, Supplier<class_437> parent) {
        super((class_2561)class_2561.method_43471((String)"controlify.calibration.title"));
        this.controller = controller;
        this.parent = parent;
        this.axisData = new double[controller.axisCount() * 100];
    }

    protected void method_25426() {
        this.readyButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.calibration.ready"), btn -> this.onButtonPress()).method_46432(150).method_46433(this.field_22789 / 2 - 150 - 5, this.field_22790 - 8 - 20).method_46431();
        this.method_37063((class_364)this.readyButton);
        this.laterButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controlify.calibration.later"), btn -> this.onLaterButtonPress()).method_46432(150).method_46433(this.field_22789 / 2 + 5, this.field_22790 - 8 - 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controlify.calibration.later.tooltip"))).method_46431();
        this.method_37063((class_364)this.laterButton);
        this.infoLabel = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43471((String)"controlify.calibration.info"), (int)(this.field_22789 - 30));
        this.waitLabel = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43471((String)"controlify.calibration.wait"), (int)(this.field_22789 - 30));
        this.completeLabel = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43471((String)"controlify.calibration.complete"), (int)(this.field_22789 - 30));
    }

    protected void startCalibration() {
        this.calibrating = true;
        this.readyButton.field_22763 = false;
        this.readyButton.method_25355((class_2561)class_2561.method_43471((String)"controlify.calibration.calibrating"));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"controlify.calibration.title", (Object[])new Object[]{this.controller.name()}).method_27692(class_124.field_1067), this.field_22789 / 2, 8, -1);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(2.0f, 2.0f, 1.0f);
        this.drawBar(graphics, this.field_22789 / 2 / 2, 15, 1.0f, 0);
        float progress = ((float)(this.calibrationTicks - 1) + delta) / 100.0f;
        if (progress > 0.0f) {
            this.drawBar(graphics, this.field_22789 / 2 / 2, 15, progress, 5);
        }
        graphics.method_51448().method_22909();
        class_5489 label = this.calibrating ? this.waitLabel : (this.calibrated ? this.completeLabel : this.infoLabel);
        label.method_30888(graphics, this.field_22789 / 2, 55);
        graphics.method_51448().method_22903();
        int n = this.readyButton.method_46427();
        Objects.requireNonNull(this.field_22793);
        float scale = Math.min(3.0f, (float)(n - (55 + 9 * label.method_30887()) - 2) / 64.0f);
        class_4587 class_45872 = graphics.method_51448();
        float f = (float)this.field_22789 / 2.0f - 32.0f * scale;
        Objects.requireNonNull(this.field_22793);
        class_45872.method_46416(f, (float)(55 + 9 * label.method_30887()), 0.0f);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        graphics.method_25290(this.controller.icon(), 0, 0, 0.0f, 0.0f, 64, 64, 64, 64);
        graphics.method_51448().method_22909();
    }

    private void drawBar(class_332 graphics, int centerX, int y, float progress, int vOffset) {
        progress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        int x = centerX - 91;
        graphics.method_25302(GUI_BARS_LOCATION, x, y, 0, 30 + vOffset, (int)(progress * 182.0f), 5);
    }

    public void method_25393() {
        if (!ControllerManager.isControllerConnected(this.controller.uid())) {
            this.method_25419();
            return;
        }
        if (!this.calibrating) {
            return;
        }
        if (this.stateChanged()) {
            this.calibrationTicks = 0;
            Arrays.fill(this.axisData, 0.0);
            this.accumulatedGyroVelocity = new GamepadState.GyroState();
        }
        if (this.calibrationTicks < 100) {
            this.processAxisData(this.calibrationTicks);
            this.processGyroData();
            ++this.calibrationTicks;
        } else {
            this.calibrateAxis();
            this.generateGyroCalibration();
            this.calibrating = false;
            this.calibrated = true;
            this.readyButton.field_22763 = true;
            this.readyButton.method_25355((class_2561)class_2561.method_43471((String)"controlify.calibration.done"));
            ((ControllerConfig)this.controller.config()).deadzonesCalibrated = true;
            ((ControllerConfig)this.controller.config()).delayedCalibration = false;
            Controlify.instance().setCurrentController(this.controller);
        }
    }

    private void processAxisData(int tick) {
        List<Float> axes = this.controller.state().rawAxes();
        System.arraycopy(axes.stream().mapToDouble(a -> a.floatValue()).toArray(), 0, this.axisData, tick * axes.size(), axes.size());
    }

    private void processGyroData() {
        GamepadController gamepad;
        Controller<?, ?> controller = this.controller;
        if (controller instanceof GamepadController && (gamepad = (GamepadController)controller).hasGyro()) {
            this.accumulatedGyroVelocity.add(gamepad.drivers.gyroDriver().getGyroState());
        }
    }

    private void calibrateAxis() {
        int axisCount = this.controller.axisCount();
        for (int axis = 0; axis < axisCount; ++axis) {
            JoystickController joystick;
            Object object;
            boolean triggerAxis = true;
            float maxAbs = 0.0f;
            for (int tick = 0; tick < 100; ++tick) {
                float axisValue = (float)this.axisData[tick * axisCount + axis];
                if (axisValue != -1.0f) {
                    triggerAxis = false;
                }
                maxAbs = Math.max(maxAbs, Math.abs(axisValue));
            }
            if (triggerAxis && (object = this.controller) instanceof JoystickController && (object = (joystick = (JoystickController)object).mapping()) instanceof UnmappedJoystickMapping) {
                UnmappedJoystickMapping mapping = (UnmappedJoystickMapping)object;
                ((JoystickConfig)joystick.config()).setDeadzone(axis, 0.0f);
                ((JoystickConfig)joystick.config()).setTriggerAxis(axis, true);
                mapping.setTriggerAxes(axis, true);
                continue;
            }
            ((ControllerConfig)this.controller.config()).setDeadzone(axis, maxAbs + 0.08f);
        }
    }

    private void generateGyroCalibration() {
        GamepadController gamepad;
        Controller<?, ?> controller = this.controller;
        if (controller instanceof GamepadController && (gamepad = (GamepadController)controller).hasGyro()) {
            ((GamepadConfig)gamepad.config()).gyroCalibration = this.accumulatedGyroVelocity.div(100.0f);
        }
    }

    private boolean stateChanged() {
        float amt = 0.4f;
        return this.controller.state().axes().stream().anyMatch(axis -> Math.abs(axis.floatValue() - this.controller.prevState().axes().get(this.controller.state().axes().indexOf(axis)).floatValue()) > amt);
    }

    private void onButtonPress() {
        if (!this.calibrated) {
            this.startCalibration();
            this.method_37066((class_364)this.laterButton);
            this.readyButton.method_46421(this.field_22789 / 2 - 75);
        } else {
            this.method_25419();
        }
    }

    private void onLaterButtonPress() {
        if (!this.calibrated) {
            if (!((ControllerConfig)this.controller.config()).deadzonesCalibrated) {
                ((ControllerConfig)this.controller.config()).delayedCalibration = true;
                Controlify.instance().config().setDirty();
                Controlify.instance().setCurrentController(null);
            }
            this.method_25419();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent.get());
    }

    public boolean method_25422() {
        return false;
    }
}

