/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2096;
import net.minecraft.class_2596;
import net.minecraft.class_3244;
import net.minecraft.class_4050;
import net.minecraft.class_5629;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.util.VersionUtils;

public final class ReflectionUtils {
    public static final Class<?> LITERAL_TEXT;
    public static final Class<?> ENTITY_DAMAGE_SOURCE;
    public static final MethodHandle GET_ATTACKER;
    public static final MethodHandle GET_FLYING_SPEED;
    public static final MethodHandle SET_FLYING_SPEED;
    public static final MethodHandle GET_MOUNTED_HEIGHT_OFFSET;
    public static final MethodHandle SEND_PACKET;
    public static final MethodHandle IS_DUMMY;

    @Nullable
    public static class_1297 getAttacker(class_1282 source) {
        if (ENTITY_DAMAGE_SOURCE != null) {
            if (ENTITY_DAMAGE_SOURCE.isInstance(source)) {
                try {
                    return GET_ATTACKER.invoke(ENTITY_DAMAGE_SOURCE.cast(source));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        return source.method_5529();
    }

    public static float getFlyingSpeed(class_1309 entity) {
        try {
            return GET_FLYING_SPEED.invoke(entity);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFlyingSpeed(class_1309 entity, float speed) {
        try {
            SET_FLYING_SPEED.invoke(entity, speed);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static double getMountedHeightOffset(class_1297 entity) {
        if (GET_MOUNTED_HEIGHT_OFFSET != null) {
            try {
                return GET_MOUNTED_HEIGHT_OFFSET.invoke(entity);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return (double)entity.method_18377((class_4050)entity.method_18376()).field_18068 * 0.75;
    }

    public static void sendPacket(class_3244 handler, class_2596<?> packet) {
        if (SEND_PACKET != null) {
            try {
                if (VersionUtils.MINOR <= 16) {
                    SEND_PACKET.invoke(handler, packet);
                } else {
                    SEND_PACKET.invoke((class_5629)handler, packet);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return;
        }
        handler.method_14364(packet);
    }

    public static boolean isDummy(class_2096<?> range) {
        if (IS_DUMMY != null) {
            try {
                return IS_DUMMY.invoke(range);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return range.method_9041();
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    public static <T> Optional<Constructor<T>> getConstructor(Optional<Class<T>> clazz, Class<?> ... params) {
        return clazz.map(c -> {
            try {
                return c.getConstructor(params);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }

    static {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        Class[] c = new Class[2];
        try {
            Method m;
            boolean is1201Minus;
            boolean is117Plus = VersionUtils.MINOR >= 17;
            boolean is118Minus = VersionUtils.MINOR <= 18;
            boolean is1193Minus = VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 3;
            boolean bl = is1201Minus = VersionUtils.MINOR < 20 || VersionUtils.MINOR == 20 && VersionUtils.PATCH <= 1;
            if (is118Minus) {
                mapped = mappingResolver.mapClassName("intermediary", "net.minecraft.class_2585");
                c[0] = Class.forName(mapped);
            }
            if (is1193Minus) {
                mapped = mappingResolver.mapClassName("intermediary", "net.minecraft.class_1285");
                c[1] = Class.forName(mapped);
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_1285", "method_5529", "()Lnet/minecraft/class_1297;");
                m = c[1].getMethod(mapped, new Class[0]);
                h.put(0, (Object)lookup.unreflect(m));
                mapped = mappingResolver.mapFieldName("intermediary", "net.minecraft.class_1309", "field_6281", "F");
                Field f = class_1309.class.getField(mapped);
                f.setAccessible(true);
                h.put(1, (Object)lookup.unreflectGetter(f));
                h.put(2, (Object)lookup.unreflectSetter(f));
            }
            if (is1201Minus) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_1297", "method_5621", "()D");
                m = class_1297.class.getMethod(mapped, new Class[0]);
                h.put(3, (Object)lookup.unreflect(m));
                mapped = mappingResolver.mapMethodName("intermediary", is117Plus ? "net.minecraft.class_5629" : "net.minecraft.class_3244", "method_14364", "(Lnet/minecraft/class_2596;)V");
                m = (is117Plus ? class_5629.class : class_3244.class).getMethod(mapped, class_2596.class);
                h.put(4, (Object)lookup.unreflect(m));
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2096", "method_9041", "()Z");
                m = class_2096.class.getMethod(mapped, new Class[0]);
                h.put(5, (Object)lookup.unreflect(m));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            Pehkui.LOGGER.error("Current name lookup: {}", new Object[]{mapped});
            Pehkui.LOGGER.catching((Throwable)e);
        }
        LITERAL_TEXT = c[0];
        ENTITY_DAMAGE_SOURCE = c[1];
        GET_ATTACKER = (MethodHandle)h.get(0);
        GET_FLYING_SPEED = (MethodHandle)h.get(1);
        SET_FLYING_SPEED = (MethodHandle)h.get(2);
        GET_MOUNTED_HEIGHT_OFFSET = (MethodHandle)h.get(3);
        SEND_PACKET = (MethodHandle)h.get(4);
        IS_DUMMY = (MethodHandle)h.get(5);
    }
}

