/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.GravityChangerCompatibility;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ReflectionUtils;

public class ScaleUtils {
    public static final double DEFAULT_MAXIMUM_REACH_BELOW_1_17 = 128.0;
    public static final float DEFAULT_MINIMUM_POSITIVE_SCALE = 1.2621775E-29f;
    public static final float DEFAULT_MAXIMUM_POSITIVE_SCALE = 4.2949673E9f;
    private static final boolean NETWORKING_API_LOADED = ModLoaderUtils.isModLoaded("fabric-networking-api-v1");
    private static final ThreadLocal<Collection<ScaleData>> SYNCED_SCALE_DATA = ThreadLocal.withInitial(ArrayList::new);

    public static void tickScale(ScaleData data) {
        ScaleType type = data.getScaleType();
        ((ScaleEventCallback)type.getPreTickEvent().invoker()).onEvent(data);
        data.tick();
        ((ScaleEventCallback)type.getPostTickEvent().invoker()).onEvent(data);
    }

    public static void loadAverageScales(class_1297 target, class_1297 source, class_1297 ... sources) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleData scaleData = type.getScaleData(target);
            ScaleData[] scales = new ScaleData[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                scales[i] = type.getScaleData(sources[i]);
            }
            scaleData.averagedFromScales(type.getScaleData(source), scales);
        }
    }

    public static void loadScaleOnRespawn(class_1297 target, class_1297 source, boolean alive) {
        if (alive || PehkuiConfig.COMMON.keepAllScalesOnRespawn.get().booleanValue()) {
            ScaleUtils.loadScale(target, source);
            return;
        }
        List<String> keptScales = PehkuiConfig.COMMON.scalesKeptOnRespawn.get();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            ScaleType type = (ScaleType)entry.getValue();
            ScaleData sourceData = type.getScaleData(source);
            if (!sourceData.shouldPersist() && !keptScales.contains(((class_2960)entry.getKey()).toString())) continue;
            ScaleData targetData = type.getScaleData(target);
            targetData.fromScale(sourceData);
            SortedSet<ScaleModifier> targetModifiers = targetData.getBaseValueModifiers();
            targetModifiers.clear();
            targetModifiers.addAll(sourceData.getBaseValueModifiers());
        }
    }

    public static void loadScale(class_1297 target, class_1297 source) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            type.getScaleData(target).fromScale(type.getScaleData(source));
        }
    }

    public static float modifyLimbDistance(float value, class_1297 entity) {
        float scale = ScaleUtils.getMotionScale(entity);
        return ScaleUtils.divideClamped(value, scale);
    }

    public static float divideClamped(float dividend, float divisor) {
        return ScaleUtils.divideClamped(dividend, divisor, 1.2621775E-29f, 4.2949673E9f);
    }

    public static float divideClamped(float dividend, float divisor, float minLimit, float maxLimit) {
        if (divisor == 1.0f) {
            return dividend;
        }
        float ret = dividend / divisor;
        if (ret == Float.POSITIVE_INFINITY) {
            return maxLimit;
        }
        if (ret == Float.NEGATIVE_INFINITY) {
            return -maxLimit;
        }
        if (ret > minLimit || ret < -minLimit) {
            return ret;
        }
        return ret < 0.0f ? -minLimit : minLimit;
    }

    public static float setScaleOfDrop(class_1297 entity, class_1297 source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getDropScale(source));
    }

    public static float setScaleOfProjectile(class_1297 entity, class_1297 source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getProjectileScale(source));
    }

    public static float setScaleOnSpawn(class_1297 entity, float scale) {
        if (scale != 1.0f) {
            ScaleTypes.BASE.getScaleData(entity).setScale(scale);
        }
        return scale;
    }

    public static class_2487 buildScaleNbtFromPacketByteBuf(class_2540 buffer) {
        byte persistent;
        class_2487 scaleData = new class_2487();
        float scale = buffer.readFloat();
        float prevScale = buffer.readFloat();
        float fromScale = buffer.readFloat();
        float toScale = buffer.readFloat();
        int scaleTicks = buffer.readInt();
        int totalScaleTicks = buffer.readInt();
        scaleData.method_10548("scale", scale);
        scaleData.method_10548("previous", prevScale);
        scaleData.method_10548("initial", fromScale);
        scaleData.method_10548("target", toScale);
        scaleData.method_10569("ticks", scaleTicks);
        scaleData.method_10569("total_ticks", totalScaleTicks);
        int baseModifierCount = buffer.readInt();
        if (baseModifierCount != 0) {
            class_2499 modifiers = new class_2499();
            for (int i = 0; i < baseModifierCount; ++i) {
                modifiers.add((Object)class_2509.field_11560.method_10639(buffer.method_10800(Short.MAX_VALUE)));
            }
            scaleData.method_10566("baseValueModifiers", (class_2520)modifiers);
        }
        if ((persistent = buffer.readByte()) != -1) {
            scaleData.method_10556("persistent", persistent == 1);
        }
        if (buffer.readBoolean()) {
            scaleData.method_10566("easing", class_2509.field_11560.method_10639(buffer.method_10800(Short.MAX_VALUE)));
        }
        return scaleData;
    }

    public static void syncScalesIfNeeded(class_1297 entity, Consumer<class_2596<?>> packetSender) {
        if (((PehkuiEntityExtensions)entity).pehkui_shouldSyncScales()) {
            ScaleUtils.syncScales(entity, packetSender, ScaleData::shouldSync, true);
            ((PehkuiEntityExtensions)entity).pehkui_setShouldSyncScales(false);
        }
    }

    public static void syncScalesOnTrackingStart(class_1297 entity, class_3244 handler) {
        ScaleUtils.syncScales(entity, p -> ReflectionUtils.sendPacket(handler, p), ScaleUtils::hasScaleDataChanged, false);
    }

    private static boolean hasScaleDataChanged(ScaleData scaleData) {
        return !scaleData.hasDefaultValues();
    }

    public static void syncScales(class_1297 entity, Consumer<class_2596<?>> packetSender, Predicate<ScaleData> condition, boolean unmark) {
        Collection<ScaleData> syncedScales = SYNCED_SCALE_DATA.get();
        for (ScaleData scaleData : ((PehkuiEntityExtensions)entity).pehkui_getScales().values()) {
            if (scaleData == null || !condition.test(scaleData)) continue;
            syncedScales.add(scaleData);
            if (!unmark) continue;
            scaleData.markForSync(false);
        }
        if (!syncedScales.isEmpty()) {
            if (NETWORKING_API_LOADED) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.method_10804(entity.method_5628());
                buffer.writeInt(syncedScales.size());
                for (ScaleData s : syncedScales) {
                    buffer.method_10812(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, s.getScaleType()));
                    s.toPacket(buffer);
                }
                packetSender.accept(ServerPlayNetworking.createS2CPacket((class_2960)Pehkui.SCALE_PACKET, (class_2540)buffer));
            }
            syncedScales.clear();
        }
    }

    public static class_243 getEyePos(class_1297 entity) {
        return ScaleUtils.getEyePos(entity, class_2350.field_11033);
    }

    public static class_243 getEyePos(class_1657 entity) {
        return ScaleUtils.getEyePos((class_1297)entity, GravityChangerCompatibility.INSTANCE.getGravityDirection(entity));
    }

    public static class_243 getEyePos(class_1297 entity, class_2350 gravity) {
        double offsetX = entity.method_5751() * (float)(-gravity.method_10148());
        double offsetY = entity.method_5751() * (float)(-gravity.method_10164());
        double offsetZ = entity.method_5751() * (float)(-gravity.method_10165());
        double footXCoord = entity.method_19538().method_10216();
        double footYCoord = entity.method_19538().method_10214();
        double footZCoord = entity.method_19538().method_10215();
        double headXCoord = footXCoord + offsetX;
        double headYCoord = footYCoord + offsetY;
        double headZCoord = footZCoord + offsetZ;
        return new class_243(headXCoord, headYCoord, headZCoord);
    }

    public static double getBlockXOffset(class_2338 pos, class_1657 player) {
        int blockCoord = pos.method_10263();
        class_2350 gravity = GravityChangerCompatibility.INSTANCE.getGravityDirection(player);
        double offset = player.method_5751() * (float)(-gravity.method_10148());
        double footCoord = player.method_19538().method_10216();
        double headCoord = footCoord + offset;
        int headCoordFloored = class_3532.method_15357((double)headCoord);
        if (headCoordFloored == blockCoord) {
            return footCoord - (double)headCoordFloored;
        }
        if (headCoordFloored > blockCoord) {
            return 1.0 - offset;
        }
        return -offset;
    }

    public static double getBlockYOffset(class_2338 pos, class_1657 player) {
        int blockCoord = pos.method_10264();
        class_2350 gravity = GravityChangerCompatibility.INSTANCE.getGravityDirection(player);
        double offset = player.method_5751() * (float)(-gravity.method_10164());
        double footCoord = player.method_19538().method_10214();
        double headCoord = footCoord + offset;
        int headCoordFloored = class_3532.method_15357((double)headCoord);
        if (headCoordFloored == blockCoord) {
            return footCoord - (double)headCoordFloored;
        }
        if (headCoordFloored > blockCoord) {
            return 1.0 - offset;
        }
        return -offset;
    }

    public static double getBlockZOffset(class_2338 pos, class_1657 player) {
        int blockCoord = pos.method_10260();
        class_2350 gravity = GravityChangerCompatibility.INSTANCE.getGravityDirection(player);
        double offset = player.method_5751() * (float)(-gravity.method_10165());
        double footCoord = player.method_19538().method_10215();
        double headCoord = footCoord + offset;
        int headCoordFloored = class_3532.method_15357((double)headCoord);
        if (headCoordFloored == blockCoord) {
            return footCoord - (double)headCoordFloored;
        }
        if (headCoordFloored > blockCoord) {
            return 1.0 - offset;
        }
        return -offset;
    }

    public static float getEyeHeightScale(class_1297 entity) {
        return ScaleUtils.getEyeHeightScale(entity, 1.0f);
    }

    public static float getEyeHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.EYE_HEIGHT, tickDelta);
    }

    public static float getThirdPersonScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.THIRD_PERSON, tickDelta);
    }

    public static float getModelWidthScale(class_1297 entity) {
        return ScaleUtils.getModelWidthScale(entity, 1.0f);
    }

    public static float getModelWidthScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.MODEL_WIDTH, tickDelta);
    }

    public static float getModelHeightScale(class_1297 entity) {
        return ScaleUtils.getModelHeightScale(entity, 1.0f);
    }

    public static float getModelHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.MODEL_HEIGHT, tickDelta);
    }

    public static float getBoundingBoxWidthScale(class_1297 entity) {
        return ScaleUtils.getBoundingBoxWidthScale(entity, 1.0f);
    }

    public static float getBoundingBoxWidthScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.HITBOX_WIDTH, tickDelta);
    }

    public static float getBoundingBoxHeightScale(class_1297 entity) {
        return ScaleUtils.getBoundingBoxHeightScale(entity, 1.0f);
    }

    public static float getBoundingBoxHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.HITBOX_HEIGHT, tickDelta);
    }

    public static float getInteractionBoxWidthScale(class_1297 entity) {
        return ScaleUtils.getInteractionBoxWidthScale(entity, 1.0f);
    }

    public static float getInteractionBoxWidthScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.INTERACTION_BOX_WIDTH, tickDelta);
    }

    public static float getInteractionBoxHeightScale(class_1297 entity) {
        return ScaleUtils.getInteractionBoxHeightScale(entity, 1.0f);
    }

    public static float getInteractionBoxHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.INTERACTION_BOX_HEIGHT, tickDelta);
    }

    public static float getFallingScale(class_1297 entity) {
        return ScaleUtils.getFallingScale(entity, 1.0f);
    }

    public static float getFallingScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.FALLING, tickDelta);
    }

    public static float getStepHeightScale(class_1297 entity) {
        return ScaleUtils.getStepHeightScale(entity, 1.0f);
    }

    public static float getStepHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.STEP_HEIGHT, tickDelta);
    }

    public static float getViewBobbingScale(class_1297 entity) {
        return ScaleUtils.getViewBobbingScale(entity, 1.0f);
    }

    public static float getViewBobbingScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.VIEW_BOBBING, tickDelta);
    }

    public static float getVisibilityScale(class_1297 entity) {
        return ScaleUtils.getVisibilityScale(entity, 1.0f);
    }

    public static float getVisibilityScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.VISIBILITY, tickDelta);
    }

    public static float getJumpHeightScale(class_1297 entity) {
        return ScaleUtils.getJumpHeightScale(entity, 1.0f);
    }

    public static float getJumpHeightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.JUMP_HEIGHT, tickDelta);
    }

    public static float getMotionScale(class_1297 entity) {
        return ScaleUtils.getMotionScale(entity, 1.0f);
    }

    public static float getMotionScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.MOTION, PehkuiConfig.COMMON.scaledMotion::get, tickDelta);
    }

    public static float getFlightScale(class_1297 entity) {
        return ScaleUtils.getFlightScale(entity, 1.0f);
    }

    public static float getFlightScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.FLIGHT, tickDelta);
    }

    public static float getBlockReachScale(class_1297 entity) {
        return ScaleUtils.getBlockReachScale(entity, 1.0f);
    }

    public static float getBlockReachScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.BLOCK_REACH, PehkuiConfig.COMMON.scaledReach::get, tickDelta);
    }

    public static float getEntityReachScale(class_1297 entity) {
        return ScaleUtils.getEntityReachScale(entity, 1.0f);
    }

    public static float getEntityReachScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.ENTITY_REACH, PehkuiConfig.COMMON.scaledReach::get, tickDelta);
    }

    public static float getMiningSpeedScale(class_1297 entity) {
        return ScaleUtils.getMiningSpeedScale(entity, 1.0f);
    }

    public static float getMiningSpeedScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.MINING_SPEED, tickDelta);
    }

    public static float getAttackSpeedScale(class_1297 entity) {
        return ScaleUtils.getAttackSpeedScale(entity, 1.0f);
    }

    public static float getAttackSpeedScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.ATTACK_SPEED, tickDelta);
    }

    public static float getKnockbackScale(class_1297 entity) {
        return ScaleUtils.getKnockbackScale(entity, 1.0f);
    }

    public static float getKnockbackScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleTypes.KNOCKBACK, tickDelta);
    }

    public static float getAttackScale(class_1297 entity) {
        return ScaleUtils.getAttackScale(entity, 1.0f);
    }

    public static float getAttackScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.ATTACK, PehkuiConfig.COMMON.scaledAttack::get, tickDelta);
    }

    public static float getDefenseScale(class_1297 entity) {
        return ScaleUtils.getDefenseScale(entity, 1.0f);
    }

    public static float getDefenseScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.DEFENSE, PehkuiConfig.COMMON.scaledDefense::get, tickDelta);
    }

    public static float getHealthScale(class_1297 entity) {
        return ScaleUtils.getHealthScale(entity, 1.0f);
    }

    public static float getHealthScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.HEALTH, PehkuiConfig.COMMON.scaledHealth::get, tickDelta);
    }

    public static float getDropScale(class_1297 entity) {
        return ScaleUtils.getDropScale(entity, 1.0f);
    }

    public static float getDropScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.DROPS, PehkuiConfig.COMMON.scaledItemDrops::get, tickDelta);
    }

    public static float getHeldItemScale(class_1297 entity) {
        return ScaleUtils.getHeldItemScale(entity, 1.0f);
    }

    public static float getHeldItemScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.HELD_ITEM, Boolean.TRUE::booleanValue, tickDelta);
    }

    public static float getProjectileScale(class_1297 entity) {
        return ScaleUtils.getProjectileScale(entity, 1.0f);
    }

    public static float getProjectileScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.PROJECTILES, PehkuiConfig.COMMON.scaledProjectiles::get, tickDelta);
    }

    public static float getExplosionScale(class_1297 entity) {
        return ScaleUtils.getExplosionScale(entity, 1.0f);
    }

    public static float getExplosionScale(class_1297 entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleTypes.EXPLOSIONS, PehkuiConfig.COMMON.scaledExplosions::get, tickDelta);
    }

    public static float getConfigurableTypedScale(class_1297 entity, ScaleType type, Supplier<Boolean> config, float tickDelta) {
        return config.get() != false ? ScaleUtils.getTypedScale(entity, type, tickDelta) : type.getDefaultBaseScale();
    }

    public static float getTypedScale(class_1297 entity, ScaleType type, float tickDelta) {
        return entity == null ? type.getDefaultBaseScale() : type.getScaleData(entity).getScale(tickDelta);
    }
}

