/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.jozufozu.flywheel.core.PartialModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.base.goggles.EntityGoggleOverlayRenderer;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.effects.ShakeEffect;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlock;
import rbasamoyai.createbigcannons.crafting.welding.CannonWelderSelectionHandler;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCFluids;
import rbasamoyai.createbigcannons.index.CBCItems;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;
import rbasamoyai.createbigcannons.index.fluid_utils.CBCFlowingFluid;
import rbasamoyai.createbigcannons.mixin.client.CameraAccessor;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlockItem;
import rbasamoyai.createbigcannons.network.ServerboundFiringActionPacket;
import rbasamoyai.createbigcannons.network.ServerboundSetFireRatePacket;
import rbasamoyai.createbigcannons.ponder.CBCPonderIndex;

public class CBCClientCommon {
    private static final String KEY_ROOT = "key.createbigcannons";
    public static final class_304 PITCH_MODE = IndexPlatform.createSafeKeyMapping("key.createbigcannons.pitch_mode", class_3675.class_307.field_1668, 67);
    public static final class_304 FIRE_CONTROLLED_CANNON = IndexPlatform.createSafeKeyMapping("key.createbigcannons.fire_controlled_cannon", class_3675.class_307.field_1672, 0);
    public static final List<class_304> KEYS = new ArrayList<class_304>();
    private static final List<ShakeEffect> ACTIVE_SHAKE_EFFECTS = new LinkedList<ShakeEffect>();
    public static final CannonWelderSelectionHandler CANNON_WELDER_HANDLER = new CannonWelderSelectionHandler();

    public static void onRegisterParticleFactories(class_310 mc, class_702 engine) {
        CBCParticleTypes.registerFactories();
    }

    public static void onClientSetup() {
        CBCPonderIndex.register();
        CBCPonderIndex.registerTags();
        CBCBlockPartials.resolveDeferredModels();
        IndexPlatform.registerClampedItemProperty((class_1792)CBCItems.PARTIALLY_FORMED_AUTOCANNON_CARTRIDGE.get(), CreateBigCannons.resource("formed"), (stack, level, player, a) -> stack.method_7948().method_10562("SequencedAssembly").method_10550("Step") - 1);
        IndexPlatform.registerClampedItemProperty((class_1792)CBCItems.PARTIALLY_FORMED_BIG_CARTRIDGE.get(), CreateBigCannons.resource("formed"), (stack, level, player, a) -> stack.method_7948().method_10562("SequencedAssembly").method_10550("Step") - 1);
        IndexPlatform.registerClampedItemProperty(((BigCartridgeBlock)CBCBlocks.BIG_CARTRIDGE.get()).method_8389(), CreateBigCannons.resource("big_cartridge_filled"), (stack, level, player, a) -> BigCartridgeBlockItem.getPower(stack));
    }

    public static void registerKeyMappings(Consumer<class_304> cons) {
        cons.accept(PITCH_MODE);
        cons.accept(FIRE_CONTROLLED_CANNON);
        KEYS.add(PITCH_MODE);
        KEYS.add(FIRE_CONTROLLED_CANNON);
    }

    public static void registerOverlays(BiConsumer<String, CBCGuiOverlay> cons) {
        cons.accept("entity_goggles_overlay", EntityGoggleOverlayRenderer::renderOverlay);
    }

    public static void setFogColor(class_4184 info, SetColorWrapper wrapper) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        class_2338 blockPos = info.method_19328();
        class_3610 fluidState = level.method_8316(blockPos);
        if (info.method_19326().field_1351 > (double)((float)blockPos.method_10264() + fluidState.method_15763((class_1922)level, blockPos))) {
            return;
        }
        class_3611 fluid = fluidState.method_15772();
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_CAST_IRON.get())).method_15780(fluid)) {
            wrapper.setFogColor(0.27450982f, 0.039215688f, 0.043137256f);
            return;
        }
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_BRONZE.get())).method_15780(fluid)) {
            wrapper.setFogColor(0.3882353f, 0.25882354f, 0.08627451f);
            return;
        }
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_STEEL.get())).method_15780(fluid)) {
            wrapper.setFogColor(0.43529412f, 0.43137255f, 0.41568628f);
            return;
        }
        if (((CBCFlowingFluid.Flowing)((Object)CBCFluids.MOLTEN_NETHERSTEEL.get())).method_15780(fluid)) {
            wrapper.setFogColor(0.29803923f, 0.19607843f, 0.22745098f);
            return;
        }
    }

    public static float getFogDensity(class_4184 info, float currentDensity) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        class_2338 blockPos = info.method_19328();
        class_3610 fluidState = level.method_8316(blockPos);
        if (info.method_19326().field_1351 > (double)((float)blockPos.method_10264() + fluidState.method_15763((class_1922)level, blockPos))) {
            return -1.0f;
        }
        class_3611 fluid = fluidState.method_15772();
        List<class_3611> moltenMetals = Arrays.asList((class_3611)CBCFluids.MOLTEN_CAST_IRON.get(), (class_3611)CBCFluids.MOLTEN_BRONZE.get(), (class_3611)CBCFluids.MOLTEN_STEEL.get(), (class_3611)CBCFluids.MOLTEN_NETHERSTEEL.get());
        for (class_3611 fluid1 : moltenMetals) {
            if (!fluid1.method_15780(fluid)) continue;
            return 0.03125f;
        }
        return -1.0f;
    }

    public static void onClientGameTick(class_310 mc) {
        ShakeEffect effect;
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        Iterator<ShakeEffect> iter = ACTIVE_SHAKE_EFFECTS.iterator();
        while (iter.hasNext()) {
            effect = iter.next();
            if (!effect.tick()) continue;
            iter.remove();
        }
        effect = mc.field_1724.method_5668();
        if (effect instanceof CannonCarriageEntity) {
            CannonCarriageEntity carriage = (CannonCarriageEntity)((Object)effect);
            class_744 input = mc.field_1724.field_3913;
            boolean isPitching = PITCH_MODE.method_1434();
            carriage.setInput(input.field_3908, input.field_3906, input.field_3910, input.field_3909, isPitching);
            mc.field_1724.field_3942 |= input.field_3908 | input.field_3906 | input.field_3910 | input.field_3909;
        }
        if (FIRE_CONTROLLED_CANNON.method_1434() && CBCClientCommon.isControllingCannon((class_1297)mc.field_1724)) {
            mc.field_1724.field_3942 = true;
            NetworkPlatform.sendToServer(new ServerboundFiringActionPacket());
        }
        CANNON_WELDER_HANDLER.tick();
    }

    public static boolean onClickMouse(class_304 mapping) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null) {
            return false;
        }
        boolean isUse = mc.field_1690.field_1904.method_1435(mapping);
        return isUse && CANNON_WELDER_HANDLER.onMouseInput();
    }

    public static boolean onScrollMouse(class_310 mc, double delta) {
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return false;
        }
        if (mc.field_1724.method_5668() instanceof CannonCarriageEntity) {
            int fireRateAdjustment = 0;
            if (delta > 0.0) {
                fireRateAdjustment = 1;
            } else if (delta < 0.0) {
                fireRateAdjustment = -1;
            }
            if (fireRateAdjustment != 0) {
                mc.field_1724.field_3942 = true;
                NetworkPlatform.sendToServer(new ServerboundSetFireRatePacket(fireRateAdjustment));
                return true;
            }
        }
        return false;
    }

    public static float onFovModify(class_310 mc, float oldFov) {
        if (mc.field_1724 == null || mc.method_1560() != null || !mc.field_1690.method_31044().method_31034()) {
            return CBCClientCommon.lerpFov(mc, oldFov);
        }
        return CBCClientCommon.lerpFov(mc, mc.field_1690.field_1904.method_1434() && CBCClientCommon.isControllingCannon((class_1297)mc.field_1724) ? oldFov * 0.5f : oldFov);
    }

    private static float lerpFov(class_310 mc, float fov) {
        return class_3532.method_16439((float)((Double)mc.field_1690.method_42454().method_41753()).floatValue(), (float)1.0f, (float)fov);
    }

    public static void onPlayerRenderPre(class_4587 stack, class_1309 player, float partialTicks) {
        PitchOrientedContraptionEntity poce;
        class_1297 class_12972 = player.method_5854();
        if (class_12972 instanceof PitchOrientedContraptionEntity && (poce = (PitchOrientedContraptionEntity)class_12972).getSeatPos((class_1297)player) != null) {
            player.field_6283 = player.field_6241;
            player.field_6220 = player.field_6259;
            float yaw = 90.0f - class_3532.method_16439((float)partialTicks, (float)player.field_6259, (float)player.field_6241);
            float pitch = class_3532.method_16439((float)partialTicks, (float)player.field_6004, (float)player.method_36455());
            Vector3f pitchVec = new Vector3f(class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))), 0.0f, class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))));
            stack.method_22907(new Quaternionf(new AxisAngle4f(pitch * ((float)Math.PI / 180), (Vector3fc)pitchVec)));
            stack.method_22904(0.0, -1.25, 0.0);
        }
    }

    private static boolean isControllingCannon(class_1297 entity) {
        class_1297 vehicle = entity.method_5854();
        return vehicle instanceof CannonCarriageEntity || vehicle instanceof PitchOrientedContraptionEntity;
    }

    public static class_2350.class_2351 getRotationAxis(class_2680 state) {
        boolean flag = (Boolean)state.method_11654((class_2769)QuickfiringBreechBlock.AXIS);
        return switch (((class_2350)state.method_11654((class_2769)QuickfiringBreechBlock.field_10927)).method_10166()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (flag) {
                    yield class_2350.class_2351.field_11052;
                }
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11052 -> {
                if (flag) {
                    yield class_2350.class_2351.field_11048;
                }
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11051 -> flag ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052;
        };
    }

    public static PartialModel getBreechblockForState(class_2680 state) {
        PartialModel partialModel;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)class_22482;
            partialModel = CBCBlockPartials.breechblockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_SLIDING_BREECHBLOCK;
        }
        return partialModel;
    }

    public static PartialModel getScrewBreechForState(class_2680 state) {
        PartialModel partialModel;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)class_22482;
            partialModel = CBCBlockPartials.screwLockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.STEEL_SCREW_LOCK;
        }
        return partialModel;
    }

    public static void onTextureAtlasStitchPre(Consumer<class_2960> cons) {
        cons.accept(CreateBigCannons.resource("item/tracer_slot"));
    }

    public static boolean onCameraSetup(class_4184 camera, double partialTicks, Supplier<Float> yaw, Supplier<Float> pitch, Supplier<Float> roll, Consumer<Float> setYaw, Consumer<Float> setPitch, Consumer<Float> setRoll) {
        PitchOrientedContraptionEntity poce;
        class_1297 class_12972;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        CameraAccessor camAccess = (CameraAccessor)camera;
        if (player != null && camera.method_19331() == player && (class_12972 = player.method_5854()) instanceof PitchOrientedContraptionEntity && (poce = (PitchOrientedContraptionEntity)class_12972).getSeatPos((class_1297)player) != null) {
            class_2350 dir = poce.getInitialOrientation();
            class_243 normal = new class_243(dir.method_23955());
            class_2350 up = class_2350.field_11036;
            class_243 upNormal = new class_243(up.method_23955());
            class_243 localPos = class_243.method_24953((class_2382)poce.getSeatPos((class_1297)player));
            if (mc.field_1690.method_31044() == class_5498.field_26664) {
                localPos = localPos.method_1019(upNormal.method_1021(0.35));
                class_243 camPos = poce.toGlobalVector(localPos, (float)partialTicks);
                camAccess.callSetPosition(camPos);
            }
            boolean flag = dir.method_10171() == class_2350.class_2352.field_11056 == (dir.method_10166() == class_2350.class_2351.field_11048);
            boolean flag1 = mc.field_1690.method_31044() == class_5498.field_26666;
            float sgn = flag == flag1 ? 1.0f : -1.0f;
            float add = flag1 ? 180.0f : 0.0f;
            setYaw.accept(Float.valueOf(-poce.method_5705((float)partialTicks) + add));
            setPitch.accept(Float.valueOf(poce.method_5695((float)partialTicks) * sgn));
            setRoll.accept(Float.valueOf(0.0f));
        }
        float dy = 0.0f;
        float dp = 0.0f;
        float dr = 0.0f;
        for (ShakeEffect shakeEffect : ACTIVE_SHAKE_EFFECTS) {
            float f = shakeEffect.getProgressNormalized((float)partialTicks);
            float f1 = f * f;
            float f2 = shakeEffect.getProgress((float)partialTicks);
            dy = (float)((double)dy + (double)(shakeEffect.magnitude * f1) * shakeEffect.yawNoise.method_16451(0.0, (double)f2, false));
            dp = (float)((double)dp + (double)(shakeEffect.magnitude * f1) * shakeEffect.pitchNoise.method_16451(0.0, (double)f2, false));
            dr = (float)((double)dr + (double)(shakeEffect.magnitude * f1) * shakeEffect.rollNoise.method_16451(0.0, (double)f2, false));
        }
        float s = ((Double)mc.field_1690.method_42453().method_41753()).floatValue();
        setYaw.accept(Float.valueOf(yaw.get().floatValue() + dy * s));
        setPitch.accept(Float.valueOf(pitch.get().floatValue() + dp * s));
        setRoll.accept(Float.valueOf(roll.get().floatValue() + dr * s));
        return false;
    }

    public static void addShakeEffect(ShakeEffect effect) {
        ACTIVE_SHAKE_EFFECTS.add(effect);
    }

    public static void onPlayerLogOut(class_746 player) {
        ACTIVE_SHAKE_EFFECTS.clear();
    }

    @FunctionalInterface
    public static interface CBCGuiOverlay {
        public void renderOverlay(class_332 var1, float var2, int var3, int var4);
    }

    public static interface SetColorWrapper {
        public void setFogColor(float var1, float var2, float var3);
    }
}

