/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.base.PartialBlockDamageSaveData;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;

public class PartialBlockDamageManager {
    private Map<class_5321<class_1937>, Map<class_2338, Integer>> blockDamage;
    private PartialBlockDamageSaveData savedata;

    public PartialBlockDamageManager() {
        this.cleanUp();
    }

    public void playerLogin(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 splayer = (class_3222)player;
            this.loadDamageData(splayer.method_5682());
        }
    }

    public void playerLogout(class_1657 player) {
    }

    public void levelLoaded(class_1936 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return;
        }
        this.cleanUp();
        this.savedata = null;
        this.loadDamageData(server);
    }

    private void cleanUp() {
        this.blockDamage = new HashMap<class_5321<class_1937>, Map<class_2338, Integer>>();
    }

    private void loadDamageData(MinecraftServer server) {
        if (this.savedata != null) {
            return;
        }
        this.savedata = PartialBlockDamageSaveData.load(server);
        this.blockDamage = this.savedata.getBlockDamage();
    }

    public void tick(class_1937 level) {
        class_5321 dimension = level.method_27983();
        if (!this.blockDamage.containsKey(dimension)) {
            return;
        }
        Map<class_2338, Integer> levelSet = this.blockDamage.get(dimension);
        if (levelSet.isEmpty()) {
            this.blockDamage.remove(dimension);
            return;
        }
        if (level.method_8510() % 20L != 0L) {
            return;
        }
        HashMap<class_2338, Integer> newSet = new HashMap<class_2338, Integer>();
        Iterator<Map.Entry<class_2338, Integer>> iter = levelSet.entrySet().iterator();
        while (iter.hasNext()) {
            int newPart;
            double hardnessRec;
            int oldPart;
            Map.Entry<class_2338, Integer> entry = iter.next();
            class_2338 pos = entry.getKey();
            class_2680 state = level.method_8500(pos).method_8320(pos);
            int oldProgress = entry.getValue();
            if (state.method_45474() || !state.method_51367() || state.method_26214((class_1922)level, pos) == -1.0f) {
                if (oldProgress > 0) {
                    level.method_8517(-1, pos, -1);
                }
                iter.remove();
                continue;
            }
            int newProgress = oldProgress - 3;
            if (newProgress <= 0) {
                level.method_8517(-1, pos, -1);
                iter.remove();
            } else {
                newSet.put(entry.getKey(), newProgress);
            }
            if ((oldPart = (int)Math.floor((double)oldProgress * (hardnessRec = 1.0 / BlockHardnessHandler.getHardness(state)))) - (newPart = (int)Math.floor((double)newProgress * hardnessRec)) <= 0) continue;
            level.method_8517(-1, pos, newPart);
        }
        levelSet.putAll(newSet);
        this.markDirty();
    }

    public void markDirty() {
        if (this.savedata != null) {
            this.savedata.method_80();
        }
    }

    public void damageBlock(class_2338 pos, int added, class_2680 state, class_1937 level) {
        Map levelSet = this.blockDamage.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new HashMap());
        int oldProgress = levelSet.getOrDefault(pos, 0);
        levelSet.merge(pos, added, Integer::sum);
        double hardnessRec = 1.0 / BlockHardnessHandler.getHardness(state);
        int oldPart = (int)Math.floor((double)oldProgress * hardnessRec);
        int newPart = (int)Math.floor((double)((Integer)levelSet.get(pos)).intValue() * hardnessRec);
        if (newPart >= 10) {
            if (!level.method_8608()) {
                level.method_22352(pos, false);
            }
            levelSet.remove(pos);
        } else if (newPart - oldPart > 0) {
            level.method_8517(-1, pos, newPart);
        }
        this.markDirty();
    }
}

