/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlock;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.ExtendsCannonMount;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.CannonContraptionProviderBlock;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class CannonMountBlockEntity
extends KineticBlockEntity
implements IDisplayAssemblyExceptions,
ControlPitchContraption.Block,
ExtendsCannonMount {
    private static final class_2753 HORIZONTAL_FACING = class_2741.field_12481;
    private AssemblyException lastException = null;
    protected PitchOrientedContraptionEntity mountedContraption;
    private boolean running;
    private float cannonYaw;
    private float cannonPitch;
    private float prevYaw;
    private float prevPitch;
    private float clientYawDiff;
    private float clientPitchDiff;
    float yawSpeed;

    public CannonMountBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        if (CBCBlocks.CANNON_MOUNT.has(state)) {
            this.cannonYaw = ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)).method_10144();
        }
        this.setLazyTickRate(3);
    }

    @Override
    public class_2680 getControllerState() {
        return this.method_11010();
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.method_11016()).method_1012(0.0, 2.0, 0.0);
    }

    public void tick() {
        boolean flag;
        super.tick();
        if (this.mountedContraption != null && !this.mountedContraption.method_5805()) {
            this.mountedContraption = null;
        }
        this.prevYaw = this.cannonYaw;
        this.prevPitch = this.cannonPitch;
        boolean bl = flag = this.mountedContraption != null && this.mountedContraption.canBeTurnedByController(this);
        if (this.method_10997().field_9236) {
            this.clientYawDiff = flag ? this.clientYawDiff * 0.5f : 0.0f;
            float f = this.clientPitchDiff = flag ? this.clientPitchDiff * 0.5f : 0.0f;
        }
        if (!this.running && !this.isVirtual()) {
            if (CBCBlocks.CANNON_MOUNT.has(this.method_11010())) {
                this.prevYaw = this.cannonYaw = ((class_2350)this.method_11010().method_11654((class_2769)HORIZONTAL_FACING)).method_10144();
                this.cannonPitch = 0.0f;
                this.prevPitch = 0.0f;
            }
            return;
        }
        if ((this.mountedContraption == null || !this.mountedContraption.isStalled()) && flag) {
            float yawSpeed = this.getAngularSpeed(this::getYawSpeed, this.clientYawDiff);
            float pitchSpeed = this.getAngularSpeed(() -> ((CannonMountBlockEntity)this).getSpeed(), this.clientPitchDiff);
            class_2350 dir = this.mountedContraption.getInitialOrientation();
            boolean flag1 = dir.method_10171() == class_2350.class_2352.field_11056 == (dir.method_10166() == class_2350.class_2351.field_11048);
            float sgn = flag1 ? 1.0f : -1.0f;
            float newYaw = this.cannonYaw - yawSpeed;
            float newPitch = this.cannonPitch + pitchSpeed * sgn;
            this.cannonYaw = newYaw % 360.0f;
            this.cannonPitch = this.mountedContraption == null ? 0.0f : class_3532.method_15363((float)(newPitch % 360.0f), (float)(-this.getMaxDepress()), (float)this.getMaxElevate());
        }
        this.applyRotation();
    }

    private float getMaxDepress() {
        return this.mountedContraption.maximumDepression();
    }

    private float getMaxElevate() {
        return this.mountedContraption.maximumElevation();
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void applyRotation() {
        float sgn;
        if (this.mountedContraption == null) {
            return;
        }
        class_2350 dir = this.mountedContraption.getInitialOrientation();
        boolean flag = dir.method_10171() == class_2350.class_2352.field_11056 == (dir.method_10166() == class_2350.class_2351.field_11048);
        float f = sgn = flag ? 1.0f : -1.0f;
        if (!this.mountedContraption.canBeTurnedByController(this)) {
            float d = -this.mountedContraption.maximumDepression();
            float e = this.mountedContraption.maximumElevation();
            this.cannonPitch = class_3532.method_15363((float)this.mountedContraption.pitch, (float)d, (float)e) * sgn;
            this.cannonYaw = this.mountedContraption.yaw;
        } else {
            this.mountedContraption.pitch = this.cannonPitch * sgn;
            this.mountedContraption.yaw = this.cannonYaw;
        }
    }

    public void onRedstoneUpdate(boolean assemblyPowered, boolean prevAssemblyPowered, boolean firePowered, boolean prevFirePowered, int firePower) {
        class_1937 class_19372;
        if (assemblyPowered != prevAssemblyPowered) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)CannonMountBlock.ASSEMBLY_POWERED, (Comparable)Boolean.valueOf(assemblyPowered)), 3);
            if (assemblyPowered) {
                try {
                    this.assemble();
                    this.lastException = null;
                }
                catch (AssemblyException e) {
                    this.lastException = e;
                    this.sendData();
                }
            } else {
                this.disassemble();
                this.sendData();
            }
        }
        if (firePowered != prevFirePowered) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)CannonMountBlock.FIRE_POWERED, (Comparable)Boolean.valueOf(firePowered)), 3);
        }
        if (this.running && this.mountedContraption != null && (class_19372 = this.method_10997()) instanceof class_3218) {
            class_3218 slevel = (class_3218)class_19372;
            ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).onRedstoneUpdate(slevel, this.mountedContraption, firePowered != prevFirePowered, firePower, this);
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.running && this.mountedContraption != null) {
            this.sendData();
        }
    }

    public float getPitchOffset(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)(partialTicks + 0.5f), (float)this.prevPitch, (float)this.cannonPitch);
        }
        if (this.mountedContraption == null || this.mountedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        if (this.mountedContraption != null && !this.mountedContraption.canBeTurnedByController(this)) {
            class_2350 facing = this.getContraptionDirection();
            boolean flag = facing.method_10171() == class_2350.class_2352.field_11056 == (facing.method_10166() == class_2350.class_2351.field_11048);
            float sgn = flag ? 1.0f : -1.0f;
            return this.mountedContraption.method_5695(partialTicks) * sgn;
        }
        float aSpeed = this.getAngularSpeed(() -> ((CannonMountBlockEntity)this).getSpeed(), this.clientPitchDiff);
        return class_3532.method_16439((float)partialTicks, (float)this.cannonPitch, (float)(this.cannonPitch + aSpeed));
    }

    public void setPitch(float pitch) {
        this.cannonPitch = pitch;
    }

    public float getYawSpeed() {
        return this.overStressed ? 0.0f : this.getTheoreticalYawSpeed();
    }

    public float getTheoreticalYawSpeed() {
        return this.yawSpeed;
    }

    public float getYawOffset(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)(partialTicks + 0.5f), (float)this.prevYaw, (float)this.cannonYaw);
        }
        if (this.mountedContraption == null || this.mountedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        if (this.mountedContraption != null && !this.mountedContraption.canBeTurnedByController(this)) {
            return -this.mountedContraption.method_5705(partialTicks);
        }
        float aSpeed = this.getAngularSpeed(this::getYawSpeed, this.clientYawDiff);
        return class_3532.method_16439((float)partialTicks, (float)this.cannonYaw, (float)(this.cannonYaw + aSpeed));
    }

    public float getDisplayPitch() {
        return Math.abs(this.cannonPitch) < 0.1f ? 0.0f : this.cannonPitch;
    }

    public void setYaw(float yaw) {
        this.cannonYaw = yaw;
    }

    public class_2350 getContraptionDirection() {
        return this.mountedContraption == null ? class_2350.field_11043 : ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).initialOrientation();
    }

    public float getAngularSpeed(Supplier<Float> sup, float clientDiff) {
        float speed = CannonMountBlockEntity.convertToAngular((float)sup.get().floatValue()) * 0.125f;
        if (sup.get().floatValue() == 0.0f) {
            speed = 0.0f;
        }
        if (this.method_10997().field_9236) {
            speed *= ServerSpeedProvider.get();
            speed += clientDiff / 3.0f;
        }
        return speed;
    }

    protected void assemble() throws AssemblyException {
        PitchOrientedContraptionEntity contraptionEntity;
        if (!CBCBlocks.CANNON_MOUNT.has(this.method_11010())) {
            return;
        }
        class_2338 assemblyPos = this.field_11867.method_10086(2);
        if (this.method_10997().method_31606(assemblyPos)) {
            throw CannonMountBlockEntity.cannonBlockOutsideOfWorld(assemblyPos);
        }
        AbstractMountedCannonContraption mountedCannon = this.getContraption(assemblyPos);
        if (mountedCannon == null || !mountedCannon.assemble(this.method_10997(), assemblyPos)) {
            return;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)CannonMountBlock.HORIZONTAL_FACING);
        class_2350 facing1 = mountedCannon.initialOrientation();
        if (facing.method_10166() != facing1.method_10166() && facing1.method_10166().method_10179()) {
            return;
        }
        this.running = true;
        mountedCannon.removeBlocksFromWorld(this.method_10997(), class_2338.field_10980);
        this.mountedContraption = contraptionEntity = PitchOrientedContraptionEntity.create(this.method_10997(), (Contraption)mountedCannon, facing1, this);
        this.resetContraptionToOffset();
        this.method_10997().method_8649((class_1297)contraptionEntity);
        this.sendData();
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.method_10997(), (class_2382)this.field_11867);
    }

    private AbstractMountedCannonContraption getContraption(class_2338 pos) {
        AbstractMountedCannonContraption abstractMountedCannonContraption;
        class_2248 class_22482 = this.field_11863.method_8320(pos).method_26204();
        if (class_22482 instanceof CannonContraptionProviderBlock) {
            CannonContraptionProviderBlock provBlock = (CannonContraptionProviderBlock)class_22482;
            abstractMountedCannonContraption = provBlock.getCannonContraption();
        } else {
            abstractMountedCannonContraption = null;
        }
        return abstractMountedCannonContraption;
    }

    @Override
    public void disassemble() {
        if (!this.running && this.mountedContraption == null) {
            return;
        }
        if (this.mountedContraption != null) {
            this.resetContraptionToOffset();
            this.mountedContraption.method_5662(new class_2487());
            this.mountedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.method_10997(), (class_2382)this.field_11867);
        }
        this.running = false;
        if (this.field_11865) {
            ((CannonMountBlock)((Object)CBCBlocks.CANNON_MOUNT.get())).method_9576(this.method_10997(), this.field_11867, this.method_11010(), null);
        }
    }

    protected void resetContraptionToOffset() {
        if (this.mountedContraption == null) {
            return;
        }
        this.cannonPitch = 0.0f;
        this.cannonYaw = this.getContraptionDirection().method_10144();
        this.prevPitch = this.cannonPitch;
        this.prevYaw = this.cannonYaw;
        this.mountedContraption.pitch = this.cannonPitch;
        this.mountedContraption.yaw = this.cannonYaw;
        this.mountedContraption.prevPitch = this.mountedContraption.pitch;
        this.mountedContraption.prevYaw = this.mountedContraption.yaw;
        this.mountedContraption.method_36457(this.cannonPitch);
        this.mountedContraption.method_36456(this.cannonYaw);
        this.mountedContraption.field_6004 = this.mountedContraption.method_36455();
        this.mountedContraption.field_5982 = this.mountedContraption.method_36454();
        class_243 vec = class_243.method_24955((class_2382)this.field_11867.method_10086(2));
        this.mountedContraption.method_33574(vec);
    }

    public float calculateStressApplied() {
        if (this.running && this.mountedContraption != null) {
            AbstractMountedCannonContraption contraption = (AbstractMountedCannonContraption)this.mountedContraption.getContraption();
            return contraption.getWeightForStress();
        }
        return 0.0f;
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("Running", this.running);
        tag.method_10548("CannonYaw", this.cannonYaw);
        tag.method_10548("CannonPitch", this.cannonPitch);
        tag.method_10548("YawSpeed", this.yawSpeed);
        AssemblyException.write((class_2487)tag, (AssemblyException)this.lastException);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        boolean oldRunning = this.running;
        this.running = tag.method_10577("Running");
        this.cannonYaw = tag.method_10583("CannonYaw");
        this.cannonPitch = tag.method_10583("CannonPitch");
        this.lastException = AssemblyException.read((class_2487)tag);
        this.yawSpeed = tag.method_10583("YawSpeed");
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            if (oldRunning && (this.mountedContraption == null || !this.mountedContraption.isStalled())) {
                this.clientYawDiff = AngleHelper.getShortestAngleDiff((double)this.prevYaw, (double)this.cannonYaw);
                this.clientPitchDiff = AngleHelper.getShortestAngleDiff((double)this.prevPitch, (double)this.cannonPitch);
                this.prevYaw = this.cannonYaw;
                this.prevPitch = this.cannonPitch;
            }
        } else {
            this.mountedContraption = null;
        }
    }

    public void remove() {
        this.field_11865 = true;
        if (!this.method_10997().field_9236) {
            this.disassemble();
        }
        super.remove();
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity entity) {
        return this.mountedContraption == entity;
    }

    @Override
    public void attach(PitchOrientedContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof AbstractMountedCannonContraption)) {
            return;
        }
        this.mountedContraption = contraption;
        if (!this.method_10997().field_9236) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.method_10997().field_9236) {
            this.sendData();
        }
    }

    @Override
    public class_2338 getControllerBlockPos() {
        return this.field_11867;
    }

    @Override
    public class_2338 getDismountPositionForContraption(PitchOrientedContraptionEntity poce) {
        return this.field_11867.method_10093(this.mountedContraption.getInitialOrientation().method_10153()).method_10084();
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public static AssemblyException cannonBlockOutsideOfWorld(class_2338 pos) {
        return new AssemblyException((class_2561)class_2561.method_43469((String)"exception.createbigcannons.cannon_mount.cannonBlockOutsideOfWorld", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
    }

    public class_243 getInteractionLocation() {
        class_243 class_2432;
        Contraption contraption;
        if (this.mountedContraption != null && (contraption = this.mountedContraption.getContraption()) instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            class_2432 = cannon.getInteractionVec(this.mountedContraption);
        } else {
            class_2432 = class_243.method_24953((class_2382)this.field_11867);
        }
        return class_2432;
    }

    @Nullable
    public PitchOrientedContraptionEntity getContraption() {
        return this.mountedContraption;
    }

    @Override
    @Nullable
    public CannonMountBlockEntity getCannonMount() {
        return this;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        ExtendsCannonMount.addCannonInfoToTooltip(tooltip, this.mountedContraption);
        return true;
    }
}

