/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.munitions.BaseProjectileProperties;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.PropertiesMunitionEntity;
import rbasamoyai.ritchiesprojectilelib.PreciseProjectile;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;

public abstract class AbstractCannonProjectile<T extends BaseProjectileProperties>
extends class_1676
implements PreciseProjectile,
PropertiesMunitionEntity<T> {
    protected static final class_2940<Byte> ID_FLAGS = class_2945.method_12791(AbstractCannonProjectile.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Float> PROJECTILE_MASS = class_2945.method_12791(AbstractCannonProjectile.class, (class_2941)class_2943.field_13320);
    protected int inGroundTime = 0;
    protected float damage;

    protected AbstractCannonProjectile(class_1299<? extends AbstractCannonProjectile> type, class_1937 level) {
        super(type, level);
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        this.damage = properties == null ? 0.0f : properties.entityDamage();
        this.setProjectileMass(properties == null ? 0.0f : properties.durabilityMass());
    }

    public void method_5773() {
        block8: {
            class_243 vel;
            class_3218 slevel;
            block11: {
                class_243 uel;
                block9: {
                    block10: {
                        class_1923 cpos = new class_1923(this.method_24515());
                        if (!this.method_37908().field_9236 && !this.method_37908().method_8393(cpos.field_9181, cpos.field_9180)) break block8;
                        class_1937 class_19372 = this.method_37908();
                        if (class_19372 instanceof class_3218) {
                            slevel = (class_3218)class_19372;
                            if (((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
                                RitchiesProjectileLib.queueForceLoad((class_3218)slevel, (class_1297)this, (int)cpos.field_9181, (int)cpos.field_9180, (boolean)false);
                            }
                        }
                        super.method_5773();
                        if (!this.isInGround()) {
                            this.clipAndDamage();
                        }
                        this.onTickRotate();
                        if (!this.isInGround()) break block9;
                        this.method_18799(class_243.field_1353);
                        if (!this.shouldFall()) break block10;
                        this.setInGround(false);
                        break block11;
                    }
                    if (this.method_37908().field_9236) break block11;
                    ++this.inGroundTime;
                    if (this.inGroundTime != 400) break block11;
                    this.method_31472();
                    break block11;
                }
                this.inGroundTime = 0;
                vel = uel = this.method_18798();
                class_243 oldPos = this.method_19538();
                class_243 newPos = oldPos.method_1019(vel);
                if (!this.method_5740()) {
                    vel = vel.method_1031(0.0, this.getGravity(), 0.0);
                }
                vel = vel.method_1021(this.getDrag());
                this.method_18799(vel);
                class_243 position = newPos.method_1019(vel.method_1020(uel).method_1021(0.5));
                this.method_33574(position);
                class_2394 particle = this.getTrailParticles();
                if (particle != null) {
                    for (int i = 0; i < 10; ++i) {
                        double partial = (float)i * 0.1f;
                        double dx = class_3532.method_16436((double)partial, (double)this.field_6038, (double)this.method_23317());
                        double dy = class_3532.method_16436((double)partial, (double)this.field_5971, (double)this.method_23318());
                        double dz = class_3532.method_16436((double)partial, (double)this.field_5989, (double)this.method_23321());
                        this.method_37908().method_8406(particle, dx, dy, dz, 0.0, 0.0, 0.0);
                    }
                }
            }
            vel = this.method_37908();
            if (vel instanceof class_3218) {
                slevel = (class_3218)vel;
                if (!this.method_31481() && ((Boolean)CBCConfigs.SERVER.munitions.projectilesCanChunkload.get()).booleanValue()) {
                    class_1923 cpos1 = new class_1923(this.method_24515());
                    RitchiesProjectileLib.queueForceLoad((class_3218)slevel, (class_1297)this, (int)cpos1.field_9181, (int)cpos1.field_9180, (boolean)true);
                }
            }
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 slevel = (class_3218)class_19372;
            RitchiesProjectileLib.removeAllForceLoaded((class_3218)slevel, (class_1297)this);
        }
        super.method_5650(reason);
    }

    protected void onTickRotate() {
    }

    protected void clipAndDamage() {
        class_243 pos;
        ProjectileContext projCtx = new ProjectileContext(this, (CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get()));
        class_243 start = pos = this.method_19538();
        double reach = (double)Math.max(this.method_17681(), this.method_17682()) * 0.5;
        double t = 1.0;
        int MAX_ITER = 100;
        for (int p = 0; p < MAX_ITER; ++p) {
            boolean breakEarly = false;
            class_243 vel = this.method_18798().method_1021(t);
            if (vel.method_1027() < 1.0E-4) break;
            class_243 end = start.method_1019(vel);
            class_3965 bResult = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (bResult.method_17783() != class_239.class_240.field_1333) {
                end = bResult.method_17784();
            }
            class_238 currentMovementRegion = this.method_5829().method_18804(end.method_1020(start)).method_1014(1.0).method_997(start.method_1020(pos));
            class_243 finalStart = start;
            class_243 finalEnd = end;
            class_238 thisBB = this.method_5829();
            for (class_1297 target : this.method_37908().method_8333((class_1297)this, currentMovementRegion, e -> {
                if (projCtx.hasHitEntity((class_1297)e) || !this.method_26958((class_1297)e)) {
                    return false;
                }
                class_238 bb = e.method_5829();
                return bb.method_994(thisBB) || bb.method_1014(reach).method_992(finalStart, finalEnd).isPresent();
            })) {
                projCtx.addEntity(target);
            }
            class_243 hitLoc = end;
            if (bResult.method_17783() != class_239.class_240.field_1333) {
                class_2338 bpos = bResult.method_17777().method_10062();
                class_2680 state = this.method_37908().method_8500(bpos).method_8320(bpos);
                class_243 curVel = this.method_18798();
                double mag = curVel.method_1033();
                boolean flag1 = projCtx.getLastState().method_26215();
                if (!flag1 || !this.tryBounceOffBlock(state, bResult)) {
                    projCtx.setLastState(state);
                    double startMass = this.getProjectileMass();
                    double curPom = startMass * mag;
                    double hardness = BlockHardnessHandler.getHardness(state);
                    if (projCtx.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.method_26214((class_1922)this.method_37908(), bpos) == -1.0f || curPom < hardness) {
                        this.setInGround(true);
                        this.method_18799(class_243.field_1353);
                        this.onImpact((class_239)bResult, true);
                        breakEarly = true;
                    } else {
                        state.method_26175(this.method_37908(), state, bResult, (class_1676)this);
                        this.onDestroyBlock(state, bResult);
                        if (this.method_31481()) {
                            breakEarly = true;
                        } else {
                            this.onImpact((class_239)bResult, false);
                            if (this.method_31481()) {
                                breakEarly = true;
                            } else {
                                double f = this.overPenetrationPower(hardness, curPom);
                                if (flag1 && f > 0.0) {
                                    projCtx.queueExplosion(bpos, (float)f);
                                }
                            }
                        }
                    }
                }
            }
            class_243 disp = hitLoc.method_1020(start);
            start = hitLoc;
            if (this.onClip(projCtx, start) || breakEarly || (t -= disp.method_1033() / vel.method_1033()) < 0.0) break;
        }
        for (class_1297 e2 : projCtx.hitEntities()) {
            this.onHitEntity(e2);
        }
        if (!this.method_37908().field_9236 && projCtx.griefState() != CBCCfgMunitions.GriefState.NO_DAMAGE) {
            class_243 oldVel = this.method_18798();
            for (Map.Entry<class_2338, Float> explosion : projCtx.getQueuedExplosions().entrySet()) {
                class_2338 bpos = explosion.getKey();
                this.method_37908().method_8437((class_1297)this, (double)bpos.method_10263() + 0.5, (double)bpos.method_10264() + 0.5, (double)bpos.method_10260() + 0.5, explosion.getValue().floatValue(), class_1937.class_7867.field_40889);
            }
            this.method_18799(oldVel);
        }
    }

    protected boolean onClip(ProjectileContext ctx, class_243 pos) {
        return false;
    }

    protected double overPenetrationPower(double hardness, double curPom) {
        double f = hardness / curPom;
        return f <= 0.15 ? 2.0 - 2.0 * f : 0.0;
    }

    protected boolean tryBounceOffBlock(class_2680 state, class_3965 result) {
        BounceType bounce = this.canBounce(state, result);
        if (bounce == BounceType.NO_BOUNCE) {
            return false;
        }
        class_243 oldVel = this.method_18798();
        double momentum = (double)this.getProjectileMass() * oldVel.method_1033();
        if (bounce == BounceType.DEFLECT) {
            if (momentum > BlockHardnessHandler.getHardness(state) * 0.5) {
                class_243 spallLoc = this.method_19538().method_1019(oldVel.method_1029().method_1021(2.0));
                this.method_37908().method_8437(null, spallLoc.field_1352, spallLoc.field_1351, spallLoc.field_1350, 2.0f, class_1937.class_7867.field_40888);
            }
            class_2498 sound = state.method_26231();
            this.method_5783(sound.method_10595(), sound.method_10597(), sound.method_10599());
        }
        class_243 normal = new class_243(result.method_17780().method_23955());
        double elasticity = bounce == BounceType.RICOCHET ? 1.5 : 1.9;
        this.method_18799(oldVel.method_1020(normal.method_1021(normal.method_1026(oldVel) * elasticity)));
        return true;
    }

    protected void onImpact(class_239 result, boolean stopped) {
        if (result.method_17783() == class_239.class_240.field_1332) {
            class_2680 state = this.method_37908().method_8320(((class_3965)result).method_17777());
            state.method_26175(this.method_37908(), state, (class_3965)result, (class_1676)this);
        }
    }

    protected abstract void onDestroyBlock(class_2680 var1, class_3965 var2);

    protected void onHitEntity(class_1297 entity) {
        if (this.getProjectileMass() <= 0.0f) {
            return;
        }
        if (!this.method_37908().field_9236) {
            BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
            entity.method_18799(this.method_18798().method_1021((double)this.getKnockback(entity)));
            class_1282 source = this.getEntityDamage(entity);
            if (properties == null || properties.ignoresEntityArmor()) {
                entity.field_6008 = 0;
            }
            entity.method_5643(source, this.damage);
            if (properties == null || !properties.rendersInvulnerable()) {
                entity.field_6008 = 0;
            }
            double penalty = entity.method_5805() ? 2.0 : 0.2;
            this.setProjectileMass((float)Math.max((double)this.getProjectileMass() - penalty, 0.0));
            this.onImpact((class_239)new class_3966(entity), this.getProjectileMass() <= 0.0f);
        }
    }

    protected class_1282 getEntityDamage(class_1297 entity) {
        return this.indirectArtilleryFire();
    }

    protected float getKnockback(class_1297 target) {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        return properties == null ? 0.0f : properties.knockback();
    }

    protected boolean canDeflect(class_3965 result) {
        return false;
    }

    protected boolean canBounceOffOf(class_2680 state) {
        return AbstractCannonProjectile.isBounceableOffOf(state);
    }

    public static boolean isDeflector(class_2680 state) {
        return state.method_26164(CBCTags.CBCBlockTags.DEFLECTS_SHOTS);
    }

    public static boolean isBounceableOffOf(class_2680 state) {
        return state.method_26164(CBCTags.CBCBlockTags.BOUNCES_SHOTS);
    }

    protected BounceType canBounce(class_2680 state, class_3965 result) {
        if (!((Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get()).booleanValue() || this.getProjectileMass() <= 0.0f) {
            return BounceType.NO_BOUNCE;
        }
        if (!this.canBounceOffOf(state)) {
            return BounceType.NO_BOUNCE;
        }
        class_243 oldVel = this.method_18798();
        double mag = oldVel.method_1033();
        if (mag < 0.2) {
            return BounceType.NO_BOUNCE;
        }
        class_243 normal = new class_243(result.method_17780().method_23955());
        double fc = normal.method_1026(oldVel) / mag;
        if (this.canDeflect(result) && -1.0 <= fc && fc <= -0.5) {
            return BounceType.DEFLECT;
        }
        return -0.5 <= fc && fc <= 0.0 ? BounceType.RICOCHET : BounceType.NO_BOUNCE;
    }

    public boolean method_5643(class_1282 source, float damage) {
        return false;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ID_FLAGS, (Object)0);
        this.field_6011.method_12784(PROJECTILE_MASS, (Object)Float.valueOf(0.0f));
    }

    public void setInGround(boolean inGround) {
        if (inGround) {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ID_FLAGS) | 1)));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ID_FLAGS) & 0xFE)));
        }
    }

    public boolean isInGround() {
        return ((Byte)this.field_6011.method_12789(ID_FLAGS) & 1) != 0;
    }

    private boolean shouldFall() {
        return this.isInGround() && this.method_37908().method_18026(new class_238(this.method_19538(), this.method_19538()).method_1014(0.06));
    }

    @Nullable
    protected class_2394 getTrailParticles() {
        return null;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("ProjectileMass", this.getProjectileMass());
        tag.method_10556("InGround", this.isInGround());
        tag.method_10548("Damage", this.damage);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setProjectileMass(tag.method_10583("ProjectileMass"));
        this.setInGround(tag.method_10577("InGround"));
        this.damage = tag.method_10583("Damage");
    }

    public void setProjectileMass(float power) {
        this.field_6011.method_12778(PROJECTILE_MASS, (Object)Float.valueOf(power));
    }

    public float getProjectileMass() {
        return ((Float)this.field_6011.method_12789(PROJECTILE_MASS)).floatValue();
    }

    public static void build(class_1299.class_1300<? extends AbstractCannonProjectile<?>> builder) {
        builder.method_27299(16).method_27300(1).method_19947().method_17687(0.8f, 0.8f);
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    protected double getGravity() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        double val = properties == null ? -0.05 : properties.gravity();
        double multiplier = DimensionMunitionPropertiesHandler.getProperties(this.method_37908()).gravityMultiplier();
        return val * multiplier;
    }

    protected double getDrag() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        float baseDrag = properties == null ? 0.99f : (float)properties.drag();
        float scalar = (float)DimensionMunitionPropertiesHandler.getProperties(this.method_37908()).dragMultiplier();
        if (scalar <= 1.0f) {
            return class_3532.method_16439((float)scalar, (float)1.0f, (float)baseDrag);
        }
        float diff = baseDrag - 1.0f;
        return (float)class_3532.method_15350((double)(baseDrag + diff * (scalar - 1.0f)), (double)0.9, (double)baseDrag);
    }

    public void setChargePower(float power) {
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !(entity instanceof class_1676);
    }

    public class_1282 indirectArtilleryFire() {
        return new CannonDamageSource((class_6880<class_8110>)CannonDamageSource.getDamageRegistry(this.method_37908()).method_40290(CBCDamageTypes.CANNON_PROJECTILE), (class_1297)this);
    }

    public static enum BounceType {
        DEFLECT,
        RICOCHET,
        NO_BOUNCE;

    }
}

