/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.munitions.config.MunitionProperties;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesSerializer;

public class BaseProjectileProperties
implements MunitionProperties {
    private final float entityDamage;
    private final float durabilityMass;
    private final boolean rendersInvulnerable;
    private final boolean ignoresEntityArmor;
    private final double gravity;
    private final double drag;
    private final float knockback;

    public BaseProjectileProperties(float entityDamage, float durabilityMass, boolean rendersInvulnerable, boolean ignoresEntityArmor, double gravity, double drag, float knockback) {
        this.entityDamage = entityDamage;
        this.durabilityMass = durabilityMass;
        this.rendersInvulnerable = rendersInvulnerable;
        this.ignoresEntityArmor = ignoresEntityArmor;
        this.gravity = gravity;
        this.drag = drag;
        this.knockback = knockback;
    }

    public BaseProjectileProperties(String id, JsonObject obj) {
        this.entityDamage = Math.max(0.0f, MunitionPropertiesSerializer.getOrWarn(obj, "entity_damage", id, Float.valueOf(1.0f), JsonElement::getAsFloat).floatValue());
        this.durabilityMass = Math.max(0.0f, MunitionPropertiesSerializer.getOrWarn(obj, "durability_mass", id, Float.valueOf(1.0f), JsonElement::getAsFloat).floatValue());
        this.rendersInvulnerable = !obj.has("renders_invulnerable") || obj.get("renders_invulnerable").getAsBoolean();
        this.ignoresEntityArmor = obj.has("ignores_entity_armor") && obj.get("ignores_entity_armor").getAsBoolean();
        this.gravity = Math.min(0.0, class_3518.method_34915((JsonObject)obj, (String)"gravity", (double)-0.05));
        this.drag = class_3532.method_15350((double)class_3518.method_34915((JsonObject)obj, (String)"drag", (double)0.99), (double)0.9, (double)1.0);
        this.knockback = Math.max(0.0f, class_3518.method_15277((JsonObject)obj, (String)"knockback", (float)2.0f));
    }

    public BaseProjectileProperties(class_2540 buf) {
        this.entityDamage = buf.readFloat();
        this.durabilityMass = buf.readFloat();
        this.rendersInvulnerable = buf.readBoolean();
        this.ignoresEntityArmor = buf.readBoolean();
        this.gravity = buf.readDouble();
        this.drag = buf.readDouble();
        this.knockback = buf.readFloat();
    }

    @Override
    public void toNetwork(class_2540 buf) {
        buf.writeFloat(this.entityDamage).writeFloat(this.durabilityMass).writeBoolean(this.rendersInvulnerable).writeBoolean(this.ignoresEntityArmor).writeDouble(this.gravity).writeDouble(this.drag).writeFloat(this.knockback);
    }

    public float entityDamage() {
        return this.entityDamage;
    }

    public float durabilityMass() {
        return this.durabilityMass;
    }

    public boolean rendersInvulnerable() {
        return this.rendersInvulnerable;
    }

    public boolean ignoresEntityArmor() {
        return this.ignoresEntityArmor;
    }

    public double gravity() {
        return this.gravity;
    }

    public double drag() {
        return this.drag;
    }

    public float knockback() {
        return this.knockback;
    }

    public static class Serializer
    implements MunitionPropertiesSerializer<BaseProjectileProperties> {
        @Override
        public BaseProjectileProperties fromJson(class_2960 loc, JsonObject obj) {
            return new BaseProjectileProperties(loc.toString(), obj);
        }

        @Override
        public BaseProjectileProperties fromNetwork(class_2960 loc, class_2540 buf) {
            return new BaseProjectileProperties(buf);
        }
    }
}

