/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.index.CBCDamageTypes;
import rbasamoyai.createbigcannons.munitions.BaseProjectileProperties;
import rbasamoyai.createbigcannons.munitions.CannonDamageSource;
import rbasamoyai.createbigcannons.munitions.config.BlockHardnessHandler;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionPropertiesHandler;
import rbasamoyai.createbigcannons.munitions.config.PropertiesMunitionEntity;

public class Shrapnel
extends class_1668
implements PropertiesMunitionEntity<BaseProjectileProperties> {
    protected float damage;
    protected float mass;
    private int age;

    public Shrapnel(class_1299<? extends Shrapnel> type, class_1937 level) {
        super(type, level);
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        this.mass = properties == null ? 0.0f : properties.durabilityMass();
    }

    public static <T extends Shrapnel> List<T> spawnShrapnelBurst(class_1937 level, class_1299<T> type, class_243 position, class_243 initialVelocity, int count, double spread, float damage) {
        class_243 forward = initialVelocity.method_1029();
        class_243 right = forward.method_1036(new class_243(class_2350.field_11036.method_23955()));
        class_243 up = forward.method_1036(right);
        double length = initialVelocity.method_1033();
        class_5819 random = level.method_8409();
        ArrayList<Shrapnel> list = new ArrayList<Shrapnel>();
        for (int i = 0; i < count; ++i) {
            double velScale = length * (1.4 + 0.2 * random.method_43058());
            class_243 vel = forward.method_1021(velScale).method_1019(right.method_1021((random.method_43058() - random.method_43058()) * velScale * spread)).method_1019(up.method_1021((random.method_43058() - random.method_43058()) * velScale * spread));
            Shrapnel shrapnel = (Shrapnel)type.method_5883(level);
            double rx = position.field_1352 + (random.method_43058() - random.method_43058()) * 0.0625;
            double ry = position.field_1351 + (random.method_43058() - random.method_43058()) * 0.0625;
            double rz = position.field_1350 + (random.method_43058() - random.method_43058()) * 0.0625;
            shrapnel.method_5814(rx, ry, rz);
            shrapnel.method_18799(vel);
            shrapnel.setDamage(damage);
            if (!level.method_8649((class_1297)shrapnel)) continue;
            list.add(shrapnel);
        }
        if (list.size() != count) {
            CreateBigCannons.LOGGER.info("Shrapnel burst failed to spawn {} out of {} shrapnel bullets", (Object)(count - list.size()), (Object)count);
        }
        return list;
    }

    public void method_5773() {
        super.method_5773();
        ++this.age;
        if (!this.method_5740() && this.getGravity() < 0.0f) {
            this.method_18799(this.method_18798().method_1031(0.0, (double)this.getGravity(), 0.0));
        }
        if (!this.method_37908().field_9236 && this.age > 20) {
            this.method_31472();
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Age", this.age);
        tag.method_10548("Damage", this.damage);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.age = tag.method_10550("Age");
        this.damage = tag.method_10583("Damage");
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        class_2338 pos = result.method_17777();
        class_2680 state = this.method_37908().method_22350(pos).method_8320(pos);
        if (!this.method_37908().field_9236 && state.method_26214((class_1922)this.method_37908(), pos) != -1.0f && this.canDestroyBlock(state)) {
            class_243 curVel = this.method_18798();
            double curPom = (double)this.getProjectileMass() * curVel.method_1033();
            double hardness = BlockHardnessHandler.getHardness(state) * 10.0;
            CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos.method_10062(), (int)Math.min(curPom, hardness), state, this.method_37908());
            class_2498 type = state.method_26231();
            this.method_37908().method_8396(null, pos, type.method_10595(), class_3419.field_15254, type.method_10597() * 0.25f, type.method_10599());
            this.method_31472();
        }
    }

    protected boolean canDestroyBlock(class_2680 state) {
        return true;
    }

    protected float getProjectileMass() {
        return this.mass;
    }

    protected void method_7454(class_3966 result) {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        if (properties == null || properties.ignoresEntityArmor()) {
            result.method_17782().field_6008 = 0;
        }
        result.method_17782().method_5643(this.getDamageSource(), this.damage);
        if (properties == null || !properties.rendersInvulnerable()) {
            result.method_17782().field_6008 = 0;
        }
    }

    protected void method_7488(class_239 result) {
        class_3966 eResult;
        super.method_7488(result);
        if (!(this.method_37908().field_9236 || result instanceof class_3966 && (eResult = (class_3966)result).method_17782().method_5864() == this.method_5864())) {
            this.method_31472();
        }
    }

    protected class_1282 getDamageSource() {
        return new CannonDamageSource((class_6880<class_8110>)CannonDamageSource.getDamageRegistry(this.method_37908()).method_40290(CBCDamageTypes.SHRAPNEL), (class_1297)this);
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return 0.125f;
    }

    protected float method_7466() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        float baseDrag = properties == null ? 0.99f : (float)properties.drag();
        float scalar = (float)DimensionMunitionPropertiesHandler.getProperties(this.method_37908()).dragMultiplier();
        if (scalar <= 1.0f) {
            return class_3532.method_16439((float)scalar, (float)1.0f, (float)baseDrag);
        }
        float diff = baseDrag - 1.0f;
        return (float)class_3532.method_15350((double)(baseDrag + diff * (scalar - 1.0f)), (double)0.9, (double)baseDrag);
    }

    protected float getGravity() {
        BaseProjectileProperties properties = (BaseProjectileProperties)this.getProperties();
        float val = properties == null ? -0.05f : (float)properties.gravity();
        float multiplier = (float)DimensionMunitionPropertiesHandler.getProperties(this.method_37908()).gravityMultiplier();
        return val * multiplier;
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !(entity instanceof class_1676);
    }
}

