/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.Gson;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;

public class OriginsJsonConfigSerializer<T extends ConfigData>
extends GsonConfigSerializer<T> {
    private final OriginsConfigSerializer<T> legacySerializer;
    private final Path configPath;

    public OriginsJsonConfigSerializer(Config definition, Class<T> configClass, Gson gson) {
        super(definition, configClass, gson);
        this.configPath = Utils.getConfigFolder().resolve(definition.name() + ".json5");
        this.legacySerializer = null;
    }

    public OriginsJsonConfigSerializer(Config definition, Class<T> configClass) {
        super(definition, configClass);
        this.configPath = Utils.getConfigFolder().resolve(definition.name() + ".json5");
        this.legacySerializer = null;
    }

    public OriginsJsonConfigSerializer(Config definition, Class<T> configClass, OriginsConfigSerializer<T> legacySerializer) {
        super(definition, configClass);
        this.configPath = Utils.getConfigFolder().resolve(definition.name() + ".json5");
        this.legacySerializer = legacySerializer;
    }

    public T deserialize() {
        ConfigData t;
        if (Files.exists(this.legacySerializer.getConfigPath(), new LinkOption[0]) && !Files.exists(this.configPath, new LinkOption[0])) {
            try {
                T t2 = this.legacySerializer.deserialize();
                this.serialize((ConfigData)t2);
                Origins.LOGGER.info("Converted old .toml config to new .json5 format. Old file will be renamed to origins_server.toml.unused.");
                Files.move(this.legacySerializer.getConfigPath(), this.legacySerializer.getConfigPath().getParent().resolve("origins_server.toml.unused"), new CopyOption[0]);
                return t2;
            }
            catch (Exception e) {
                Origins.LOGGER.error("Failed converting old .toml config to new .json5 format: " + e.getMessage());
            }
        }
        try {
            t = super.deserialize();
        }
        catch (Exception e) {
            Origins.LOGGER.error("Failed reading config (re-creating default): " + e.getMessage());
            t = super.createDefault();
        }
        return (T)t;
    }
}

