/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import dev.architectury.utils.value.IntValue;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.components.PlayBackControlWidget;
import dev.felnull.imp.client.gui.components.VolumeWidget;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public abstract class PlayBackBaseBMonitor
extends BoomboxMonitor {
    protected static final class_2960 PLAYING_BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/monitor/playing.png");
    protected static final class_2960 PLAYING_IMAGE_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/monitor/playing_image.png");
    private VolumeWidget volumeWidget;
    private PlayBackControlWidget playBackControlWidget;

    public PlayBackBaseBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.volumeWidget = this.addRenderWidget(new VolumeWidget(this.getStartX() + 168, this.getStartY() + 14, new IntValue(){

            public void accept(int value) {
                PlayBackBaseBMonitor.this.setVolume(value);
            }

            public int getAsInt() {
                return PlayBackBaseBMonitor.this.getScreen().getVolume();
            }
        }, () -> this.getScreen().isMute(), null));
        this.volumeWidget.field_22764 = this.canPlay();
        this.playBackControlWidget = this.addRenderWidget(new PlayBackControlWidget(this.getStartX() + (this.isShortProgressBar() ? 38 : 2), this.getStartY() + 25, () -> this.getScreen().isPlaying() ? PlayBackControlWidget.StateType.STOP : PlayBackControlWidget.StateType.PLAYING, n -> {
            switch (n) {
                case PLAYING: {
                    this.getScreen().insPlaying(true);
                    break;
                }
                case STOP: {
                    this.getScreen().insPlaying(false);
                    break;
                }
                case PAUSE: {
                    this.getScreen().insPause();
                }
            }
        }));
        this.playBackControlWidget.field_22764 = this.canPlay();
    }

    @Override
    public void tick() {
        super.tick();
        this.volumeWidget.field_22764 = this.canPlay();
        this.playBackControlWidget.field_22764 = this.canPlay();
        this.playBackControlWidget.method_46421(this.getStartX() + (this.isShortProgressBar() ? 38 : 2));
    }

    @Override
    public void render(class_332 guiGraphics, float f, int mouseX, int mouseY) {
        super.render(guiGraphics, f, mouseX, mouseY);
        if (!this.canPlay()) {
            return;
        }
        OERenderUtils.drawTexture((class_2960)PLAYING_BG_TEXTURE, (class_4587)guiGraphics.method_51448(), (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (!this.getPlayBackImage().isEmpty()) {
            OERenderUtils.drawTexture((class_2960)PLAYING_IMAGE_TEXTURE, (class_4587)guiGraphics.method_51448(), (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        }
        int sx = 2;
        if (!this.getPlayBackImage().isEmpty()) {
            this.getPlayImageRenderer().draw(this.getPlayBackImage(), guiGraphics.method_51448(), this.getStartX() + 1, this.getStartY() + 1, this.height - 2);
            sx += this.height - 2;
        }
        this.drawSmartCenterText(guiGraphics, (class_2561)class_2561.method_43471((String)OEClientUtils.getWidthOmitText((String)this.getPlayBackName(), (float)(this.width - sx - 2), (String)"...")), (float)(this.getStartX() + sx) + ((float)(this.width - sx) - 2.0f) / 2.0f, this.getStartY() + 3);
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        if (!this.canPlay(data)) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 0.002f);
        OERenderUtils.renderTextureSprite((class_2960)PLAYING_BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        poseStack.method_22909();
        if (!this.getPlayBackImage(data).isEmpty()) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 0.003f);
            OERenderUtils.renderTextureSprite((class_2960)PLAYING_IMAGE_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
            poseStack.method_22909();
        }
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        int sx = 2;
        if (!this.getPlayBackImage(data).isEmpty()) {
            this.getPlayImageRenderer().renderSprite(this.getPlayBackImage(data), poseStack, multiBufferSource, 1.0f * onPxW, monitorHeight - (float)(1 + this.height - 2) * onPxH, 0.004f, (float)(this.height - 3) * onPxH, i, j);
            sx += this.height - 2;
        }
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43471((String)OEClientUtils.getWidthOmitText((String)this.getPlayBackName(data), (float)(this.width - sx - 2), (String)"...")), (float)sx + ((float)(this.width - sx) - 2.0f) / 2.0f, 4.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        this.renderVolumeSprite(poseStack, multiBufferSource, 168.0f, 14.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, data.getVolume(), data.isMute());
        this.renderPlayBackControl(poseStack, multiBufferSource, this.isShortProgressBar(data) ? 38.0f : 2.0f, 25.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, data.isPlaying() ? PlayBackControlWidget.StateType.STOP : PlayBackControlWidget.StateType.PLAYING);
    }

    private void setVolume(int volume) {
        this.getScreen().insVolume(volume);
    }

    @NotNull
    protected ImageInfo getPlayBackImage() {
        return this.getPlayBackImage(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract ImageInfo getPlayBackImage(BoomboxData var1);

    @NotNull
    protected String getPlayBackName() {
        return this.getPlayBackName(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract String getPlayBackName(BoomboxData var1);

    @NotNull
    protected String getPlayBackAuthor() {
        return this.getPlayBackAuthor(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract String getPlayBackAuthor(BoomboxData var1);

    @NotNull
    protected MusicSource getPlayBackSource() {
        return this.getPlayBackSource(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract MusicSource getPlayBackSource(BoomboxData var1);

    protected boolean canPlay() {
        return this.canPlay(this.getScreen().getBoomBoxData());
    }

    protected boolean canPlay(BoomboxData data) {
        return true;
    }

    protected boolean isShortProgressBar(BoomboxData data) {
        return !this.getPlayBackImage(data).isEmpty();
    }

    protected boolean isShortProgressBar() {
        return this.isShortProgressBar(this.getScreen().getBoomBoxData());
    }

    protected boolean isShortTipProgressBar() {
        return false;
    }
}

