/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.MusicsFixedListWidget;
import dev.felnull.imp.client.gui.components.MyPlayListFixedListWidget;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.SortButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.MusicSyncManager;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class PlayListMMMonitor
extends MusicManagerMonitor {
    private static final class_2960 PLAY_LIST_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/play_list.png");
    private static final class_2561 ADD_PLAYLIST_TEXT = class_2561.method_43471((String)"imp.button.addPlaylist");
    private static final class_2561 ADD_MUSIC_TEXT = class_2561.method_43471((String)"imp.button.addMusic");
    private static final class_2561 SORT_TYPE_NAME_TEXT = class_2561.method_43471((String)("imp.sortType." + SortButton.SortType.NAME.getName()));
    private static final class_2561 ORDER_TYPE_DESCENDING_TEXT = class_2561.method_43471((String)("imp.orderType." + SortButton.OrderType.DESCENDING.getName()));
    private static final class_2561 DETAIL_TEXT = class_2561.method_43471((String)"imp.button.detailPlaylist");
    private final List<MusicPlayList> musicPlayLists = new ArrayList<MusicPlayList>();
    private final List<Music> musics = new ArrayList<Music>();
    private List<MusicPlayList> musicPlayListsCash;
    private List<Music> musicsCash;
    private MusicSyncManager.PlayListInfo lastPlayListInfo;
    private class_2561 INFO_TEXT;
    private SortButton.SortTypeButton playlistSortButton;
    private SortButton.OrderTypeButton playlistOrderButton;
    private SortButton.SortTypeButton musicSortButton;
    private SortButton.OrderTypeButton musicOrderButton;
    private SmartButton addPlaylistButton;
    private SmartButton addMusic;
    private SmartButton detailButton;
    private MusicsFixedListWidget musicsFixedButtonsList;
    private MyPlayListFixedListWidget myPlayListFixedButtonsList;

    public PlayListMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.myPlayListFixedButtonsList = this.addRenderWidget(new MyPlayListFixedListWidget(this.getStartX() + 1, this.getStartY() + 20, this.musicPlayLists, (FixedListWidget.PressEntry<MusicPlayList>)((FixedListWidget.PressEntry)(widget, item) -> this.setSelectedPlayList(item.getUuid())), this.myPlayListFixedButtonsList, n -> n.getUuid().equals(this.getSelectedPlayList())));
        this.addPlaylistButton = this.addRenderWidget(new SmartButton(this.getStartX() + 1, this.getStartY() + 189, 81, 9, ADD_PLAYLIST_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.ADD_PLAY_LIST)));
        this.addPlaylistButton.setIcon(WIDGETS_TEXTURE, 73, 14, 5, 5);
        this.addMusic = this.addRenderWidget(new SmartButton(this.getStartX() + 102, this.getStartY() + 189, 72, 9, ADD_MUSIC_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.ADD_MUSIC)));
        this.addMusic.setIcon(WIDGETS_TEXTURE, 73, 14, 5, 5);
        this.addMusic.field_22763 = this.getSelectedMusicPlayList() != null && this.getSelectedMusicPlayList().getAuthority().getAuthorityType(IIMPSmartRender.mc.field_1724.method_7334().getId()).isMoreMember();
        this.musicSortButton = this.addRenderWidget(new SortButton.SortTypeButton(this.getStartX() + 174, this.getStartY() + 189, n -> this.updateMusics(), true, (class_437)this.getScreen()));
        this.musicOrderButton = this.addRenderWidget(new SortButton.OrderTypeButton(this.getStartX() + 271, this.getStartY() + 189, n -> this.updateMusics(), true, (class_437)this.getScreen()));
        this.musicsFixedButtonsList = this.addRenderWidget(new MusicsFixedListWidget(this.getStartX() + 102, this.getStartY() + 40, 267, 148, (class_2561)class_2561.method_43471((String)"imp.fixedList.musics"), 4, this.musics, (FixedListWidget.PressEntry<Music>)((FixedListWidget.PressEntry)(widget, item) -> {
            this.setSelectedMusic(item.getUuid());
            this.insMonitor(MusicManagerBlockEntity.MonitorType.DETAIL_MUSIC);
        }), false, this.musicsFixedButtonsList));
        this.detailButton = this.addRenderWidget(new SmartButton(this.getStartX() + 336, this.getStartY() + 20, 33, 9, DETAIL_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.DETAIL_PLAY_LIST)));
        this.detailButton.field_22764 = this.getSelectedMusicPlayList() != null;
        this.playlistOrderButton = this.addRenderWidget(new SortButton.OrderTypeButton(this.getStartX() + 82 + 9, this.getStartY() + 189, n -> this.updateList(), false, (class_437)this.getScreen()));
        this.playlistSortButton = this.addRenderWidget(new SortButton.SortTypeButton(this.getStartX() + 73 + 9, this.getStartY() + 189, n -> this.updateList(), false, (class_437)this.getScreen()));
    }

    @Override
    public void render(class_332 guiGraphics, float f, int mouseX, int mouseY) {
        MusicPlayList pl;
        super.render(guiGraphics, f, mouseX, mouseY);
        class_4587 poseStack = guiGraphics.method_51448();
        OERenderUtils.drawTexture((class_2960)PLAY_LIST_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.INFO_TEXT != null) {
            this.drawSmartText(guiGraphics, this.INFO_TEXT, this.getStartX() + this.width - IIMPSmartRender.mc.field_1772.method_27525((class_5348)this.INFO_TEXT) - 3, this.getStartY() + 11);
        }
        if ((pl = this.getSelectedMusicPlayList()) != null) {
            int plsty;
            List<UUID> au = pl.getAuthority().getPlayersAuthority().entrySet().stream().sorted(Comparator.comparingInt(o -> ((AuthorityInfo.AuthorityType)((Object)((Object)o.getValue()))).getLevel())).map(Map.Entry::getKey).filter(n -> !n.equals(pl.getAuthority().getOwner())).toList();
            if (au.size() == 0) {
                OERenderUtils.drawPlayerFace((class_4587)poseStack, (UUID)pl.getAuthority().getOwner(), (float)(this.getStartX() + 328), (float)(this.getStartY() + 21), (float)7.0f);
                plsty = 14;
            } else if (au.size() == 1) {
                OERenderUtils.drawPlayerFace((class_4587)poseStack, (UUID)au.get(0), (float)(this.getStartX() + 328), (float)(this.getStartY() + 21), (float)7.0f);
                OERenderUtils.drawPlayerFace((class_4587)poseStack, (UUID)pl.getAuthority().getOwner(), (float)(this.getStartX() + 319), (float)(this.getStartY() + 21), (float)7.0f);
                plsty = 20;
            } else {
                class_5250 tx = class_2561.method_43470((String)("+" + au.size()));
                int txw = PlayListMMMonitor.mc.field_1772.method_27525((class_5348)tx);
                this.drawSmartText(guiGraphics, (class_2561)tx, this.getStartX() + 336 - txw - 2, this.getStartY() + 21);
                OERenderUtils.drawPlayerFace((class_4587)poseStack, (UUID)pl.getAuthority().getOwner(), (float)(this.getStartX() + 336 - txw - 2 - 8), (float)(this.getStartY() + 21), (float)7.0f);
                plsty = 18 + txw;
            }
            this.drawSmartText(guiGraphics, (class_2561)class_2561.method_43470((String)OEClientUtils.getWidthOmitText((String)pl.getName(), (float)(240 - plsty), (String)"...")), this.getStartX() + 103, this.getStartY() + 21);
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((class_2960)PLAY_LIST_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 1.0f, 189.0f, 0.002f, 81.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, ADD_PLAYLIST_TEXT, WIDGETS_TEXTURE, 73, 14, 5, 5, 256, 256);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 102.0f, 189.0f, 0.002f, 72.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, ADD_MUSIC_TEXT, WIDGETS_TEXTURE, 73, 14, 5, 5, 256, 256, this.getSelectedPlayList(blockEntity) == null);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 82.0f, 189.0f, 0.002f, 9.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, WIDGETS_TEXTURE, 73, 0, 7, 7, 256, 256);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 91.0f, 189.0f, 0.002f, 9.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, WIDGETS_TEXTURE, 80, 7, 7, 7, 256, 256);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 174.0f, 189.0f, 0.002f, 97.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, SORT_TYPE_NAME_TEXT, WIDGETS_TEXTURE, 73, 0, 7, 7, 256, 256);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 271.0f, 189.0f, 0.002f, 88.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, ORDER_TYPE_DESCENDING_TEXT, WIDGETS_TEXTURE, 80, 7, 7, 7, 256, 256);
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        int plsc = 0;
        if (pls != null) {
            plsc = pls.size();
            for (int k = 0; k < Math.min(8, pls.size()); ++k) {
                MusicPlayList playList = pls.get(k);
                this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 1.0f, 20 + k * 21, 0.002f, 90.0f, 21.0f, i, j, onPxW, onPxH, monitorHeight, playList.getUuid().equals(this.getSelectedPlayList(blockEntity)));
                float sx = 1.0f;
                if (!playList.getImage().isEmpty()) {
                    sx += 20.0f;
                    PlayImageRenderer.getInstance().renderSprite(playList.getImage(), poseStack, multiBufferSource, 3.0f * onPxW, monitorHeight - (float)(20 + k * 21 + 2 + 17) * onPxH, 0.004f, 17.0f * onPxH, i, j);
                }
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43470((String)OEClientUtils.getWidthOmitText((String)playList.getName(), (float)(80.0f - sx), (String)"...")), sx + 3.0f, 20 + k * 21 + 3, 0.004f, onPxW, onPxH, monitorHeight, i);
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43470((String)MyPlayListFixedListWidget.dateFormat.format(new Date(playList.getCreateDate()))), sx + 3.0f, 20 + k * 21 + 12, 0.004f, onPxW, onPxH, monitorHeight, 0.7f, i);
            }
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 92.0f, 20.0f, 0.002f, 168.0f, i, j, onPxW, onPxH, monitorHeight, plsc, 8);
        this.updateInfoText();
        if (this.INFO_TEXT != null) {
            this.renderSmartTextSprite(poseStack, multiBufferSource, this.INFO_TEXT, this.width - IIMPSmartRender.mc.field_1772.method_27525((class_5348)this.INFO_TEXT) - 3, 11.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        }
        List<Music> ms = this.getSyncManager().getMusics(this.getSelectedPlayList(blockEntity));
        int msc = 0;
        if (ms != null) {
            msc = ms.size();
            for (int k = 0; k < Math.min(4, ms.size()); ++k) {
                Music music = ms.get(k);
                this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 102.0f, 40 + k * 37, 0.002f, 257.0f, 37.0f, i, j, onPxW, onPxH, monitorHeight, false);
                float sx = 2.0f;
                if (!music.getImage().isEmpty()) {
                    sx += 39.0f;
                    PlayImageRenderer.getInstance().renderSprite(music.getImage(), poseStack, multiBufferSource, 103.0f * onPxW, monitorHeight - (float)(40 + k * 37 + 1 + 35) * onPxH, 0.004f, 35.0f * onPxH, i, j);
                }
                class_5250 nt = class_2561.method_43470((String)music.getName());
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)nt, sx + 3.0f + 102.0f, 40 + k * 37 + 3, 0.004f, onPxW, onPxH, monitorHeight, Math.min(1.0f, (258.0f - sx - 15.0f) / (float)IIMPSmartRender.mc.field_1772.method_27525((class_5348)nt)), i);
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43470((String)music.getAuthor()), sx + 3.0f + 102.0f, 40 + k * 37 + 14, 0.004f, onPxW, onPxH, monitorHeight, i);
                class_2561 pname = OEClientUtils.getPlayerNameByUUID((UUID)music.getOwner()).map(n -> class_2561.method_43470((String)n)).orElse(MusicsFixedListWidget.UNKNOWN_PLAYER_TEXT);
                poseStack.method_22903();
                poseStack.method_46416((sx + 102.0f + 2.0f) * onPxW, monitorHeight - (float)(40 + k * 37 + 23 + 9) * onPxH, 0.004f);
                OERenderUtils.renderPlayerFaceSprite((class_4587)poseStack, (class_4597)multiBufferSource, (UUID)music.getOwner(), (float)(onPxH * 9.0f), (int)i, (int)j);
                poseStack.method_22909();
                this.renderSmartTextSprite(poseStack, multiBufferSource, pname, sx + 3.0f + 102.0f + 12.0f, 40 + k * 37 + 26, 0.004f, onPxW, onPxH, monitorHeight, i);
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43470((String)MyPlayListFixedListWidget.dateFormat.format(new Date(music.getCreateDate()))), sx + 3.0f + 102.0f + 12.0f + 88.0f, 40 + k * 37 + 26, 0.004f, onPxW, onPxH, monitorHeight, i);
            }
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 360.0f, 40.0f, 0.002f, 148.0f, i, j, onPxW, onPxH, monitorHeight, msc, 4);
        MusicPlayList pl = this.getSelectedMusicPlayList(blockEntity);
        if (pl != null) {
            int plsty;
            this.renderSmartButtonSprite(poseStack, multiBufferSource, 336.0f, 20.0f, 0.002f, 33.0f, 9.0f, i, j, onPxW, onPxH, monitorHeight, DETAIL_TEXT, true);
            List<UUID> au = pl.getAuthority().getPlayersAuthority().entrySet().stream().sorted(Comparator.comparingInt(o -> ((AuthorityInfo.AuthorityType)((Object)((Object)o.getValue()))).getLevel())).map(Map.Entry::getKey).filter(n -> !n.equals(pl.getAuthority().getOwner())).toList();
            if (au.size() == 0) {
                this.renderPlayerFaceSprite(poseStack, multiBufferSource, pl.getAuthority().getOwner(), 328.0f, 20.5f, 0.002f, 7.0f, i, j, onPxW, onPxH, monitorHeight);
                plsty = 14;
            } else if (au.size() == 1) {
                this.renderPlayerFaceSprite(poseStack, multiBufferSource, au.get(0), 328.0f, 20.5f, 0.002f, 7.0f, i, j, onPxW, onPxH, monitorHeight);
                this.renderPlayerFaceSprite(poseStack, multiBufferSource, pl.getAuthority().getOwner(), 319.0f, 20.5f, 0.002f, 7.0f, i, j, onPxW, onPxH, monitorHeight);
                plsty = 20;
            } else {
                class_5250 tx = class_2561.method_43470((String)("+" + au.size()));
                int txw = PlayListMMMonitor.mc.field_1772.method_27525((class_5348)tx);
                this.renderPlayerFaceSprite(poseStack, multiBufferSource, au.get(0), 336 - txw - 2 - 8, 20.5f, 0.002f, 7.0f, i, j, onPxW, onPxH, monitorHeight);
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)tx, 336 - txw - 2, 22.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
                plsty = 18 + txw;
            }
            this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)class_2561.method_43470((String)OEClientUtils.getWidthOmitText((String)pl.getName(), (float)(235 - plsty), (String)"...")), 103.0f, 22.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.musicPlayListsCash != this.getSyncManager().getMyPlayList()) {
            this.musicPlayListsCash = this.getSyncManager().getMyPlayList();
            this.updateList();
        }
        if (this.musicsCash != this.getSyncManager().getMusics(this.getSelectedPlayList())) {
            this.musicsCash = this.getSyncManager().getMusics(this.getSelectedPlayList());
            this.updateMusics();
        }
        this.updateInfoText();
        this.addMusic.field_22763 = this.getSelectedMusicPlayList() != null && this.getSelectedMusicPlayList().getAuthority().getAuthorityType(IIMPSmartRender.mc.field_1724.method_7334().getId()).isMoreMember();
        this.detailButton.field_22764 = this.getSelectedMusicPlayList() != null;
    }

    private void updateList() {
        this.musicPlayLists.clear();
        if (this.musicPlayListsCash != null) {
            this.musicPlayLists.addAll(this.playlistSortButton.sort(this.musicPlayListsCash, this.playlistOrderButton));
        }
        if (this.getSelectedMusicPlayList() == null) {
            this.setSelectedPlayList(null);
        }
    }

    private void updateMusics() {
        this.musics.clear();
        if (this.musicsCash != null) {
            this.musics.addAll(this.musicSortButton.sort(this.musicsCash, this.musicOrderButton));
        }
    }

    private void updateInfoText() {
        MusicSyncManager pls = this.getSyncManager();
        if (pls.getMyPlayListInfo() != this.lastPlayListInfo) {
            this.lastPlayListInfo = pls.getMyPlayListInfo();
            this.INFO_TEXT = this.lastPlayListInfo != null ? class_2561.method_43469((String)"imp.text.playlistInfo", (Object[])new Object[]{this.lastPlayListInfo.playListCount(), this.lastPlayListInfo.musicCount()}) : null;
        }
    }

    public void setSelectedMusic(@Nullable UUID uuid) {
        this.getScreen().insSelectedMusic(uuid);
    }

    @Nullable
    public UUID getSelectedMusicRaw() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedMusicRaw(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    public UUID getSelectedMusicRaw(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedMusic((class_1657)PlayListMMMonitor.mc.field_1724);
    }

    public MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return this.getSyncManager().getMyPlayList().stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    public MusicPlayList getSelectedMusicPlayList() {
        return this.musicPlayLists.stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList())).findFirst().orElse(null);
    }

    public UUID getSelectedPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    public UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedPlayList((class_1657)PlayListMMMonitor.mc.field_1724);
    }

    private void setSelectedPlayList(UUID selectedPlayList) {
        this.getScreen().insSelectedPlayList(selectedPlayList);
    }

    @Override
    public void onUpdateSelectedPlayList(UUID playListId) {
        this.updateMusics();
    }
}

