/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.lava;

import dev.felnull.imp.client.lava.LavaNativeManager;
import dev.felnull.imp.client.lava.LavaPlayerLoader;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.NativeLibraryProperties;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.architecture.DefaultOperatingSystemTypes;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.architecture.SystemType;
import java.nio.file.Path;
import java.util.function.Predicate;

public class IMPSystemNativeLibraryProperties
implements NativeLibraryProperties {
    private final Predicate<SystemType> systemFilter;
    private final String libraryName;

    public IMPSystemNativeLibraryProperties(String libraryName, Predicate<SystemType> systemFilter) {
        this.systemFilter = systemFilter;
        this.libraryName = libraryName;
    }

    @Override
    public String getLibraryPath() {
        return null;
    }

    @Override
    public String getLibraryDirectory() {
        boolean ret;
        SystemType sys = IMPSystemNativeLibraryProperties.detectMatchingSystemType(this, this.systemFilter);
        if (sys == null) {
            throw new IllegalStateException("System type is null");
        }
        Object natName = sys.osType.identifier();
        if (sys.osType != DefaultOperatingSystemTypes.DARWIN) {
            natName = (String)natName + "-" + sys.architectureType.identifier();
        }
        if (!(ret = LavaNativeManager.getInstance().load((String)natName, sys.formatLibraryName(this.libraryName)))) {
            throw new UnsatisfiedLinkError("Failed to load the library");
        }
        Path p = LavaPlayerLoader.getNaiveLibraryFolder().resolve((String)natName);
        return p.toAbsolutePath().toString();
    }

    @Override
    public String getExtractionPath() {
        return null;
    }

    @Override
    public String getSystemName() {
        return null;
    }

    @Override
    public String getLibraryFileNamePrefix() {
        return null;
    }

    @Override
    public String getLibraryFileNameSuffix() {
        return null;
    }

    @Override
    public String getArchitectureName() {
        return null;
    }

    private static SystemType detectMatchingSystemType(NativeLibraryProperties properties, Predicate<SystemType> systemFilter) {
        SystemType systemType;
        try {
            systemType = SystemType.detect(properties);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (systemFilter != null && !systemFilter.test(systemType)) {
            return null;
        }
        return systemType;
    }
}

