/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loader;

import com.google.common.collect.ImmutableList;
import dev.felnull.imp.client.music.loader.LavaMusicLoader;
import dev.felnull.imp.client.music.loader.MusicLoader;
import dev.felnull.imp.client.music.loader.NetEaseCloudMusicLoader;
import dev.felnull.imp.client.music.loader.YoutubeDownloaderMusicLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class IMPMusicLoaders {
    private static final List<Supplier<MusicLoader>> LOADER_FACTORIES = new ArrayList<Supplier<MusicLoader>>();

    public static void init() {
        IMPMusicLoaders.register(LavaMusicLoader::new);
        IMPMusicLoaders.register(NetEaseCloudMusicLoader::new);
        IMPMusicLoaders.register(YoutubeDownloaderMusicLoader::new);
    }

    public static void register(Supplier<MusicLoader> loaderSupplier) {
        LOADER_FACTORIES.add(loaderSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Supplier<MusicLoader>> getAllLoader() {
        List<Supplier<MusicLoader>> list = LOADER_FACTORIES;
        synchronized (list) {
            return ImmutableList.copyOf(LOADER_FACTORIES);
        }
    }
}

