/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.github.kiulian.downloader.model.search;

import dev.felnull.imp.include.com.alibaba.fastjson.JSONArray;
import dev.felnull.imp.include.com.alibaba.fastjson.JSONObject;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.search.SearchResultItem;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.search.SearchResultItemType;
import dev.felnull.imp.include.com.github.kiulian.downloader.model.search.SearchResultVideoDetails;
import java.util.ArrayList;
import java.util.List;

public class SearchResultShelf
implements SearchResultItem {
    private final String title;
    private final List<SearchResultVideoDetails> videos;

    public SearchResultShelf(JSONObject json) {
        this.title = json.getJSONObject("title").getString("simpleText");
        JSONObject jsonContent = json.getJSONObject("content");
        String contentRendererKey = jsonContent.keySet().iterator().next();
        boolean isMovieShelf = contentRendererKey.contains("Movie");
        JSONArray jsonItems = jsonContent.getJSONObject(contentRendererKey).getJSONArray("items");
        this.videos = new ArrayList<SearchResultVideoDetails>(jsonItems.size());
        for (int i = 0; i < jsonItems.size(); ++i) {
            JSONObject jsonItem = jsonItems.getJSONObject(i);
            String itemRendererKey = jsonItem.keySet().iterator().next();
            this.videos.add(new SearchResultVideoDetails(jsonItem.getJSONObject(itemRendererKey), isMovieShelf));
        }
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.SHELF;
    }

    @Override
    public SearchResultShelf asShelf() {
        return this;
    }

    @Override
    public String title() {
        return this.title;
    }

    public List<SearchResultVideoDetails> videos() {
        return this.videos;
    }
}

