/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import java.util.concurrent.atomic.AtomicReference;

public class TrackMarkerTracker {
    private final AtomicReference<TrackMarker> current = new AtomicReference();

    public void set(TrackMarker marker, long currentTimecode) {
        TrackMarker previous = this.current.getAndSet(marker);
        if (previous != null) {
            previous.handler.handle(marker != null ? TrackMarkerHandler.MarkerState.OVERWRITTEN : TrackMarkerHandler.MarkerState.REMOVED);
        }
        if (marker != null && currentTimecode >= marker.timecode) {
            this.trigger(marker, TrackMarkerHandler.MarkerState.LATE);
        }
    }

    public TrackMarker remove() {
        return this.current.getAndSet(null);
    }

    public void trigger(TrackMarkerHandler.MarkerState state) {
        TrackMarker marker = this.current.getAndSet(null);
        if (marker != null) {
            marker.handler.handle(state);
        }
    }

    public void checkPlaybackTimecode(long timecode) {
        TrackMarker marker = this.current.get();
        if (marker != null && timecode >= marker.timecode) {
            this.trigger(marker, TrackMarkerHandler.MarkerState.REACHED);
        }
    }

    public void checkSeekTimecode(long timecode) {
        TrackMarker marker = this.current.get();
        if (marker != null && timecode >= marker.timecode) {
            this.trigger(marker, TrackMarkerHandler.MarkerState.BYPASSED);
        }
    }

    private void trigger(TrackMarker marker, TrackMarkerHandler.MarkerState state) {
        if (this.current.compareAndSet(marker, null)) {
            marker.handler.handle(state);
        }
    }
}

