/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.block.utility;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.HashSet;
import me.mgin.graves.Graves;
import me.mgin.graves.api.InventoriesApi;
import me.mgin.graves.block.GraveBlocks;
import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.block.utility.Experience;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.state.ServerState;
import me.mgin.graves.util.Responder;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2874;

public class PlaceGrave {
    private static int minY;

    public static void place(class_1937 world, class_243 vecPos, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        class_2338 initialPos = new class_2338((int)Math.floor(vecPos.field_1352), (int)vecPos.field_1351, (int)Math.floor(vecPos.field_1350));
        class_2338 pos = PlaceGrave.enforceWorldBoundaries(world, initialPos);
        class_2338 belowPos = new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260());
        if (PlaceGrave.graveShouldSink(world, belowPos, player)) {
            pos = PlaceGrave.sinkDownwards(world, belowPos, pos.method_10264() - (minY + 7), player);
        }
        if (!PlaceGrave.canPlaceGrave(world, initialPos) || !PlaceGrave.isLiquidOrAir(world, initialPos)) {
            pos = PlaceGrave.searchOutwards(world, pos, player);
        }
        PlaceGrave.spawnGrave(world, pos, player);
    }

    private static boolean isLiquidOrAir(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26215() || state.method_51176();
    }

    private static class_2338 enforceWorldBoundaries(class_1937 world, class_2338 pos) {
        int maxY = world.method_31600() - 1;
        minY = world.method_8597().comp_651();
        if (pos.method_10264() >= maxY) {
            pos = new class_2338(pos.method_10263(), maxY - 1, pos.method_10260());
        }
        if (minY > pos.method_10264()) {
            pos = new class_2338(pos.method_10263(), minY + 7, pos.method_10260());
        }
        return pos;
    }

    public static boolean graveShouldSink(class_1937 world, class_2338 pos, class_1657 player) {
        GameProfile profile = player.method_7334();
        class_2248 block = world.method_8320(pos).method_26204();
        if (!PlaceGrave.isLiquidOrAir(world, pos)) {
            return false;
        }
        return switch (block.method_9518().getString()) {
            case "Air" -> (Boolean)GravesConfig.resolve("sinkInAir", profile);
            case "Water" -> (Boolean)GravesConfig.resolve("sinkInWater", profile);
            case "Lava" -> (Boolean)GravesConfig.resolve("sinkInLava", profile);
            default -> false;
        };
    }

    private static class_2338 sinkDownwards(class_1937 world, class_2338 pos, int depth, class_1657 player) {
        for (class_2338 newPos : class_2338.method_25996((class_2338)pos.method_10081(new class_2382(0, -1, 0)), (int)0, (int)depth, (int)0)) {
            if (PlaceGrave.graveShouldSink(world, newPos, player)) continue;
            return new class_2338(newPos.method_10263(), newPos.method_10264() + 1, newPos.method_10260());
        }
        return pos;
    }

    private static boolean canPlaceGrave(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        class_2586 blockEntity = world.method_8321(pos);
        HashSet<class_2248> blackListedBlocks = new HashSet<class_2248>(){
            {
                this.add(class_2246.field_9987);
            }
        };
        if (blockEntity != null) {
            return false;
        }
        if (blackListedBlocks.contains(block)) {
            return false;
        }
        class_2874 dimension = world.method_8597();
        return pos.method_10264() >= dimension.comp_651() && pos.method_10264() <= world.method_31600();
    }

    private static class_2338 searchOutwards(class_1937 world, class_2338 pos, class_1657 player) {
        class_2338 initialPos = pos;
        class_2338 nonIdeal = pos;
        boolean idealBlockFound = false;
        for (class_2338 newPos : class_2338.method_25996((class_2338)pos, (int)10, (int)10, (int)10)) {
            if (!PlaceGrave.canPlaceGrave(world, newPos)) continue;
            class_2338 belowPos = new class_2338(newPos.method_10263(), newPos.method_10264() - 1, newPos.method_10260());
            if (PlaceGrave.graveShouldSink(world, belowPos, player)) {
                newPos = PlaceGrave.sinkDownwards(world, belowPos, pos.method_10264() - (minY + 7), player);
            }
            if (idealBlockFound = PlaceGrave.isLiquidOrAir(world, newPos)) {
                pos = newPos;
                break;
            }
            boolean nonIdealIsInitial = nonIdeal == initialPos;
            boolean cantPlaceInitial = !PlaceGrave.canPlaceGrave(world, pos);
            boolean canPlaceNewPos = PlaceGrave.canPlaceGrave(world, newPos);
            if (!nonIdealIsInitial || !cantPlaceInitial || !canPlaceNewPos) continue;
            nonIdeal = newPos;
        }
        return idealBlockFound ? pos : nonIdeal;
    }

    public static void spawnGrave(class_1937 world, class_2338 pos, class_1657 player) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        world.method_8501(pos, (class_2680)GraveBlocks.GRAVE.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)player.method_5735()));
        GraveBlockEntity graveEntity = new GraveBlockEntity(pos, world.method_8320(pos));
        for (InventoriesApi api : Graves.inventories) {
            class_2371<class_1799> inventory = api.getInventory(player);
            if (inventory == null) continue;
            graveEntity.setInventory(api.getID(), inventory);
            api.clearInventory(player);
        }
        graveEntity.setGraveOwner(player.method_7334());
        int experience = Experience.calculatePlayerExperience(player);
        graveEntity.setXp(experience);
        PlaceGrave.resetPlayerExperience(player);
        graveEntity.setMstime(new Date().getTime());
        block.method_9576(world, pos, state, player);
        world.method_8438((class_2586)graveEntity);
        ServerState.storePlayerGrave(player, graveEntity);
        boolean graveCoordinates = (Boolean)GravesConfig.resolve("graveCoordinates", player.method_7334());
        if (graveCoordinates) {
            Responder res = new Responder(player, player.method_5682());
            String dimension = String.valueOf(world.method_44013().method_29177());
            res.sendInfo((class_2561)class_2561.method_43469((String)"event.death:send-player-coordinates", (Object[])new Object[]{res.dimension(pos.method_10263(), dimension), res.dimension(pos.method_10264(), dimension), res.dimension(pos.method_10260(), dimension)}), null);
        }
        System.out.printf("[%s] Grave spawned at: %dx %dy %dz for player %s.\n", Graves.MOD_ID, pos.method_10263(), pos.method_10264(), pos.method_10260(), player.method_5477().getString());
    }

    private static void resetPlayerExperience(class_1657 player) {
        player.field_7495 = 0;
        player.field_7510 = 0.0f;
        player.field_7520 = 0;
    }
}

