/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.mgin.graves.Graves;
import me.mgin.graves.block.utility.RetrieveGrave;
import me.mgin.graves.command.ListCommand;
import me.mgin.graves.command.utility.ArgumentUtility;
import me.mgin.graves.state.PlayerState;
import me.mgin.graves.state.ServerState;
import me.mgin.graves.util.DateFormatter;
import me.mgin.graves.util.NbtHelper;
import me.mgin.graves.util.Responder;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RestoreCommand {
    public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        Responder res = new Responder((class_1657)source.method_44023(), server);
        GameProfile player = ArgumentUtility.getProfileArgument(context, "player", 3);
        int graveId = (Integer)context.getArgument("graveid", Integer.class);
        GameProfile recipient = ArgumentUtility.getProfileArgument(context, "recipient", 5);
        boolean showList = ArgumentUtility.getBooleanArgument(context, "showlist", 6);
        if (player == null) {
            res.send((class_2561)class_2561.method_43471((String)"command.generic.error.specify-player"), null);
            return 1;
        }
        String name = player.getName();
        PlayerState playerState = ServerState.getPlayerState(server, player.getId());
        if (graveId > playerState.graves.size()) {
            res.sendError((class_2561)class_2561.method_43469((String)"command.generic.error.grave-doesnt-exist", (Object[])new Object[]{name}), null);
            return 1;
        }
        class_2487 grave = (class_2487)playerState.graves.method_10534(graveId - 1);
        GameProfile entityProfile = recipient != null ? recipient : player;
        class_3222 entity = server.method_3760().method_14602(entityProfile.getId());
        if (entity == null) {
            res.sendError((class_2561)class_2561.method_43469((String)"command.generic.error.player-not-online", (Object[])new Object[]{entityProfile.getName()}), null);
            return 1;
        }
        RetrieveGrave.retrieveWithCommand((class_1657)entity, grave);
        RestoreCommand.sendPlayerFeedback((class_2168)context.getSource(), player, (class_1657)entity, res, RestoreCommand.generateHoverContent(res, grave, graveId, ((class_2168)context.getSource()).method_9214()));
        System.out.printf("[%s] %s has restored %s's grave to %s. (ID: %d)\n", Graves.MOD_ID, ((class_2168)context.getSource()).method_9214(), player.getName(), entity.method_5820(), graveId);
        if (showList) {
            int page = graveId % 5 == 0 ? graveId / 5 : (int)(Math.floor((double)graveId / 5.0) + 1.0);
            ListCommand.executeWithoutCommand(res, player, entity.method_7334(), page, server, ((class_2168)context.getSource()).method_44023());
        }
        return 1;
    }

    public static void sendPlayerFeedback(class_2168 source, GameProfile player, class_1657 entity, Responder res, class_2561 hoverContent) {
        boolean sourceIsPlayerEntity;
        GameProfile entityProfile = entity.method_7334();
        GameProfile sourceProfile = null;
        boolean bl = sourceIsPlayerEntity = source.method_44023() != null;
        if (sourceIsPlayerEntity) {
            sourceProfile = source.method_44023().method_7334();
        }
        if (player.equals(sourceProfile) && player.equals((Object)entityProfile)) {
            res.sendInfo(res.hoverText((class_2561)class_2561.method_43471((String)"command.restore.grave-restored"), hoverContent), null);
            return;
        }
        if (player.equals((Object)entityProfile)) {
            res.sendInfo(res.hoverText((class_2561)class_2561.method_43469((String)"command.restore.grave-restored-by", (Object[])new Object[]{source.method_9214()}), hoverContent), entity);
            if (sourceIsPlayerEntity) {
                res.sendInfo(res.hoverText((class_2561)class_2561.method_43469((String)"command.restore.restored-players-grave", (Object[])new Object[]{entityProfile.getName()}), hoverContent), null);
            }
            return;
        }
        if (!player.equals((Object)entityProfile) && !entityProfile.equals((Object)sourceProfile)) {
            res.sendInfo(res.hoverText((class_2561)class_2561.method_43469((String)"command.restore.received-players-grave-by", (Object[])new Object[]{player.getName(), source.method_9214()}), hoverContent), entity);
            if (sourceIsPlayerEntity) {
                res.sendInfo(res.hoverText((class_2561)class_2561.method_43469((String)"command.restore.restored-players-grave-to", (Object[])new Object[]{player.getName(), entityProfile.getName()}), hoverContent), null);
            }
            return;
        }
        if (entityProfile.equals((Object)sourceProfile) && !entityProfile.equals((Object)player)) {
            res.sendInfo(res.hoverText((class_2561)class_2561.method_43469((String)"command.restore.received-players-grave", (Object[])new Object[]{player.getName()}), hoverContent), entity);
        }
    }

    public static class_2561 generateHoverContent(Responder res, class_2487 grave, int graveId, String source) {
        String created = DateFormatter.formatDate(grave.method_10537("mstime"));
        String dimension = grave.method_10558("dimension");
        class_2338 pos = NbtHelper.readCoordinates(grave);
        GameProfile profile = NbtHelper.toGameProfile(grave.method_10562("GraveOwner"));
        return res.info(class_2561.method_43469((String)"command.restore.restored.tooltip", (Object[])new Object[]{res.highlight(profile.getName()), res.highlight(dimension), res.highlight(pos.method_10263()), res.highlight(pos.method_10264()), res.highlight(pos.method_10260()), res.highlight(created), res.highlight(graveId + 1), res.highlight(source)}));
    }
}

