/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.command.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.mgin.graves.command.utility.CommandContextData;
import me.mgin.graves.config.ConfigOptions;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.util.Responder;
import me.mgin.graves.util.ResponderTheme;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ConfigSetter {
    private final class_310 client;
    private final class_2168 source;

    public ConfigSetter(class_310 client, class_2168 source) {
        this.client = client;
        this.source = source;
    }

    public void setConfig(CommandContextData data) {
        GravesConfig config = GravesConfig.getConfig();
        String option = data.OPTION;
        List<String> value = data.VAL;
        if (value == null) {
            this.sendResponse("error.invalid-enum-value", data);
            return;
        }
        if (option.equals("clientOptions")) {
            if (!ConfigOptions.all.contains((String)((Object)value))) {
                this.sendResponse("error.invalid-config-option", data);
                return;
            }
            ArrayList<String> oldClientOptions = new ArrayList<String>(config.server.clientOptions);
            if ((value = this.updateClientOptions(config, data.ACTION, (String)((Object)value))) == null) {
                return;
            }
            if (((Object)value).equals(oldClientOptions)) {
                this.sendResponse("error.nothing-changed-client-options", data);
                return;
            }
        }
        config.setDynamicField(option, value);
        config.save();
        this.sendResponse(option.equals("clientOptions") ? "success-client-options" : "success", data);
    }

    private List<String> updateClientOptions(GravesConfig config, String action, String value) {
        List<String> clientOptions = config.server.clientOptions;
        if (action.equals("add") && !clientOptions.contains(value)) {
            clientOptions.add(value);
        }
        if (action.equals("remove")) {
            clientOptions.remove(value);
        }
        return clientOptions;
    }

    private void sendResponse(String slug, CommandContextData data) {
        class_5250 response;
        if (this.client == null && this.source == null) {
            return;
        }
        String val = String.valueOf(data.VAL);
        String option = data.OPTION;
        String text = "command.config.set:" + slug;
        class_2561 action = class_2561.method_30163((String)data.ACTION);
        class_2561 onServer = class_2561.method_30163((String)"");
        if (data.ACTION != null) {
            action = class_2561.method_43471((String)(text + ":" + data.ACTION));
        }
        if (val.equals("0b")) {
            val = "false";
        }
        if (val.equals("1b")) {
            val = "true";
        }
        if (data.IS_SERVER) {
            onServer = class_2561.method_43471((String)"command.config.set:success-server");
        }
        switch (Objects.requireNonNull(slug)) {
            case "success": {
                class_5250 class_52502 = class_2561.method_43469((String)text, (Object[])new Object[]{option, val, onServer});
                break;
            }
            case "success-client-options": {
                class_5250 class_52502 = class_2561.method_43469((String)text, (Object[])new Object[]{val, action, onServer});
                break;
            }
            case "error.invalid-enum-value": {
                class_5250 class_52502 = class_2561.method_43469((String)text, (Object[])new Object[]{option});
                break;
            }
            case "error.invalid-config-option": {
                class_5250 class_52502 = class_2561.method_43469((String)text, (Object[])new Object[]{val});
                break;
            }
            case "error.nothing-changed-client-options": {
                class_5250 class_52502 = class_2561.method_43469((String)text, (Object[])new Object[]{val, action});
                break;
            }
            default: {
                class_5250 class_52502 = response = class_2561.method_43470((String)slug);
            }
        }
        if (this.source != null) {
            Responder res = new Responder((class_1657)this.source.method_44023(), this.source.method_9211());
            res.send(slug.contains("error") ? res.error(response) : res.success(response), null);
        }
        if (this.client != null && this.client.field_1724 != null) {
            class_5250 prefix = ResponderTheme.style((class_2561)class_2561.method_43471((String)"forgottengraves.small"), "prefix").method_27661().method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"forgottengraves.normal").method_27692(class_124.field_1054))));
            class_5250 res = class_2561.method_43470((String)"").method_10852((class_2561)prefix).method_27692(class_124.field_1070).method_10852((class_2561)response);
            this.client.field_1724.method_43496(ResponderTheme.style((class_2561)res, slug.contains("error") ? "error" : "success"));
        }
    }
}

