/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.config;

import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.mgin.graves.block.decay.DecayingGrave;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.config.enums.ExperienceType;
import me.mgin.graves.config.enums.GraveDropType;
import me.mgin.graves.config.enums.GraveExpStoreType;
import me.mgin.graves.config.enums.GraveRetrievalType;
import net.minecraft.class_2168;

public class ConfigOptions {
    public static List<String> subclass = new ArrayList<String>();
    public static List<String> all = new ArrayList<String>();
    public static Map<String, List<String>> options = new HashMap<String, List<String>>();
    public static Map<String, List<String>> enums = new HashMap<String, List<String>>();

    public static void generateConfigOptions() {
        for (Field field : GravesConfig.class.getDeclaredFields()) {
            subclass.add(field.getName());
            Class<?> clazz = field.getType();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Field subfield : clazz.getDeclaredFields()) {
                if (subfield.getType().isEnum()) {
                    List<String> constants = Arrays.stream(subfield.getType().getEnumConstants()).map(Object::toString).toList();
                    enums.put(subfield.getName(), constants);
                }
                fieldNames.add(subfield.getName());
            }
            options.put(field.getName(), fieldNames);
            all.addAll(fieldNames);
        }
    }

    public static Enum<?> convertStringToEnum(String option, String value) {
        if (!enums.get(option).contains(value)) {
            return null;
        }
        return switch (option) {
            case "retrievalType" -> GraveRetrievalType.valueOf(value);
            case "dropType" -> GraveDropType.valueOf(value);
            case "expStorageType" -> GraveExpStoreType.valueOf(value);
            case "capType", "percentageType" -> ExperienceType.valueOf(value);
            case "decayRobbing" -> DecayingGrave.BlockDecay.valueOf(value);
            default -> throw new IllegalStateException("Unexpected value for '" + option + "': " + value);
        };
    }

    public static SuggestionProvider<class_2168> suggest(List<String> suggestionList) {
        return (context, builder) -> {
            String option = ((ParsedCommandNode)context.getNodes().get(context.getNodes().size() - 1)).getNode().getName();
            String[] input = context.getInput().split(" ");
            Object original = null;
            String argument = null;
            if (option.equals("add") || option.equals("remove")) {
                original = "clientOptions:" + option;
            }
            if (option.contains(":")) {
                original = option;
                option = option.split(":")[1];
            }
            if (!all.contains(original != null ? ((String)original).split(":")[0] : option)) {
                return CompletableFuture.completedFuture(builder.build());
            }
            if (!input[input.length - 1].equals(option)) {
                argument = (String)context.getArgument((String)(original == null ? option : original), String.class);
            }
            for (String suggestion : suggestionList) {
                if (argument != null && !suggestion.toLowerCase().contains(argument.toLowerCase())) continue;
                builder.suggest(suggestion);
            }
            return CompletableFuture.completedFuture(builder.build());
        };
    }
}

