/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.mixin;

import me.mgin.graves.block.entity.GraveBlockEntity;
import me.mgin.graves.client.GravesClient;
import me.mgin.graves.config.ConfigOptions;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.config.enums.GraveRetrievalType;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_636.class})
public class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private class_310 field_3712;

    @Inject(method={"breakBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void breakBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir, class_1937 world, class_2680 state, class_2248 block) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity) {
            GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
            if (graveEntity.getGraveOwner() == null) {
                return;
            }
            boolean graveRobbing = ClientPlayerInteractionManagerMixin.resolveConfig((String)"graveRobbing").server.graveRobbing;
            boolean canBreak = ClientPlayerInteractionManagerMixin.resolveConfig((String)"retrievalType").main.retrievalType.equals((Object)GraveRetrievalType.BREAK);
            boolean canOverride = false;
            boolean isOwner = false;
            if (this.field_3712.field_1724 != null) {
                canOverride = this.field_3712.field_1724.method_5687(ClientPlayerInteractionManagerMixin.resolveConfig((String)"OPOverrideLevel").server.OPOverrideLevel);
                isOwner = graveEntity.getGraveOwner().equals((Object)this.field_3712.field_1724.method_7334());
            }
            if (!(graveRobbing && canOverride && canBreak && isOwner)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    private static GravesConfig resolveConfig(String option) {
        if (GravesClient.SERVER_CONFIG == null) {
            return GravesConfig.getConfig();
        }
        GravesConfig serverConfig = GravesClient.SERVER_CONFIG;
        if (ConfigOptions.options.get("server").contains(option)) {
            return serverConfig;
        }
        if (serverConfig.server.clientOptions.contains(option)) {
            return GravesConfig.getConfig();
        }
        return serverConfig;
    }
}

