/*
 * Decompiled with CFR 0.152.
 */
package me.mgin.graves.networking.config.event;

import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.Set;
import me.mgin.graves.Graves;
import me.mgin.graves.config.GravesConfig;
import me.mgin.graves.networking.config.ConfigNetworking;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class ConfigNetworkingEvents {
    private static Set<class_3222> listeners = new HashSet<class_3222>();

    public static void registerClientEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            GravesConfig config = GravesConfig.getConfig();
            ConfigNetworkingEvents.sendConfigC2S(config);
        });
        AutoConfig.getConfigHolder(GravesConfig.class).registerLoadListener((manager, config) -> {
            ConfigNetworkingEvents.sendConfigC2S(config);
            return class_1269.field_5812;
        });
        AutoConfig.getConfigHolder(GravesConfig.class).registerSaveListener((manager, config) -> {
            ConfigNetworkingEvents.sendConfigC2S(config);
            return class_1269.field_5812;
        });
    }

    public static void registerServerEvents() {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            listeners.remove(handler.field_14140);
            GameProfile profile = handler.field_14140.method_7334();
            Graves.clientConfigs.remove(profile);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            listeners.add(handler.field_14140);
            ConfigNetworkingEvents.sendConfigS2C(GravesConfig.getConfig(), handler.field_14140);
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            AutoConfig.getConfigHolder(GravesConfig.class).registerLoadListener((manager, config) -> {
                listeners.forEach(player -> ConfigNetworkingEvents.sendConfigS2C(config, player));
                return class_1269.field_5812;
            });
            AutoConfig.getConfigHolder(GravesConfig.class).registerSaveListener((manager, config) -> {
                listeners.forEach(player -> ConfigNetworkingEvents.sendConfigS2C(config, player));
                return class_1269.field_5812;
            });
        }
    }

    private static void sendConfigC2S(GravesConfig config) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(config.serialize());
        ClientPlayNetworking.send((class_2960)ConfigNetworking.STORE_CONFIG_C2S, (class_2540)buf);
    }

    private static void sendConfigS2C(GravesConfig config, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(config.serialize());
        ServerPlayNetworking.send((class_3222)player, (class_2960)ConfigNetworking.STORE_CONFIG_S2C, (class_2540)buf);
    }
}

