/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.RecipeFillButtonWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.jemi.JemiRecipe;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiRecipeLayoutBuilder;
import dev.emi.emi.jemi.impl.JemiRecipeSlot;
import dev.emi.emi.jemi.impl.JemiRecipeSlotsView;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class JemiRecipeHandler<T extends class_1703, R>
implements EmiRecipeHandler<T> {
    private final RecipeType<R> type;
    public IRecipeTransferHandler<T, R> handler;

    public JemiRecipeHandler(IRecipeTransferHandler<T, R> handler) {
        this.handler = handler;
        this.type = handler.getRecipeType();
    }

    @Override
    public boolean alwaysDisplaySupport(EmiRecipe recipe) {
        return this.type != null;
    }

    @Override
    public EmiPlayerInventory getInventory(class_465<T> screen) {
        return new EmiPlayerInventory(List.of());
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return (this.type == null || this.getRawRecipe(recipe) != null) && recipe.supportsRecipeTree();
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        IRecipeTransferError err = this.jeiCraft(recipe, context, false, null);
        return err == null || err.getType().allowsTransfer;
    }

    @Override
    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        IRecipeTransferError err = this.jeiCraft(recipe, context, true, null);
        if (err == null || err.getType().allowsTransfer) {
            class_310.method_1551().method_1507(context.getScreen());
        }
        return err == null || err.getType().allowsTransfer;
    }

    @Override
    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, class_332 raw) {
        EmiDrawContext draw = EmiDrawContext.wrap(raw);
        R rawRecipe = this.getRawRecipe(recipe);
        JemiRecipeSlotsView view = this.createSlotsView(recipe, rawRecipe, widgets);
        IRecipeTransferError err = this.jeiCraft(recipe, context, false, view);
        if (err != null) {
            if (err.getType() == IRecipeTransferError.Type.COSMETIC) {
                for (Widget widget : widgets) {
                    if (!(widget instanceof RecipeFillButtonWidget)) continue;
                    Bounds b = widget.getBounds();
                    draw.fill(b.left(), b.top(), b.width(), b.height(), err.getButtonHighlightColor());
                }
            }
            if (view != null) {
                view.getSlotViews().forEach(v -> {
                    if (v instanceof JemiRecipeSlot) {
                        JemiRecipeSlot jrs = (JemiRecipeSlot)v;
                        jrs.highlight = 0;
                    }
                });
                draw.push();
                draw.matrices().method_46416(-100000.0f, -100000.0f, -100000.0f);
                draw.matrices().method_22905(0.0f, 0.0f, 0.0f);
                err.showError(raw, EmiScreenManager.lastMouseX, EmiScreenManager.lastMouseY, (IRecipeSlotsView)view, 0, 0);
                draw.pop();
                view.getSlotViews().forEach(v -> {
                    if (v instanceof JemiRecipeSlot) {
                        JemiRecipeSlot jrs = (JemiRecipeSlot)v;
                        if (jrs.highlight != 0 && !jrs.isEmpty()) {
                            draw.fill(jrs.x, jrs.y, 18, 18, jrs.highlight);
                        }
                    }
                });
            }
        }
    }

    private IRecipeTransferError jeiCraft(EmiRecipe recipe, EmiCraftContext<T> context, boolean craft, JemiRecipeSlotsView view) {
        try {
            class_310 client = class_310.method_1551();
            R rawRecipe = this.getRawRecipe(recipe);
            if (view == null) {
                view = this.createSlotsView(recipe, rawRecipe, List.of());
            }
            if (view == null) {
                return () -> IRecipeTransferError.Type.INTERNAL;
            }
            return this.handler.transferRecipe(context.getScreenHandler(), rawRecipe != null ? rawRecipe : recipe, (IRecipeSlotsView)view, (class_1657)client.field_1724, context.getAmount() > 1, craft);
        }
        catch (Exception e) {
            e.printStackTrace();
            return () -> IRecipeTransferError.Type.INTERNAL;
        }
    }

    private JemiRecipeSlotsView createSlotsView(EmiRecipe recipe, R rawRecipe, List<Widget> widgets) {
        JemiRecipeLayoutBuilder builder = null;
        if (rawRecipe == null && this.type != null) {
            return null;
        }
        if (builder == null) {
            List<SlotWidget> slotWidgets = widgets.stream().filter(w -> w instanceof SlotWidget).map(w -> (SlotWidget)w).toList();
            builder = new JemiRecipeLayoutBuilder();
            this.addIngredients(builder, slotWidgets, recipe.getOutputs(), RecipeIngredientRole.OUTPUT);
            int blankedSlots = 0;
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe ecr = (EmiCraftingRecipe)recipe;
                if (ecr.shapeless) {
                    int inputSize = recipe.getInputs().size();
                    if (inputSize == 1) {
                        this.addBlankIngredients(builder, slotWidgets, 4, RecipeIngredientRole.INPUT);
                        blankedSlots += 4;
                        this.addIngredients(builder, slotWidgets, recipe.getInputs(), RecipeIngredientRole.INPUT);
                    } else if (inputSize < 5) {
                        int wrap = 0;
                        for (EmiIngredient i : recipe.getInputs()) {
                            this.addIngredients(builder, slotWidgets, List.of(i), RecipeIngredientRole.INPUT);
                            if (++wrap < 2) continue;
                            wrap = 0;
                            this.addBlankIngredients(builder, slotWidgets, 1, RecipeIngredientRole.INPUT);
                            ++blankedSlots;
                        }
                    } else {
                        this.addIngredients(builder, slotWidgets, recipe.getInputs(), RecipeIngredientRole.INPUT);
                    }
                } else {
                    if (ecr.canFit(1, 3)) {
                        this.addBlankIngredients(builder, slotWidgets, 1, RecipeIngredientRole.INPUT);
                        ++blankedSlots;
                    } else if (ecr.canFit(3, 1) || ecr.canFit(3, 2) && !ecr.canFit(2, 2)) {
                        this.addBlankIngredients(builder, slotWidgets, 3, RecipeIngredientRole.INPUT);
                        blankedSlots += 3;
                    }
                    this.addIngredients(builder, slotWidgets, recipe.getInputs().subList(0, Math.max(9, recipe.getInputs().size()) - blankedSlots), RecipeIngredientRole.INPUT);
                }
            } else {
                this.addIngredients(builder, slotWidgets, recipe.getInputs(), RecipeIngredientRole.INPUT);
            }
            if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING) {
                for (int i = recipe.getInputs().size() + blankedSlots; i < 9; ++i) {
                    this.addIngredients(builder, slotWidgets, List.of(EmiStack.EMPTY), RecipeIngredientRole.INPUT);
                }
            }
            this.addIngredients(builder, slotWidgets, recipe.getCatalysts(), RecipeIngredientRole.CATALYST);
        }
        return new JemiRecipeSlotsView(builder.slots.stream().map(JemiRecipeSlot::new).toList());
    }

    private R getRawRecipe(EmiRecipe recipe) {
        try {
            Optional opt;
            class_310 client = class_310.method_1551();
            class_1863 manager = client.field_1687.method_8433();
            if (this.type != null && this.type.getRecipeClass() != null) {
                if (recipe instanceof JemiRecipe) {
                    JemiRecipe jr = (JemiRecipe)recipe;
                    if (jr.recipe != null && this.type.getRecipeClass().isAssignableFrom(jr.recipe.getClass())) {
                        return (R)this.type.getRecipeClass().cast(jr.recipe);
                    }
                }
                if (manager != null && (opt = manager.method_8130(recipe.getId())).isPresent()) {
                    class_1860 r = (class_1860)opt.get();
                    if (this.type.getRecipeClass().isAssignableFrom(r.getClass())) {
                        return (R)this.type.getRecipeClass().cast(r);
                    }
                }
            }
            if (manager != null && (opt = manager.method_8130(recipe.getId())).isPresent()) {
                return (R)opt.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void addBlankIngredients(JemiRecipeLayoutBuilder builder, List<SlotWidget> widgets, int amount, RecipeIngredientRole role) {
        for (int i = 0; i < amount; ++i) {
            this.addIngredients(builder, widgets, List.of(EmiStack.EMPTY), RecipeIngredientRole.INPUT);
        }
    }

    private void addIngredients(JemiRecipeLayoutBuilder builder, List<SlotWidget> widgets, List<? extends EmiIngredient> stacks, RecipeIngredientRole role) {
        for (EmiIngredient emiIngredient : stacks) {
            int x = 0;
            int y = 0;
            for (SlotWidget w : widgets) {
                if (w.getStack() != emiIngredient) continue;
                x = w.getBounds().x();
                y = w.getBounds().y();
            }
            IRecipeSlotBuilder acceptor = builder.addSlot(role, x, y);
            for (EmiStack stack : emiIngredient.getEmiStacks()) {
                Optional<ITypedIngredient<?>> opt = JemiUtil.getTyped(stack);
                if (!opt.isPresent()) continue;
                ITypedIngredient<?> typed = opt.get();
                acceptor.addIngredient(typed.getType(), typed.getIngredient());
            }
        }
    }
}

