/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.jemi.JemiPlugin;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiComparisonDefaults;
import dev.emi.emi.registry.EmiDragDropHandlers;
import dev.emi.emi.registry.EmiExclusionAreas;
import dev.emi.emi.registry.EmiIngredientSerializers;
import dev.emi.emi.registry.EmiInitRegistryImpl;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiRegistryImpl;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.registry.EmiStackProviders;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiPersistentData;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.EmiSearch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class EmiReloadManager {
    private static int loadedResourcesMask = 0;
    private static volatile boolean clear = false;
    private static volatile boolean restart = false;
    private static volatile int status = 0;
    private static Thread thread;
    public static volatile class_2561 reloadStep;
    public static volatile long reloadWorry;

    public static void reloadTags() {
        if ((loadedResourcesMask |= 1) == 3) {
            EmiLog.info("Recipes synchronized, reloading EMI");
            loadedResourcesMask = 0;
            EmiReloadManager.reload();
        } else {
            EmiLog.info("Recipes synchronized, waiting for tags to reload EMI...");
        }
    }

    public static void reloadRecipes() {
        if ((loadedResourcesMask |= 2) == 3) {
            EmiLog.info("Tags synchronized, reloading EMI");
            loadedResourcesMask = 0;
            EmiReloadManager.reload();
        } else {
            EmiLog.info("Tags synchronized, waiting for recipes to reload EMI...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Class<EmiReloadManager> clazz = EmiReloadManager.class;
        synchronized (EmiReloadManager.class) {
            clear = true;
            status = 0;
            reloadWorry = Long.MAX_VALUE;
            if (thread != null && thread.isAlive()) {
                restart = true;
            } else {
                thread = new Thread(new ReloadWorker());
                thread.setDaemon(true);
                thread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Class<EmiReloadManager> clazz = EmiReloadManager.class;
        synchronized (EmiReloadManager.class) {
            EmiReloadManager.step((class_2561)EmiPort.literal("Starting Reload"));
            status = 1;
            if (thread != null && thread.isAlive()) {
                restart = true;
            } else {
                clear = false;
                thread = new Thread(new ReloadWorker());
                thread.setDaemon(false);
                thread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void step(class_2561 text) {
        EmiReloadManager.step(text, 5000L);
    }

    public static void step(class_2561 text, long worry) {
        EmiLog.info(text.getString());
        reloadStep = text;
        reloadWorry = System.currentTimeMillis() + worry;
    }

    public static boolean isLoaded() {
        return status == 2 && (thread == null || !thread.isAlive());
    }

    public static int getStatus() {
        return status;
    }

    static {
        reloadStep = EmiPort.literal("");
        reloadWorry = Long.MAX_VALUE;
    }

    private static class ReloadWorker
    implements Runnable {
        private ReloadWorker() {
        }

        @Override
        public void run() {
            int retries = 3;
            block8: do {
                try {
                    Object container2;
                    if (!clear) {
                        EmiLog.info("Starting EMI reload...");
                    }
                    long reloadStart = System.currentTimeMillis();
                    restart = false;
                    EmiReloadManager.step((class_2561)EmiPort.literal("Clearing data"));
                    EmiRecipes.clear();
                    EmiStackList.clear();
                    EmiIngredientSerializers.clear();
                    EmiExclusionAreas.clear();
                    EmiDragDropHandlers.clear();
                    EmiStackProviders.clear();
                    EmiRecipeFiller.clear();
                    EmiHidden.clear();
                    if (clear) {
                        clear = false;
                        continue;
                    }
                    class_310 client = class_310.method_1551();
                    if (client.field_1687.method_8433() == null) {
                        EmiReloadLog.warn("Recipe Manager is null");
                        break;
                    }
                    ArrayList plugins = Lists.newArrayList();
                    plugins.addAll(EmiAgnos.getPlugins().stream().sorted((a, b) -> Integer.compare(ReloadWorker.entrypointPriority(a), ReloadWorker.entrypointPriority(b))).toList());
                    if (EmiAgnos.isModLoaded("jei")) {
                        plugins.add(new EmiPluginContainer(new JemiPlugin(), "jemi"));
                    }
                    EmiInitRegistryImpl initRegistry = new EmiInitRegistryImpl();
                    for (Object container2 : plugins) {
                        EmiReloadManager.step((class_2561)EmiPort.literal("Initializing plugin from " + ((EmiPluginContainer)container2).id()), 5000L);
                        long start = System.currentTimeMillis();
                        try {
                            ((EmiPluginContainer)container2).plugin().initialize(initRegistry);
                        }
                        catch (Throwable e) {
                            EmiReloadLog.warn("Exception initializing plugin provided by " + ((EmiPluginContainer)container2).id());
                            EmiReloadLog.error(e);
                            if (!restart) continue;
                            continue block8;
                        }
                        EmiLog.info("Initialized plugin from " + ((EmiPluginContainer)container2).id() + " in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    EmiHidden.reload();
                    EmiReloadManager.step((class_2561)EmiPort.literal("Processing tags"));
                    EmiTags.reload();
                    EmiReloadManager.step((class_2561)EmiPort.literal("Constructing index"));
                    EmiComparisonDefaults.comparisons = new HashMap<Object, Comparison>();
                    EmiStackList.reload();
                    if (restart) continue;
                    EmiRegistryImpl registry = new EmiRegistryImpl();
                    container2 = plugins.iterator();
                    while (container2.hasNext()) {
                        EmiPluginContainer container3 = (EmiPluginContainer)container2.next();
                        EmiReloadManager.step((class_2561)EmiPort.literal("Loading plugin from " + container3.id()), 10000L);
                        long start = System.currentTimeMillis();
                        try {
                            container3.plugin().register(registry);
                        }
                        catch (Throwable e) {
                            EmiReloadLog.warn("Exception loading plugin provided by " + container3.id());
                            EmiReloadLog.error(e);
                            if (!restart) continue;
                            continue block8;
                        }
                        EmiLog.info("Reloaded plugin from " + container3.id() + " in " + (System.currentTimeMillis() - start) + "ms");
                        if (!restart) continue;
                        continue block8;
                    }
                    if (restart) continue;
                    EmiReloadManager.step((class_2561)EmiPort.literal("Baking index"));
                    EmiStackList.bake();
                    EmiReloadManager.step((class_2561)EmiPort.literal("Registering late recipes"), 10000L);
                    Consumer<EmiRecipe> registerLateRecipe = registry::addRecipe;
                    for (Consumer<Consumer<EmiRecipe>> consumer : EmiRecipes.lateRecipes) {
                        try {
                            consumer.accept(registerLateRecipe);
                        }
                        catch (Exception e) {
                            EmiReloadLog.warn("Exception loading late recipes for plugins:");
                            EmiReloadLog.error(e);
                            if (!restart) continue;
                            continue block8;
                        }
                    }
                    EmiReloadManager.step((class_2561)EmiPort.literal("Baking recipes"), 15000L);
                    EmiRecipes.bake();
                    BoM.reload();
                    EmiPersistentData.load();
                    EmiReloadManager.step((class_2561)EmiPort.literal("Baking search"), 15000L);
                    EmiSearch.bake();
                    EmiReloadManager.step((class_2561)EmiPort.literal("Finishing up"));
                    EmiScreenManager.search.update();
                    EmiScreenManager.forceRecalculate();
                    EmiReloadLog.bake();
                    EmiLog.info("Reloaded EMI in " + (System.currentTimeMillis() - reloadStart) + "ms");
                    status = 2;
                }
                catch (Throwable e) {
                    EmiReloadLog.warn("Critical error occured during reload:");
                    EmiReloadLog.error(e);
                    status = -1;
                    if (retries-- <= 0) continue;
                    restart = true;
                }
            } while (restart);
            thread = null;
        }

        private static final int entrypointPriority(EmiPluginContainer container) {
            return container.id().equals("emi") ? 0 : 1;
        }
    }
}

