/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.replace;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.action.internal.CraftTweakerAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.NameUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1860;
import net.minecraft.class_2960;

public final class ActionReplaceRecipe<T extends class_1860<?>>
extends CraftTweakerAction
implements IRuntimeAction {
    private static final String REPLACER_DISCRIMINATOR = "replacer";
    private final class_2960 oldName;
    private final class_2960 newName;
    private final IRecipeManager<T> manager;
    private final Supplier<ActionAddRecipe<T>> addRecipe;
    private final ActionRemoveRecipeByName<T> removeRecipe;

    ActionReplaceRecipe(class_2960 name, IRecipeManager<T> manager, Function<class_2960, T> recipeCreator) {
        this.oldName = name;
        this.newName = this.createNewName();
        this.manager = manager;
        this.addRecipe = () -> new ActionAddRecipe<class_1860>(manager, (class_1860)recipeCreator.apply(this.newName));
        this.removeRecipe = new ActionRemoveRecipeByName<T>(this.manager, this.oldName);
    }

    @Override
    public void apply() {
        CraftTweakerAPI.apply(this.removeRecipe);
        CraftTweakerAPI.apply(this.addRecipe.get());
    }

    @Override
    public String describe() {
        return "Replacing recipe %s in manager %s (new name: %s)".formatted(this.oldName, this.manager.getCommandString(), this.newName);
    }

    private class_2960 createNewName() {
        return NameUtil.isAutogeneratedName(this.oldName) ? this.tweakAutogenerated() : this.makeNewAutogenerated();
    }

    private class_2960 tweakAutogenerated() {
        String oldPath = this.oldName.method_12832();
        int dot = oldPath.lastIndexOf(46);
        int number = Integer.parseInt(oldPath.substring(dot + 1));
        String newPath = oldPath.substring(0, dot) + "." + (number + 1);
        return new class_2960(this.oldName.method_12836(), newPath);
    }

    private class_2960 makeNewAutogenerated() {
        String tweakedRecipeName = this.oldName.method_12836() + "." + this.oldName.method_12832() + ".1";
        return NameUtil.generateNameFrom(REPLACER_DISCRIMINATOR, tweakedRecipeName);
    }
}

