/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.block;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.block.BlockIngredient")
@Document(value="vanilla/api/block/BlockIngredient")
public abstract class CTBlockIngredient
implements CommandStringDisplayable {
    @Override
    public abstract String getCommandString();

    public abstract boolean matches(class_2248 var1);

    public abstract boolean matches(class_2248 var1, int var2);

    public abstract boolean matches(class_2680 var1);

    public abstract boolean matches(class_2680 var1, int var2);

    public abstract boolean matches(class_6862<class_2248> var1);

    public abstract boolean matches(class_6862<class_2248> var1, int var2);

    public abstract <T> T mapTo(Function<class_2248, T> var1, Function<class_2680, T> var2, BiFunction<class_6862<class_2248>, Integer, T> var3, Function<Stream<T>, T> var4);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public CTBlockIngredient asCompound(CTBlockIngredient other) {
        ArrayList<CTBlockIngredient> ingredients = new ArrayList<CTBlockIngredient>();
        if (other instanceof CompoundBlockIngredient) {
            ingredients.addAll(((CompoundBlockIngredient)other).elements);
        } else {
            ingredients.add(other);
        }
        if (this instanceof CompoundBlockIngredient) {
            ((CompoundBlockIngredient)this).elements.addAll(ingredients);
            return this;
        }
        ingredients.add(this);
        return new CompoundBlockIngredient(ingredients);
    }

    public static final class CompoundBlockIngredient
    extends CTBlockIngredient {
        final List<CTBlockIngredient> elements;

        public CompoundBlockIngredient(List<CTBlockIngredient> elements) {
            this.elements = elements;
        }

        @Override
        public String getCommandString() {
            return this.elements.stream().map(CTBlockIngredient::getCommandString).collect(Collectors.joining(" | "));
        }

        @Override
        public boolean matches(class_2248 block) {
            return this.elements.stream().anyMatch(ingredient -> ingredient.matches(block));
        }

        @Override
        public boolean matches(class_2248 block, int amount) {
            return this.elements.stream().anyMatch(ingredient -> ingredient.matches(block, amount));
        }

        @Override
        public boolean matches(class_2680 blockState) {
            return this.elements.stream().anyMatch(ingredient -> ingredient.matches(blockState));
        }

        @Override
        public boolean matches(class_2680 blockState, int amount) {
            return this.elements.stream().anyMatch(ingredient -> ingredient.matches(blockState, amount));
        }

        @Override
        public boolean matches(class_6862<class_2248> tag) {
            return this.elements.stream().anyMatch(ingredient -> ingredient.matches(tag));
        }

        @Override
        public boolean matches(class_6862<class_2248> tag, int amount) {
            return this.elements.stream().anyMatch(ingredient -> ingredient.matches(tag, amount));
        }

        @Override
        public <T> T mapTo(Function<class_2248, T> blockMapper, Function<class_2680, T> blockStateMapper, BiFunction<class_6862<class_2248>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            Stream<Object> stream = this.elements.stream().map(element -> element.mapTo(blockMapper, blockStateMapper, tagMapper, compoundMapper));
            return compoundMapper.apply(stream);
        }
    }

    public static final class BlockTagWithAmountIngredient
    extends CTBlockIngredient {
        final Many<KnownTag<class_2248>> tag;

        public BlockTagWithAmountIngredient(Many<KnownTag<class_2248>> tag) {
            this.tag = tag;
        }

        @Override
        public String getCommandString() {
            return this.tag.getCommandString();
        }

        @Override
        public boolean matches(class_2248 block) {
            return this.tag.getData().contains(block);
        }

        @Override
        public boolean matches(class_2248 block, int amount) {
            return this.tag.getData().contains(block) && this.tag.getAmount() <= amount;
        }

        @Override
        public boolean matches(class_2680 blockState) {
            return blockState.method_26164(this.tag.getData().getTagKey());
        }

        @Override
        public boolean matches(class_2680 blockState, int amount) {
            return blockState.method_26164(this.tag.getData().getTagKey()) && this.tag.getAmount() <= amount;
        }

        @Override
        public boolean matches(class_6862<class_2248> tag) {
            return this.tag.getData().getTagKey().equals(tag);
        }

        @Override
        public boolean matches(class_6862<class_2248> tag, int amount) {
            return this.tag.getData().getTagKey().equals(tag) && this.tag.getAmount() <= amount;
        }

        @Override
        public <T> T mapTo(Function<class_2248, T> blockMapper, Function<class_2680, T> blockStateMapper, BiFunction<class_6862<class_2248>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return tagMapper.apply((class_6862<class_2248>)this.tag.getData().getTagKey(), this.tag.getAmount());
        }
    }

    public static final class BlockStateIngredient
    extends CTBlockIngredient {
        final class_2680 blockState;

        public BlockStateIngredient(class_2680 blockState) {
            this.blockState = blockState;
        }

        @Override
        public String getCommandString() {
            return ExpandBlockState.getCommandString(this.blockState);
        }

        @Override
        public boolean matches(class_2248 block) {
            return this.blockState.method_26204() == block;
        }

        @Override
        public boolean matches(class_2248 block, int amount) {
            return this.matches(block);
        }

        @Override
        public boolean matches(class_2680 blockState) {
            return this.blockState == blockState;
        }

        @Override
        public boolean matches(class_2680 blockState, int amount) {
            return this.matches(blockState);
        }

        @Override
        public boolean matches(class_6862<class_2248> tag) {
            return this.blockState.method_26164(tag);
        }

        @Override
        public boolean matches(class_6862<class_2248> tag, int amount) {
            return this.matches(tag);
        }

        @Override
        public <T> T mapTo(Function<class_2248, T> blockMapper, Function<class_2680, T> blockStateMapper, BiFunction<class_6862<class_2248>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return blockStateMapper.apply(this.blockState);
        }
    }

    public static final class BlockIngredient
    extends CTBlockIngredient {
        final class_2248 block;

        public BlockIngredient(class_2248 block) {
            this.block = block;
        }

        @Override
        public String getCommandString() {
            return ExpandBlock.getCommandString(this.block);
        }

        @Override
        public boolean matches(class_2248 block) {
            return this.block == block;
        }

        @Override
        public boolean matches(class_2248 block, int amount) {
            return this.matches(block);
        }

        @Override
        public boolean matches(class_2680 blockState) {
            return this.block.method_9564() == blockState;
        }

        @Override
        public boolean matches(class_2680 blockState, int amount) {
            return this.matches(blockState);
        }

        @Override
        public boolean matches(class_6862<class_2248> tag) {
            return this.block.method_40142().method_40220(tag);
        }

        @Override
        public boolean matches(class_6862<class_2248> tag, int amount) {
            return this.matches(tag);
        }

        @Override
        public <T> T mapTo(Function<class_2248, T> blockMapper, Function<class_2680, T> blockStateMapper, BiFunction<class_6862<class_2248>, Integer, T> tagMapper, Function<Stream<T>, T> compoundMapper) {
            return blockMapper.apply(this.block);
        }
    }
}

