/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ListData")
@ZenRegister
@Document(value="vanilla/api/data/ListData")
public class ListData
implements IData {
    private final class_2499 internal;

    public ListData(class_2499 internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ListData() {
        this.internal = new class_2499();
    }

    @ZenCodeType.Constructor
    public ListData(List<IData> list) {
        this.internal = new class_2499();
        if (list != null) {
            list.forEach(iData -> this.getInternal().add((Object)iData.getInternal()));
        }
    }

    @ZenCodeType.Constructor
    public ListData(IData[] array) {
        this(Arrays.asList(array));
    }

    public class_2499 getInternal() {
        return this.internal;
    }

    @Override
    public IData add(IData other) {
        this.getInternal().add((Object)other.getInternal());
        return this;
    }

    @Override
    public void put(String index, IData value) {
        try {
            this.getInternal().method_10535(Integer.parseInt(index), value.getInternal());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Provided index: '%s' is not an Integer!".formatted(index));
        }
    }

    @Override
    public void remove(int index) {
        this.getInternal().method_10536(index);
    }

    @Override
    public IData getAt(int index) {
        return TagToDataConverter.convert(this.getInternal().method_10534(index));
    }

    @Override
    public boolean contains(IData other) {
        List<IData> dataValues;
        if (other.isListable() && (dataValues = other.asList()) != null && this.containsList(dataValues)) {
            return true;
        }
        for (class_2520 value : this.getInternal()) {
            if (!TagToDataConverter.convert(value).contains(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equalTo(IData other) {
        List<IData> values = this.asList();
        List<IData> others = other.asList();
        if (values.size() != others.size()) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i).equalTo(others.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IData> asList() {
        return this.getInternal().stream().map(TagToDataConverter::convert).toList();
    }

    @Override
    public boolean isListable() {
        return true;
    }

    @Override
    public byte[] asByteArray() {
        List<IData> values = this.asList();
        byte[] ret = new byte[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            ret[i] = values.get(i).asByte();
        }
        return ret;
    }

    @Override
    public int[] asIntArray() {
        List<IData> values = this.asList();
        int[] ret = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            ret[i] = values.get(i).asInt();
        }
        return ret;
    }

    @Override
    public long[] asLongArray() {
        List<IData> values = this.asList();
        long[] ret = new long[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            ret[i] = values.get(i).asLong();
        }
        return ret;
    }

    @Override
    public int length() {
        return this.asList().size();
    }

    @Override
    public Set<String> getKeys() {
        return IntStream.range(0, this.length()).mapToObj(String::valueOf).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Iterator<IData> iterator() {
        return this.asList().iterator();
    }

    @Override
    public IData copy() {
        return new ListData(this.getInternal());
    }

    @Override
    public IData copyInternal() {
        return new ListData(this.getInternal().method_10612());
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitList(this);
    }

    @Override
    public IData.Type getType() {
        return IData.Type.LIST;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListData iData = (ListData)o;
        return Objects.equals(this.getInternal(), iData.getInternal());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal());
    }

    public String toString() {
        return this.getAsString();
    }
}

