/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.serializer;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientTransformed;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public enum IngredientTransformedSerializer implements CustomIngredientSerializer<IngredientTransformed<?, ?>>
{
    INSTANCE;


    @NotNull
    public JsonObject write(IngredientTransformed<?, ?> ingredientVanillaPlus) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("base", ((IIngredientTransformed)ingredientVanillaPlus.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().method_8089());
        IIngredientTransformer<?> transformer = ingredientVanillaPlus.getTransformer();
        JsonObject value = transformer.toJson();
        if (!value.has("type")) {
            value.addProperty("type", transformer.getType().toString());
        }
        jsonObject.add("transformer", (JsonElement)value);
        return jsonObject;
    }

    public IngredientTransformed<?, ?> read(class_2540 buffer) {
        IIngredient base = IIngredient.fromIngredient(class_1856.method_8086((class_2540)buffer));
        class_2960 type = buffer.method_10810();
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.method_10223(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientTransformed(new IIngredientTransformed<IIngredient>(base, (IIngredientTransformer<IIngredient>)value.fromNetwork(buffer)));
    }

    public void write(JsonObject json, IngredientTransformed<?, ?> ingredient) {
        json.add("base", ((IIngredientTransformed)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient().method_8089());
        IIngredientTransformer<?> transformer = ingredient.getTransformer();
        JsonObject value = transformer.toJson();
        if (!value.has("type")) {
            value.addProperty("type", transformer.getType().toString());
        }
        json.add("transformer", (JsonElement)value);
    }

    public class_2960 getIdentifier() {
        return IIngredientTransformed.ID;
    }

    public IngredientTransformed<?, ?> read(JsonObject json) {
        JsonObject base = json.getAsJsonObject("base");
        IIngredient baseIngredient = IIngredient.fromIngredient(class_1856.method_52177((JsonElement)base));
        JsonObject transformer = json.getAsJsonObject("transformer");
        class_2960 type = new class_2960(transformer.get("type").getAsString());
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.method_10223(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return new IngredientTransformed(new IIngredientTransformed<IIngredient>(baseIngredient, (IIngredientTransformer<IIngredient>)value.fromJson(transformer)));
    }

    public void write(class_2540 buffer, IngredientTransformed<?, ?> ingredient) {
        class_1856 baseIngredient = ((IIngredientTransformed)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.method_8088(buffer);
        IIngredientTransformer<?> transformer = ingredient.getTransformer();
        IIngredientTransformerSerializer serializer = transformer.getSerializer();
        buffer.method_10812(serializer.getType());
        transformer.toNetwork(buffer);
    }
}

