/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.manager.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagAdd;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagClear;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagCreate;
import com.blamejared.crafttweaker.api.action.tag.unknown.ActionUnknownTagRemove;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.tag.MutableLoadResult;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.type.UnknownTag;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"crafttweaker", "tags"})
@Document(value="vanilla/api/tag/manager/type/UnknownTagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.manager.type.UnknownTagManager")
public class UnknownTagManager
implements ITagManager<UnknownTag> {
    private final class_5321<? extends class_2378<?>> resourceKey;
    private final MutableLoadResult<?> backingResult;
    private Map<class_2960, UnknownTag> tagCache;

    public UnknownTagManager(class_5321<? extends class_2378<?>> resourceKey) {
        this.resourceKey = resourceKey;
        this.backingResult = new MutableLoadResult();
        this.tagCache = new HashMap<class_2960, UnknownTag>();
    }

    @Override
    public class_5321<? extends class_2378<?>> resourceKey() {
        return this.resourceKey;
    }

    @Override
    @ZenCodeType.Method
    public final void addId(UnknownTag to, class_2960 ... values) {
        if (!this.exists(to)) {
            CraftTweakerAPI.apply(new ActionUnknownTagCreate(to));
        }
        CraftTweakerAPI.apply(new ActionUnknownTagAdd(to, List.of(values)));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public final void removeId(UnknownTag from, class_2960 ... values) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionUnknownTagRemove(from, List.of(values)));
        this.recalculate();
    }

    @Override
    public void clear(UnknownTag from) {
        if (!this.exists(from)) {
            throw new IllegalArgumentException("Cannot remove elements from empty tag: " + from);
        }
        CraftTweakerAPI.apply(new ActionUnknownTagClear(from));
        this.recalculate();
    }

    @Override
    @ZenCodeType.Method
    public UnknownTag tag(String id) {
        return this.tag(new class_2960(id));
    }

    @Override
    @ZenCodeType.Method
    public UnknownTag tag(class_2960 id) {
        return this.tagMap().getOrDefault(id, new UnknownTag(id, this));
    }

    @Override
    public void recalculate() {
        this.tagCache = this.backingResult.tagMap().keySet().stream().map(id -> Pair.of((Object)id, (Object)new UnknownTag((class_2960)id, this))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagMap")
    public Map<class_2960, UnknownTag> tagMap() {
        if (this.tagCache.isEmpty()) {
            this.recalculate();
        }
        return this.tagCache;
    }

    @Override
    public Map<class_2960, Collection<class_6880<?>>> internalTags() {
        return (Map)GenericUtil.uncheck(Collections.unmodifiableMap(this.backingResult.tagMap()));
    }

    @Override
    @Nullable
    public Collection<class_6880<?>> getInternalRaw(UnknownTag tag) {
        return (Collection)GenericUtil.uncheck(this.backingResult.tagMap().get(tag.id()));
    }

    @Override
    public List<class_2960> tagKeys() {
        return new ArrayList<class_2960>(this.tagMap().keySet());
    }

    @Override
    public <U> void addTag(class_2960 id, Collection<class_6880<U>> tag) {
        this.backingResult.addTag(id, (Collection)GenericUtil.uncheck(tag));
        this.recalculate();
    }

    @Override
    public void bind(class_3505.class_6863<?> result) {
        this.backingResult.bind((class_3505.class_6863)GenericUtil.uncheck(result));
    }
}

