/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7923;

public final class ItemStackUtil {
    public static String getCommandString(class_1799 stack) {
        return ItemStackUtil.getCommandString(stack, false);
    }

    public static String getCommandString(class_1799 stack, boolean mutable) {
        StringBuilder sb = new StringBuilder("<item:").append(class_7923.field_41178.method_10221((Object)stack.method_7909())).append('>');
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            IData data = Objects.requireNonNull(TagToDataConverter.convert((class_2520)tag)).copyInternal();
            if (stack.method_7909().method_7846()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(").append(data.asString()).append(')');
            }
        }
        if (stack.method_7919() > 0) {
            sb.append(".withDamage(").append(stack.method_7919()).append(')');
        }
        if (!stack.method_7960() && stack.method_7947() != 1) {
            sb.append(" * ").append(stack.method_7947());
        }
        if (mutable) {
            sb.insert(0, '(').append(").mutable()");
        }
        return sb.toString();
    }

    public static boolean areStacksTheSame(class_1799 first, class_1799 second) {
        return ItemStackUtil.areStacksTheSame(first, second, false);
    }

    public static boolean areStacksTheSame(class_1799 first, class_1799 second, boolean ignoreDamage) {
        return ItemStackUtil.areStacksTheSame(first, second, ignoreDamage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areStacksTheSame(class_1799 first, class_1799 second, boolean ignoreDamage, boolean partial) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.method_7960() != second.method_7960()) {
            return false;
        }
        if (first.method_7909() != second.method_7909()) {
            return false;
        }
        if (first.method_7947() > second.method_7947()) {
            return false;
        }
        if (!ignoreDamage && first.method_7919() != second.method_7919()) {
            return false;
        }
        class_2487 firstTag = first.method_7969();
        class_2487 secondTag = second.method_7969();
        if (firstTag == null) {
            return true;
        }
        if (secondTag == null) {
            return false;
        }
        class_2520 firstDamage = firstTag.method_10580("Damage");
        class_2520 secondDamage = secondTag.method_10580("Damage");
        try {
            if (ignoreDamage) {
                firstTag.method_10551("Damage");
                secondTag.method_10551("Damage");
            }
            if (!partial) {
                boolean bl = firstTag.equals((Object)secondTag);
                return bl;
            }
            boolean bl = ItemStackUtil.areStackTagsPartiallyEqual(firstTag, secondTag);
            return bl;
        }
        finally {
            if (firstDamage != null) {
                firstTag.method_10566("Damage", firstDamage);
            }
            if (secondDamage != null) {
                secondTag.method_10566("Damage", secondDamage);
            }
        }
    }

    private static boolean areStackTagsPartiallyEqual(class_2487 partial, class_2487 actual) {
        if (partial == actual) {
            return true;
        }
        if (partial == null || actual == null) {
            return false;
        }
        IData partialData = TagToDataConverter.convert((class_2520)partial);
        IData actualData = TagToDataConverter.convert((class_2520)actual);
        assert (partialData != null && actualData != null);
        return actualData.contains(partialData);
    }
}

