/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.natives.entity.equipment.ExpandEquipmentSlot;
import com.blamejared.crafttweaker.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.util.TriConsumer;

public final class HandCommands {
    private HandCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("hand", class_2561.method_43471((String)"crafttweaker.command.description.hand"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1799 stack = player.method_6047();
            class_1792 item = stack.method_7909();
            HandCommands.sendBasicItemInformation((class_1657)player, stack);
            if (item instanceof class_1747) {
                HandCommands.sendBlockInformation((class_1657)player, (class_1747)stack.method_7909());
            }
            if (item instanceof class_1755 && Services.PLATFORM.getBucketContent((class_1755)item) != class_3612.field_15906) {
                HandCommands.sendBucketInformation((class_1657)player, (class_1755)stack.method_7909());
            }
            for (class_5250 component : Services.PLATFORM.getFluidsForDump(stack, (class_1657)player, class_1268.field_5808)) {
                HandCommands.sendHand((class_1657)player, class_2561.method_43471((String)"crafttweaker.command.misc.fluid"), component.getString());
            }
            HandCommands.sendTagsInformation((class_1657)player, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "registry_name", class_2561.method_43471((String)"crafttweaker.command.description.hand.registryname"), builder -> builder.executes(context -> {
            class_1799 mainHandItem = ((class_2168)context.getSource()).method_9207().method_6047();
            HandCommands.sendCopyingHand((class_1657)((class_2168)context.getSource()).method_9207(), class_2561.method_43471((String)"crafttweaker.command.misc.item"), class_7923.field_41178.method_10221((Object)mainHandItem.method_7909()).toString());
            return 1;
        }));
        handler.registerSubCommand("hand", "data", class_2561.method_43471((String)"crafttweaker.command.description.hand.data"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1799 stack = player.method_6047();
            if (!stack.method_7985()) {
                CommandUtilities.send((class_2561)class_2561.method_43471((String)"crafttweaker.command.hand.no.data"), (class_1657)player);
                return 0;
            }
            HandCommands.sendCopyingHand((class_1657)player, class_2561.method_43471((String)"crafttweaker.command.misc.data"), new MapData(stack.method_7969()).accept(new DataToTextComponentVisitor(" ", 0)).getString());
            return 1;
        }));
        handler.registerSubCommand("hand", "tags", class_2561.method_43471((String)"crafttweaker.command.description.hand.tags"), builder -> builder.executes(context -> {
            class_1799 stack;
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            Collection<String> tags = HandCommands.sendTagsInformation((class_1657)player, (stack = player.method_6047()).method_7909());
            if (tags.isEmpty()) {
                CommandUtilities.send((class_2561)class_2561.method_43471((String)"crafttweaker.command.hand.no.tags"), (class_1657)player);
                return 1;
            }
            tags.stream().findFirst().ifPresent(it -> CommandUtilities.copy((class_1657)player, it));
            return 1;
        }));
        handler.registerSubCommand("hand", "vanilla", class_2561.method_43471((String)"crafttweaker.command.description.hand.vanilla"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1799 stack = player.method_6047();
            class_1792 item = stack.method_7909();
            HandCommands.sendBasicVanillaItemInformation((class_1657)player, stack);
            if (stack.method_7985()) {
                HandCommands.sendVanillaDataInformation((class_1657)player, (class_2520)Objects.requireNonNull(stack.method_7969()));
            }
            if (item instanceof class_1755 && Services.PLATFORM.getBucketContent((class_1755)item) != class_3612.field_15906) {
                HandCommands.sendVanillaBucketInformation((class_1657)player, (class_1755)stack.method_7909());
            }
            HandCommands.sendVanillaTagsInformation((class_1657)player, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "attributes", class_2561.method_43471((String)"crafttweaker.command.description.hand.attributes"), builder -> builder.executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1799 stack = player.method_6047();
            for (class_1304 slot : class_1304.values()) {
                Map modifiers = stack.method_7926(slot).asMap();
                if (modifiers.isEmpty()) continue;
                String equipmentCS = ExpandEquipmentSlot.getCommandString(slot);
                CommandUtilities.sendCopying(class_2561.method_43471((String)"crafttweaker.command.hand.header.attributes").method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)equipmentCS).method_27692(class_124.field_1060)).method_27692(class_124.field_1062), equipmentCS, (class_1657)player);
                modifiers.forEach((attribute, attributeModifiers) -> {
                    String attributeCS = ExpandAttribute.getCommandString(attribute);
                    CommandUtilities.sendCopying(class_2561.method_43470((String)"- ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)attributeCS).method_27692(class_124.field_1060)), attributeCS, (class_1657)player);
                    attributeModifiers.forEach(attributeModifier -> {
                        HandCommands.sendAttributePropertyInformation((class_1657)player, "Name", attributeModifier.method_6185());
                        HandCommands.sendAttributePropertyInformation((class_1657)player, "ID", attributeModifier.method_6189().toString());
                        HandCommands.sendAttributePropertyInformation((class_1657)player, "Operation", attributeModifier.method_6182().name());
                        HandCommands.sendAttributePropertyInformation((class_1657)player, "Amount", String.valueOf(attributeModifier.method_6186()));
                        HandCommands.sendAttributePropertyInformation((class_1657)player, "IData", new MapData(attributeModifier.method_26860()).asString());
                    });
                });
            }
            HandCommands.sendCopyingHand((class_1657)player, class_2561.method_43471((String)"crafttweaker.command.misc.item"), class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
            return 1;
        }));
    }

    private static void sendBasicItemInformation(class_1657 player, class_1799 target) {
        String output = ItemStackUtil.getCommandString(target);
        HandCommands.sendCopyingHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.item"), output);
    }

    private static void sendBlockInformation(class_1657 player, class_1747 target) {
        HandCommands.sendBlockInformation(player, target.method_7711());
    }

    private static void sendBlockInformation(class_1657 player, class_2248 target) {
        HandCommands.sendHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.block"), ExpandBlock.getCommandString(target));
        HandCommands.sendHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.blockstate"), ExpandBlockState.getCommandString(target.method_9564()));
    }

    private static void sendBucketInformation(class_1657 player, class_1755 target) {
        if (Services.PLATFORM.getBucketContent(target) == class_3612.field_15906) {
            return;
        }
        HandCommands.sendHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.fluidblockstate"), ExpandBlockState.getCommandString(Services.PLATFORM.getBucketContent(target).method_15785().method_15759()));
    }

    private static Collection<String> sendTagsInformation(class_1657 player, class_1792 item) {
        ArrayList<String> tags = new ArrayList<String>(HandCommands.sendItemTagsInformation(player, item));
        if (item instanceof class_1747) {
            tags.addAll(HandCommands.sendBlockTagsInformation(player, (class_1747)item));
        }
        return tags;
    }

    private static Collection<String> sendItemTagsInformation(class_1657 player, class_1792 item) {
        return HandCommands.sendTagsInformation(player, class_2561.method_43471((String)"crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(class_7924.field_41197), item);
    }

    private static Collection<String> sendBlockTagsInformation(class_1657 player, class_1747 item) {
        return HandCommands.sendTagsInformation(player, class_2561.method_43471((String)"crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(class_7924.field_41254), item.method_7711());
    }

    private static <T> Collection<String> sendTagsInformation(class_1657 player, class_5250 header, KnownTagManager<?> manager, T target) {
        class_6880<T> tHolder = Services.REGISTRY.makeHolder(manager.resourceKey(), target);
        if (tHolder.method_40228().findAny().isEmpty()) {
            return List.of();
        }
        CommandUtilities.send((class_2561)header.method_27692(class_124.field_1062), player);
        return tHolder.method_40228().map(tTagKey -> new KnownTag(tTagKey.comp_327(), manager)).map(MCTag::getCommandString).peek(it -> HandCommands.sendTagHand(player, it)).toList();
    }

    private static void sendBasicVanillaItemInformation(class_1657 player, class_1799 target) {
        String output = Objects.requireNonNull(class_7923.field_41178.method_10221((Object)target.method_7909())).toString();
        HandCommands.sendCopyingHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.item"), output);
    }

    private static void sendVanillaDataInformation(class_1657 player, class_2520 nbt) {
        HandCommands.sendHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.data"), nbt.toString());
    }

    private static void sendVanillaBucketInformation(class_1657 player, class_1755 target) {
        if (Services.PLATFORM.getBucketContent(target) == class_3612.field_15906) {
            return;
        }
        HandCommands.sendHand(player, class_2561.method_43471((String)"crafttweaker.command.misc.fluidblockstate"), class_7923.field_41173.method_10221((Object)Services.PLATFORM.getBucketContent(target)).toString());
    }

    private static void sendVanillaTagsInformation(class_1657 player, class_1792 item) {
        HandCommands.sendVanillaItemTagsInformation(player, item);
        if (item instanceof class_1747) {
            HandCommands.sendVanillaBlockTagsInformation(player, (class_1747)item);
        }
    }

    private static void sendVanillaItemTagsInformation(class_1657 player, class_1792 item) {
        HandCommands.sendVanillaTagsInformation(player, class_2561.method_43471((String)"crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.tagManager(class_7924.field_41197), item);
    }

    private static void sendVanillaBlockTagsInformation(class_1657 player, class_1747 item) {
        HandCommands.sendVanillaTagsInformation(player, class_2561.method_43471((String)"crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.tagManager(class_7924.field_41254), item.method_7711());
    }

    private static <T> void sendVanillaTagsInformation(class_1657 player, class_5250 header, ITagManager<?> manager, T target) {
        class_6880<T> tHolder = Services.REGISTRY.makeHolder(manager.resourceKey(), target);
        if (tHolder.method_40228().findAny().isEmpty()) {
            return;
        }
        CommandUtilities.send((class_2561)header.method_27692(class_124.field_1062), player);
        tHolder.method_40228().map(tTagKey -> "#" + tTagKey.comp_327()).forEach(it -> HandCommands.sendTagHand(player, it));
    }

    private static void sendAttributePropertyInformation(class_1657 player, String propertyName, String value) {
        CommandUtilities.sendCopying(class_2561.method_43470((String)"    - ").method_27693(propertyName).method_27693(": ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)value).method_27692(class_124.field_1075)), value, player);
    }

    private static void sendHand(class_1657 receiver, class_5250 messagePrefix, String target) {
        HandCommands.sendHand(receiver, messagePrefix, target, (TriConsumer<class_5250, String, class_1657>)((TriConsumer)CommandUtilities::sendCopying));
    }

    private static void sendCopyingHand(class_1657 receiver, class_5250 messagePrefix, String target) {
        HandCommands.sendHand(receiver, messagePrefix, target, (TriConsumer<class_5250, String, class_1657>)((TriConsumer)CommandUtilities::sendCopyingAndCopy));
    }

    private static void sendHand(class_1657 receiver, class_5250 messagePrefix, String target, TriConsumer<class_5250, String, class_1657> consumer) {
        consumer.accept((Object)messagePrefix.method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)target).method_27692(class_124.field_1060)), (Object)target, (Object)receiver);
    }

    private static void sendTagHand(class_1657 receiver, String tag) {
        CommandUtilities.sendCopying(class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1054)).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)tag).method_27692(class_124.field_1075)), tag, receiver);
    }
}

