/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.core;

import com.blamejared.crafttweaker.api.plugin.ILoaderRegistrationHandler;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.impl.plugin.core.LoaderData;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LoaderRegistrationHandler
implements ILoaderRegistrationHandler {
    private final Map<String, LoaderRequest> requests = new HashMap<String, LoaderRequest>();

    private LoaderRegistrationHandler() {
    }

    static Map<String, IScriptLoader> gather(Consumer<ILoaderRegistrationHandler> populatingConsumer) {
        LoaderRegistrationHandler handler = new LoaderRegistrationHandler();
        handler.requests.put("*", new LoaderRequest("*", Collections.emptySet()));
        populatingConsumer.accept(handler);
        return handler.build();
    }

    @Override
    public void registerLoader(String name, String ... inheritedLoaders) {
        if (this.requests.containsKey(name)) {
            throw new IllegalArgumentException("Loader '" + name + "' was already registered");
        }
        Stream<String> loaders = Stream.concat(Stream.of("*"), Arrays.stream(inheritedLoaders));
        this.requests.put(name, new LoaderRequest(name, loaders.collect(Collectors.toUnmodifiableSet())));
    }

    Map<String, IScriptLoader> build() {
        HashMap<String, LoaderRequest> unsatisfiedRequests = new HashMap<String, LoaderRequest>(this.requests);
        HashMap<String, IScriptLoader> loaders = new HashMap<String, IScriptLoader>();
        while (!unsatisfiedRequests.isEmpty()) {
            Map<String, LoaderRequest> satisfiableRequests = this.findValidRequests(unsatisfiedRequests, loaders.keySet());
            if (satisfiableRequests.isEmpty()) {
                throw new IllegalStateException("Unable to create all loaders due to unsatisfied dependency linkage: " + unsatisfiedRequests);
            }
            this.satisfyRequests(satisfiableRequests, loaders);
            satisfiableRequests.keySet().forEach(unsatisfiedRequests::remove);
        }
        return ImmutableMap.copyOf(loaders);
    }

    private Map<String, LoaderRequest> findValidRequests(Map<String, LoaderRequest> requests, Set<String> availableIds) {
        return requests.entrySet().stream().filter(it -> availableIds.containsAll(((LoaderRequest)it.getValue()).inheritedLoaders())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void satisfyRequests(Map<String, LoaderRequest> requests, Map<String, IScriptLoader> output) {
        requests.forEach((id, request) -> {
            List<IScriptLoader> inherited = request.inheritedLoaders().stream().map(output::get).toList();
            LoaderData loader = new LoaderData((String)id, (Collection<IScriptLoader>)inherited);
            output.put((String)id, loader);
        });
    }

    private record LoaderRequest(String name, Set<String> inheritedLoaders) {
    }
}

