/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.helper;

import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTransformRecipe;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTrimRecipe;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_8059;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.jetbrains.annotations.Nullable;

public final class SmithingRecipeConflictChecker {
    public static boolean doesConflict(IRecipeManager<?> manager, class_8059 first, class_8059 second) {
        BasicRecipe firstRecipe = BasicRecipe.from(first);
        BasicRecipe secondRecipe = BasicRecipe.from(second);
        if (firstRecipe == null || secondRecipe == null) {
            return SmithingRecipeConflictChecker.redirect((IRecipeManager)GenericUtil.uncheck(manager), second, first);
        }
        return IngredientUtil.canConflict(firstRecipe.template(), secondRecipe.template()) && IngredientUtil.canConflict(firstRecipe.base(), secondRecipe.base()) && IngredientUtil.canConflict(firstRecipe.addition(), secondRecipe.addition());
    }

    private static <T extends class_1860<?>> boolean redirect(IRecipeManager<?> manager, T second, class_1860<?> first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), second, first);
    }

    record BasicRecipe(class_1856 template, class_1856 base, class_1856 addition) {
        @Nullable
        static BasicRecipe from(class_8059 recipe) {
            if (recipe instanceof class_8062) {
                class_8062 trim = (class_8062)recipe;
                return BasicRecipe.from(trim);
            }
            if (recipe instanceof class_8060) {
                class_8060 transform = (class_8060)recipe;
                return BasicRecipe.from(transform);
            }
            return null;
        }

        static BasicRecipe from(class_8062 recipe) {
            AccessSmithingTrimRecipe access = (AccessSmithingTrimRecipe)recipe;
            return new BasicRecipe(access.crafttweaker$getTemplate(), access.crafttweaker$getBase(), access.crafttweaker$getAddition());
        }

        static BasicRecipe from(class_8060 recipe) {
            AccessSmithingTransformRecipe access = (AccessSmithingTransformRecipe)recipe;
            return new BasicRecipe(access.crafttweaker$getTemplate(), access.crafttweaker$getBase(), access.crafttweaker$getAddition());
        }
    }
}

