/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.recipe;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class RecipeHandlerRegistry
implements IRecipeHandlerRegistry {
    private final Map<Class<? extends class_1860<?>>, IRecipeHandler<?>> recipeHandlers = new HashMap();

    public <T extends class_1860<?>> void register(Class<? extends T> clazz, IRecipeHandler<T> handler) {
        this.recipeHandlers.put(clazz, handler);
    }

    @Override
    public <T extends class_1860<?>> IRecipeHandler<T> getRecipeHandlerFor(T recipe) {
        return this.getRecipeHandlerFor(recipe.getClass());
    }

    @Override
    public <T extends class_1860<?>> IRecipeHandler<T> getRecipeHandlerFor(Class<T> recipeClass) {
        return this.getRecipeHandlerForClass(recipeClass).orElse(DefaultRecipeHandler.INSTANCE);
    }

    private Optional<IRecipeHandler<?>> getRecipeHandlerForClass(Class<?> recipeClass) {
        ArrayDeque classes = new ArrayDeque();
        classes.offer(recipeClass);
        while (!classes.isEmpty()) {
            Class target = (Class)classes.poll();
            if (target == class_1860.class) continue;
            IRecipeHandler<?> attempt = this.recipeHandlers.get(target);
            if (attempt != null) {
                return Optional.of(attempt);
            }
            if (target.getSuperclass() != null) {
                classes.offer(target.getSuperclass());
            }
            Arrays.stream(target.getInterfaces()).forEach(classes::offer);
        }
        return Optional.empty();
    }

    private static final class DefaultRecipeHandler
    implements IRecipeHandler<class_1860<?>> {
        private static final DefaultRecipeHandler INSTANCE = new DefaultRecipeHandler();

        private DefaultRecipeHandler() {
        }

        @Override
        public String dumpToCommandString(IRecipeManager<? super class_1860<?>> manager, class_1860<?> recipe) {
            String ingredients = recipe.method_8117().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", "));
            Object[] objectArray = new Object[5];
            objectArray[0] = recipe.method_8114();
            objectArray[1] = ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> recipe.method_8110(arg_0)));
            objectArray[2] = ingredients;
            objectArray[3] = recipe.getClass().getName();
            objectArray[4] = class_7923.field_41189.method_10221((Object)recipe.method_8119());
            return String.format("~~ Recipe name: %s, Outputs: %s, Inputs: [%s], Recipe Class: %s, Recipe Serializer: %s ~~", objectArray);
        }

        @Override
        public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_1860<?>> manager, class_1860<?> firstRecipe, U secondRecipe) {
            return false;
        }

        @Override
        public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_1860<?>> manager, class_1860<?> recipe) {
            return Optional.empty();
        }

        @Override
        public Optional<class_1860<?>> recompose(IRecipeManager<? super class_1860<?>> manager, class_2960 name, IDecomposedRecipe recipe) {
            return Optional.empty();
        }
    }
}

