/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.type;

import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.parser.type.IParsedType;

public class ParsedNamedType
implements IParsedType {
    public final List<ParsedNamePart> name;
    private final CodePosition position;

    public ParsedNamedType(CodePosition position, List<ParsedNamePart> name) {
        this.position = position;
        this.name = name;
    }

    @Override
    public TypeID compile(TypeResolutionContext context) {
        if (this.name.size() == 1 && this.name.get((int)0).name.equals("Iterator")) {
            return this.toIterator(context);
        }
        ArrayList<GenericName> genericNames = new ArrayList<GenericName>();
        for (ParsedNamePart namePart : this.name) {
            genericNames.add(namePart.compile(context));
        }
        TypeID result = context.getType(this.position, genericNames);
        if (result == null) {
            return new InvalidTypeID(this.position, CompileExceptionCode.NO_SUCH_TYPE, "Type not found: " + this.toString());
        }
        return result;
    }

    public String toString() {
        StringBuilder nameTotal = new StringBuilder();
        for (int i = 0; i < this.name.size(); ++i) {
            if (i > 0) {
                nameTotal.append(".");
            }
            nameTotal.append(this.name.get(i).toString());
        }
        return nameTotal.toString();
    }

    @Override
    public AnnotationDefinition compileAnnotation(BaseScope scope) {
        if (this.name.size() != 1) {
            return null;
        }
        return scope.getAnnotation(this.name.get((int)0).name);
    }

    @Override
    public TypeID[] compileTypeArguments(BaseScope scope) {
        ParsedNamePart last = this.name.get(this.name.size() - 1);
        return IParsedType.compileTypes(last.typeArguments, scope);
    }

    private TypeID toIterator(TypeResolutionContext context) {
        List<IParsedType> genericTypes = this.name.get((int)0).typeArguments;
        TypeID[] iteratorTypes = new TypeID[genericTypes.size()];
        for (int i = 0; i < genericTypes.size(); ++i) {
            iteratorTypes[i] = genericTypes.get(i).compile(context);
        }
        return context.getTypeRegistry().getIterator(iteratorTypes);
    }

    public static class ParsedNamePart {
        public final String name;
        public final List<IParsedType> typeArguments;

        public ParsedNamePart(String name, List<IParsedType> genericArguments) {
            this.name = name;
            this.typeArguments = genericArguments;
        }

        private GenericName compile(TypeResolutionContext context) {
            return new GenericName(this.name, IParsedType.compileTypes(this.typeArguments, context));
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.name);
            if (this.typeArguments != null) {
                result.append("<");
                for (int i = 0; i < this.typeArguments.size(); ++i) {
                    if (i > 0) {
                        result.append(", ");
                    }
                    result.append(this.typeArguments.get(i).toString());
                }
                result.append(">");
            }
            return result.toString();
        }
    }
}

