/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.init;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.entity.IceologerEntity;
import com.faboslav.friendsandfoes.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.entity.MaulerEntity;
import com.faboslav.friendsandfoes.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.entity.RascalEntity;
import com.faboslav.friendsandfoes.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.entity.WildfireEntity;
import com.faboslav.friendsandfoes.mixin.SpawnRestrictionAccessor;
import com.faboslav.friendsandfoes.platform.BiomeModifications;
import com.faboslav.friendsandfoes.platform.CustomSpawnGroup;
import com.faboslav.friendsandfoes.platform.RegistryHelper;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1430;
import net.minecraft.class_155;
import net.minecraft.class_2902;
import net.minecraft.class_3732;

public final class FriendsAndFoesEntityTypes {
    public static boolean previousUseChoiceTypeRegistrations = class_155.field_25135;
    public static final Supplier<class_1299<CopperGolemEntity>> COPPER_GOLEM;
    public static final Supplier<class_1299<GlareEntity>> GLARE;
    public static final Supplier<class_1299<IceologerEntity>> ICEOLOGER;
    public static final Supplier<class_1299<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final Supplier<class_1299<MaulerEntity>> MAULER;
    public static final Supplier<class_1299<MoobloomEntity>> MOOBLOOM;
    public static final Supplier<class_1299<RascalEntity>> RASCAL;
    public static final Supplier<class_1299<TuffGolemEntity>> TUFF_GOLEM;
    public static final Supplier<class_1299<WildfireEntity>> WILDFIRE;
    public static final Supplier<class_1299<PlayerIllusionEntity>> PLAYER_ILLUSION;

    public static void init() {
        FriendsAndFoesEntityTypes.createMobAttributes();
    }

    public static void postInit() {
        FriendsAndFoesEntityTypes.initSpawnRestrictions();
        FriendsAndFoesEntityTypes.addSpawns();
    }

    public static void createMobAttributes() {
        RegistryHelper.registerEntityAttribute(COPPER_GOLEM, CopperGolemEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(GLARE, GlareEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(ICEOLOGER, IceologerEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(MAULER, MaulerEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(MOOBLOOM, class_1430::method_26883);
        RegistryHelper.registerEntityAttribute(RASCAL, RascalEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(TUFF_GOLEM, TuffGolemEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(WILDFIRE, WildfireEntity::createAttributes);
        RegistryHelper.registerEntityAttribute(PLAYER_ILLUSION, class_1308::method_26828);
    }

    public static void initSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister(GLARE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, GlareEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(ICEOLOGER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        SpawnRestrictionAccessor.callRegister(MAULER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MaulerEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(MOOBLOOM.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MoobloomEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(RASCAL.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, RascalEntity::canSpawn);
    }

    public static void addSpawns() {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableGlare && config.enableGlareSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_GLARE, GLARE.get(), CustomSpawnGroup.getGlaresCategory(), config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_BADLANDS_MAULER, MAULER.get(), class_1311.field_6294, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_DESERT_MAULER, MAULER.get(), class_1311.field_6294, config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_SAVANNA_MAULER, MAULER.get(), class_1311.field_6294, config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_MOOBLOOMS, MOOBLOOM.get(), class_1311.field_6294, config.moobloomSpawnWeight, config.moobloomSpawnMinGroupSize, config.moobloomSpawnMaxGroupSize);
        }
        if (config.enableRascal && config.enableRascalSpawn) {
            BiomeModifications.addMobSpawn(FriendsAndFoesTags.HAS_RASCAL, RASCAL.get(), CustomSpawnGroup.getRascalsCategory(), 4, 1, 1);
        }
    }

    private FriendsAndFoesEntityTypes() {
    }

    static {
        class_155.field_25135 = false;
        COPPER_GOLEM = RegistryHelper.registerEntityType("copper_golem", () -> class_1299.class_1300.method_5903(CopperGolemEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 1.375f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("copper_golem")));
        GLARE = RegistryHelper.registerEntityType("glare", () -> class_1299.class_1300.method_5903(GlareEntity::new, (class_1311)CustomSpawnGroup.getGlaresCategory()).method_17687(0.875f, 1.1875f).method_27299(8).method_27300(2).method_5905(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = RegistryHelper.registerEntityType("iceologer", () -> class_1299.class_1300.method_5903(IceologerEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.95f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = RegistryHelper.registerEntityType("ice_chunk", () -> class_1299.class_1300.method_5903(IceologerIceChunkEntity::new, (class_1311)class_1311.field_17715).method_19947().method_17687(2.5f, 1.0f).method_27299(6).method_5905(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = RegistryHelper.registerEntityType("mauler", () -> class_1299.class_1300.method_5903(MaulerEntity::new, (class_1311)class_1311.field_6294).method_17687(0.5625f, 0.5625f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = RegistryHelper.registerEntityType("moobloom", () -> class_1299.class_1300.method_5903(MoobloomEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.4f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("moobloom")));
        RASCAL = RegistryHelper.registerEntityType("rascal", () -> class_1299.class_1300.method_5903(RascalEntity::new, (class_1311)CustomSpawnGroup.getRascalsCategory()).method_17687(0.9f, 1.25f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("rascal")));
        TUFF_GOLEM = RegistryHelper.registerEntityType("tuff_golem", () -> class_1299.class_1300.method_5903(TuffGolemEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 1.0625f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("tuff_golem")));
        WILDFIRE = RegistryHelper.registerEntityType("wildfire", () -> class_1299.class_1300.method_5903(WildfireEntity::new, (class_1311)class_1311.field_6302).method_17687(1.12f, 3.0f).method_27299(10).method_19947().method_5905(FriendsAndFoes.makeStringID("wildfire")));
        PLAYER_ILLUSION = RegistryHelper.registerEntityType("player_illusion", () -> class_1299.class_1300.method_5903(PlayerIllusionEntity::new, (class_1311)class_1311.field_17715).method_17687(0.7f, 1.875f).method_27299(10).method_19947().method_5905(FriendsAndFoes.makeStringID("player_illusion")));
        class_155.field_25135 = previousUseChoiceTypeRegistrations;
    }
}

