/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.function;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.mixin.accessors.world.AccessorRecipeManager;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;

public class ReloadableCache<T>
implements Function<class_1937, T> {
    private final Function<class_1937, T> delegate;
    private WeakReference<class_1863> recipeManager = new WeakReference<Object>(null);
    private boolean cached = false;
    @Nullable
    private T cachedValue;

    protected ReloadableCache(Function<class_1937, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public T apply(class_1937 level) {
        if (!this.isCached() || this.hasGameReloaded(level)) {
            this.recipeManager = new WeakReference<class_1863>(level.method_8433());
            this.cachedValue = this.delegate.apply(level);
            this.cached = true;
        }
        return this.cachedValue;
    }

    public void invalidate() {
        this.cached = false;
        this.cachedValue = null;
        this.recipeManager = new WeakReference<Object>(null);
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean hasGameReloaded(class_1937 level) {
        return this.recipeManager.get() != level.method_8433();
    }

    public void apply(class_1937 level, Consumer<T> consumer) {
        consumer.accept(this.apply(level));
    }

    public static <T> ReloadableCache<T> of(Supplier<T> supplier) {
        return new ReloadableCache<Object>(level -> supplier.get());
    }

    public static <T> ReloadableCache<T> of(Function<class_1937, T> delegate) {
        return new ReloadableCache<T>(delegate);
    }

    public static <T> ReloadableCache<T> of(class_5321<? extends class_2378<T>> registry, class_2960 id) {
        return ReloadableCache.of((class_1937 level) -> level.method_30349().method_30530(registry).method_10223(id));
    }

    public static <T> ReloadableCache<T> of(class_3956<? extends class_1860<?>> type, class_2960 id) {
        return ReloadableCache.of((class_1937 level) -> {
            class_1863 patt5416$temp = level.method_8433();
            if (patt5416$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt5416$temp;
                return accessor.bookshelf$getTypeMap(type).get(id);
            }
            return null;
        });
    }
}

