/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.registry.IRegistryObject;
import net.minecraft.class_2960;

public interface IRegistryEntries<V>
extends Iterable<V> {
    public <VT extends V> IRegistryObject<VT> add(Supplier<VT> var1, class_2960 var2);

    public Map<class_2960, V> getEntries();

    public boolean isEmpty();

    public void addInsertListener(BiConsumer<class_2960, IRegistryObject<? extends V>> var1);

    public void addRegistryListener(BiConsumer<class_2960, V> var1);

    public void addRegistryWrapper(BiFunction<class_2960, V, V> var1);

    public void build(BiConsumer<class_2960, V> var1);

    @Nullable
    default public V getEntry(class_2960 id) {
        return this.getEntries().get(id);
    }

    @Nullable
    default public V getOrDefault(class_2960 key, V fallback) {
        return (V)this.getOrDefault(key, () -> fallback);
    }

    @Nullable
    default public V getOrDefault(class_2960 key, Supplier<V> fallback) {
        V value = this.getEntries().get(key);
        return value != null || this.getEntries().containsKey(key) ? value : fallback.get();
    }

    default public void ifPresent(class_2960 key, BiConsumer<class_2960, V> consumer) {
        V value = this.getEntries().get(key);
        if (value != null || this.getEntries().containsKey(key)) {
            consumer.accept(key, value);
        }
    }

    default public void ifAbsent(class_2960 key, Consumer<class_2960> consumer) {
        if (!this.getEntries().containsKey(key)) {
            consumer.accept(key);
        }
    }
}

