/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.config;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.entity.LootrChestMinecartEntity;
import net.zestyblaze.lootr.registry.LootrBlockInit;
import net.zestyblaze.lootr.tags.LootrTags;

@Config(name="lootr")
public class LootrModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static Set<String> DECAY_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_2960> DECAY_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> REFRESH_MODS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_2960> REFRESH_TABLES = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DIM_WHITELIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DIM_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> DECAY_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_5321<class_1937>> REFRESH_DIMS = null;
    @ConfigEntry.Gui.Excluded
    private static Set<class_2960> LOOT_BLACKLIST = null;
    @ConfigEntry.Gui.Excluded
    private static Map<class_2248, class_2248> replacements = null;
    @ConfigEntry.Gui.Excluded
    private static Set<String> LOOT_MODIDS = null;
    @ConfigEntry.Gui.CollapsibleObject
    public Debug debug = new Debug();
    @ConfigEntry.Gui.CollapsibleObject
    public Seed seed = new Seed();
    @ConfigEntry.Gui.CollapsibleObject
    public Conversion conversion = new Conversion();
    @ConfigEntry.Gui.CollapsibleObject
    public Breaking breaking = new Breaking();
    @ConfigEntry.Gui.CollapsibleObject
    public Lists lists = new Lists();
    @ConfigEntry.Gui.CollapsibleObject
    public Decay decay = new Decay();
    @ConfigEntry.Gui.CollapsibleObject
    public Refresh refresh = new Refresh();
    @ConfigEntry.Gui.CollapsibleObject
    public Notifications notifications = new Notifications();
    @ConfigEntry.Gui.CollapsibleObject
    public Vanilla vanilla = new Vanilla();

    public static LootrModConfig get() {
        return (LootrModConfig)AutoConfig.getConfigHolder(LootrModConfig.class).getConfig();
    }

    public static boolean isDecaying(class_3218 level, ILootBlockEntity tile) {
        if (LootrModConfig.get().decay.decay_all) {
            return true;
        }
        if (tile.getTable() != null) {
            if (LootrModConfig.getDecayingTables().contains(tile.getTable())) {
                return true;
            }
            if (LootrModConfig.getDecayMods().contains(tile.getTable().method_12836())) {
                return true;
            }
        }
        return LootrModConfig.isDimensionDecaying((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isDecaying(class_3218 level, LootrChestMinecartEntity entity) {
        if (LootrModConfig.get().decay.decay_all) {
            return true;
        }
        if (entity.field_7734 != null) {
            if (LootrModConfig.getDecayingTables().contains(entity.field_7734)) {
                return true;
            }
            if (LootrModConfig.getDecayMods().contains(entity.field_7734.method_12836())) {
                return true;
            }
        }
        return LootrModConfig.isDimensionDecaying((class_5321<class_1937>)level.method_27983());
    }

    public static boolean isRefreshing(class_3218 level, LootrChestMinecartEntity entity) {
        if (LootrModConfig.get().refresh.refresh_all) {
            return true;
        }
        if (entity.field_7734 != null) {
            if (LootrModConfig.getRefreshingTables().contains(entity.field_7734)) {
                return true;
            }
            if (LootrModConfig.getDecayMods().contains(entity.field_7734.method_12836())) {
                return true;
            }
        }
        return LootrModConfig.isDimensionRefreshing((class_5321<class_1937>)level.method_27983());
    }

    public static Set<class_2960> getDecayingTables() {
        if (DECAY_TABLES == null) {
            DECAY_TABLES = LootrModConfig.get().decay.decay_loot_tables.stream().map(class_2960::new).collect(Collectors.toSet());
        }
        return DECAY_TABLES;
    }

    public static Set<String> getDecayMods() {
        if (DECAY_MODS == null) {
            DECAY_MODS = LootrModConfig.get().decay.decay_modids.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return DECAY_MODS;
    }

    public static boolean isDimensionDecaying(class_5321<class_1937> key) {
        return LootrModConfig.getDecayDimensions().contains(key);
    }

    public static Set<class_5321<class_1937>> getDecayDimensions() {
        if (DECAY_DIMS == null) {
            DECAY_DIMS = LootrModConfig.get().decay.decay_dimensions.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(o))).collect(Collectors.toSet());
        }
        return DECAY_DIMS;
    }

    public static boolean isRefreshing(class_3218 level, ILootBlockEntity tile) {
        if (LootrModConfig.get().refresh.refresh_all) {
            return true;
        }
        if (tile.getTable() != null) {
            if (LootrModConfig.getRefreshingTables().contains(tile.getTable())) {
                return true;
            }
            if (LootrModConfig.getRefreshMods().contains(tile.getTable().method_12836())) {
                return true;
            }
        }
        return LootrModConfig.isDimensionRefreshing((class_5321<class_1937>)level.method_27983());
    }

    public static Set<class_2960> getRefreshingTables() {
        if (REFRESH_TABLES == null) {
            REFRESH_TABLES = LootrModConfig.get().refresh.refresh_loot_tables.stream().map(class_2960::new).collect(Collectors.toSet());
        }
        return REFRESH_TABLES;
    }

    public static Set<String> getRefreshMods() {
        if (REFRESH_MODS == null) {
            REFRESH_MODS = LootrModConfig.get().refresh.refresh_modids.stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return REFRESH_MODS;
    }

    public static boolean isDimensionRefreshing(class_5321<class_1937> key) {
        return LootrModConfig.getRefreshDimensions().contains(key);
    }

    public static Set<class_5321<class_1937>> getRefreshDimensions() {
        if (REFRESH_DIMS == null) {
            REFRESH_DIMS = LootrModConfig.get().refresh.refresh_dimensions.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(o))).collect(Collectors.toSet());
        }
        return REFRESH_DIMS;
    }

    public static class_2680 replacement(class_2680 original) {
        class_2248 replacement;
        if (replacements == null) {
            replacements = new HashMap<class_2248, class_2248>();
        }
        if ((replacement = replacements.get(original.method_26204())) == null && (original.method_26164(LootrTags.Blocks.CONVERT_BARRELS) || original.method_26164(LootrTags.Blocks.CONVERT_CHESTS) || original.method_26164(LootrTags.Blocks.CONVERT_CHESTS) || original.method_26164(LootrTags.Blocks.CONVERT_SHULKERS) || original.method_26164(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS))) {
            class_2343 entityBlock;
            class_2586 be;
            class_2248 class_22482 = original.method_26204();
            if (class_22482 instanceof class_2343 && (be = (entityBlock = (class_2343)class_22482).method_10123(class_2338.field_10980, original)) instanceof class_2621) {
                if (original.method_26164(LootrTags.Blocks.CONVERT_TRAPPED_CHESTS)) {
                    replacements.put(original.method_26204(), (class_2248)LootrBlockInit.TRAPPED_CHEST);
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_BARRELS)) {
                    replacements.put(original.method_26204(), (class_2248)LootrBlockInit.BARREL);
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_CHESTS)) {
                    replacements.put(original.method_26204(), (class_2248)LootrBlockInit.CHEST);
                } else if (original.method_26164(LootrTags.Blocks.CONVERT_SHULKERS)) {
                    replacements.put(original.method_26204(), (class_2248)LootrBlockInit.SHULKER);
                }
            }
            replacement = replacements.get(original.method_26204());
        }
        if (replacement != null) {
            return LootrModConfig.copyProperties(replacement.method_9564(), original);
        }
        return null;
    }

    private static class_2680 copyProperties(class_2680 state, class_2680 original) {
        for (class_2769 prop : original.method_28501()) {
            if (!state.method_28498(prop)) continue;
            state = LootrModConfig.safeReplace(state, original, prop);
        }
        return state;
    }

    private static <V extends Comparable<V>> class_2680 safeReplace(class_2680 state, class_2680 original, class_2769<V> property) {
        if (property == class_2281.field_10770 && state.method_28498(property)) {
            return (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)class_2745.field_12569);
        }
        if (original.method_28498(property) && state.method_28498(property)) {
            return (class_2680)state.method_11657(property, original.method_11654(property));
        }
        return state;
    }

    public static boolean isVanillaTextures() {
        return LootrModConfig.get().vanilla.vanilla_textures;
    }

    public static Set<class_5321<class_1937>> getDimensionWhitelist() {
        if (DIM_WHITELIST == null) {
            DIM_WHITELIST = LootrModConfig.get().lists.dimension_whitelist.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(o))).collect(Collectors.toSet());
        }
        return DIM_WHITELIST;
    }

    public static Set<class_5321<class_1937>> getDimensionBlacklist() {
        if (DIM_BLACKLIST == null) {
            DIM_BLACKLIST = LootrModConfig.get().lists.dimension_blacklist.stream().map(o -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(o))).collect(Collectors.toSet());
        }
        return DIM_BLACKLIST;
    }

    public static Set<String> getLootModids() {
        if (LOOT_MODIDS == null) {
            LOOT_MODIDS = LootrModConfig.get().lists.loot_modid_blacklist.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
        return LOOT_MODIDS;
    }

    public static Set<class_2960> getLootBlacklist() {
        if (LOOT_BLACKLIST == null) {
            LOOT_BLACKLIST = LootrModConfig.get().lists.loot_table_blacklist.stream().map(class_2960::new).collect(Collectors.toSet());
        }
        return LOOT_BLACKLIST;
    }

    public static boolean isDimensionBlacklisted(class_5321<class_1937> key) {
        return !LootrModConfig.getDimensionWhitelist().isEmpty() && !LootrModConfig.getDimensionWhitelist().contains(key) || LootrModConfig.getDimensionBlacklist().contains(key);
    }

    public static boolean isBlacklisted(class_2960 table) {
        if (LootrModConfig.getLootBlacklist().contains(table)) {
            return true;
        }
        return LootrModConfig.getLootModids().contains(table.method_12836());
    }

    public static boolean shouldNotify(int remaining) {
        int delay = LootrModConfig.get().notifications.notification_delay;
        return !LootrModConfig.get().notifications.disable_notifications && (delay == -1 || remaining <= delay);
    }

    public static class Debug {
        public boolean report_invalid_tables = true;
    }

    public static class Seed {
        public boolean randomize_seed = true;
    }

    public static class Conversion {
        public int maximum_entry_age = 1800;
    }

    public static class Breaking {
        public boolean enable_break = false;
        public boolean enable_fake_player_break = false;
        public boolean disable_break = false;
        public boolean power_comparators = true;
        public boolean blast_resistant = false;
        public boolean blast_immune = false;
    }

    public static class Lists {
        @ConfigEntry.Gui.RequiresRestart
        public List<String> dimension_whitelist = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> dimension_blacklist = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> loot_table_blacklist = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> loot_modid_blacklist = List.of();
    }

    public static class Decay {
        public int decay_value = 6000;
        public boolean decay_all = false;
        @ConfigEntry.Gui.RequiresRestart
        public List<String> decay_modids = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> decay_loot_tables = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> decay_dimensions = List.of();
    }

    public static class Refresh {
        public int refresh_value = 24000;
        public boolean refresh_all = false;
        @ConfigEntry.Gui.RequiresRestart
        public List<String> refresh_modids = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> refresh_loot_tables = List.of();
        @ConfigEntry.Gui.RequiresRestart
        public List<String> refresh_dimensions = List.of();
    }

    public static class Notifications {
        public int notification_delay = 600;
        public boolean disable_notifications = false;
    }

    public static class Vanilla {
        @ConfigEntry.Gui.RequiresRestart
        public boolean vanilla_textures = false;
    }
}

