/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.utils;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import wraith.alloyforgery.mixin.RecipeManagerAccessor;
import wraith.alloyforgery.utils.DataPackEvents;

public final class RecipeInjector {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<AddRecipes> ADD_RECIPES = EventFactory.createArrayBacked(AddRecipes.class, addRecipes -> instance -> {
        for (AddRecipes addRecipe : addRecipes) {
            addRecipe.addRecipes(instance);
        }
    });
    private final class_1863 manager;
    private final Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes = new HashMap();
    private final Map<class_2960, class_1860<?>> recipesById = new HashMap();

    public RecipeInjector(class_1863 manager) {
        this.manager = manager;
    }

    public <T extends class_1860<C>, C extends class_1263> void addRecipe(T recipe) {
        if (class_7923.field_41188.method_10221((Object)recipe.method_17716()) == null) {
            throw new IllegalStateException("Unable to add Recipe for a RecipeType not registered!");
        }
        class_3956 type = recipe.method_17716();
        boolean bl = this.manager.method_30027(type).stream().anyMatch(recipe1 -> recipe1.method_8114().equals((Object)recipe.method_8114()));
        if (bl) {
            LOGGER.error("[RecipeInjector]: Unable to add a given recipe due to being the same Identifier with the given Type. [ID: {}]", (Object)recipe.method_8114());
            return;
        }
        this.recipes.computeIfAbsent(recipe.method_17716(), t -> new HashMap()).put(recipe.method_8114(), recipe);
        this.recipesById.put(recipe.method_8114(), recipe);
    }

    public class_1863 manager() {
        return this.manager;
    }

    public static void initEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(RecipeInjector::injectRecipes);
        DataPackEvents.BEFORE_SYNC.register(RecipeInjector::injectRecipes);
    }

    public static void injectRecipes(MinecraftServer server) {
        class_1863 manager = server.method_3772();
        RecipeInjector injector = new RecipeInjector(server.method_3772());
        ((AddRecipes)ADD_RECIPES.invoker()).addRecipes(injector);
        RecipeManagerAccessor managerAccessor = (RecipeManagerAccessor)manager;
        managerAccessor.af$getRecipes().forEach((recipeType, identifierRecipeMap) -> injector.recipes.computeIfAbsent((class_3956<?>)recipeType, t -> new HashMap()).putAll(identifierRecipeMap));
        injector.recipesById.putAll(managerAccessor.af$getRecipesById());
        managerAccessor.af$setRecipes((Map<class_3956<?>, Map<class_2960, class_1860<?>>>)ImmutableMap.copyOf(injector.recipes));
        managerAccessor.af$setRecipesById((Map<class_2960, class_1860<?>>)ImmutableMap.copyOf(injector.recipesById));
        injector.recipes.clear();
        injector.recipesById.clear();
    }

    public static interface AddRecipes {
        public void addRecipes(RecipeInjector var1);
    }
}

