/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.compacting;

import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public final class CompressionRecipeManager {
    private final class_1863 recipeManager;
    private final Map<ItemVariant, CompressionLadder> ladders = new HashMap<ItemVariant, CompressionLadder>();
    private final List<CompressionLadder> overrides = new ArrayList<CompressionLadder>();

    public CompressionRecipeManager(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
    }

    public static CompressionRecipeManager of(class_1863 recipeManager) {
        return ((Provider)recipeManager).extended_drawers$getCompactingManager();
    }

    public void setOverrides(List<CompressionLadder> overrides) {
        this.overrides.clear();
        this.overrides.addAll(overrides);
        this.reload();
    }

    public List<CompressionLadder> getOverrides() {
        return this.overrides;
    }

    public void reload() {
        this.ladders.clear();
        for (CompressionLadder override : this.overrides) {
            this.addLadder(override);
        }
    }

    public CompressionLadder getLadder(ItemVariant item, class_1937 world) {
        if (this.ladders.containsKey(item)) {
            return this.ladders.get(item);
        }
        CompressionLadder ladder = this.buildLadder(item, world);
        this.addLadder(ladder);
        return ladder;
    }

    private void addLadder(CompressionLadder ladder) {
        ladder.steps().forEach(step -> this.ladders.put(step.item(), ladder));
    }

    private CompressionLadder buildLadder(ItemVariant item, class_1937 world) {
        RecipePair pair;
        ItemVariant bottom = this.findBottom(item, world);
        ArrayList<CompressionLadder.Step> ladder = new ArrayList<CompressionLadder.Step>();
        HashSet<ItemVariant> visited = new HashSet<ItemVariant>();
        ItemVariant currentItem = bottom;
        int currentSize = 1;
        visited.add(currentItem);
        ladder.add(new CompressionLadder.Step(currentItem, currentSize));
        while ((pair = this.findCompressionRecipe(currentItem, world)) != null) {
            currentItem = pair.compressed;
            currentSize *= pair.scale;
            if (!visited.add(currentItem)) break;
            ladder.add(new CompressionLadder.Step(currentItem, currentSize));
        }
        return new CompressionLadder(List.copyOf(ladder));
    }

    private ItemVariant findBottom(ItemVariant item, class_1937 world) {
        RecipePair pair;
        HashSet<ItemVariant> visited = new HashSet<ItemVariant>();
        ItemVariant candidate = item;
        while ((pair = this.findDecompressionRecipe(candidate, world)) != null && !visited.contains(pair.decompressed)) {
            candidate = pair.decompressed;
            visited.add(candidate);
        }
        return candidate;
    }

    @Nullable
    private RecipePair findCompressionRecipe(ItemVariant decompressed, class_1937 world) {
        return IntStream.of(3, 2, 1).mapToObj(size -> this.findCompressionRecipeForSize(decompressed, world, size)).flatMap(Function.identity()).findFirst().orElse(null);
    }

    private Stream<RecipePair> findCompressionRecipeForSize(ItemVariant decompressed, class_1937 world, int size) {
        class_1799 decompressedStack = decompressed.toStack(size * size);
        return this.findRecipes(decompressed.toStack(), size, world).filter(compressed -> this.findRecipes((class_1799)compressed, 1, world).anyMatch(decompressed2 -> class_1799.method_7973((class_1799)decompressed2, (class_1799)decompressedStack))).map(compressed -> new RecipePair(ItemVariant.of((class_1799)compressed), decompressed, size * size));
    }

    @Nullable
    private RecipePair findDecompressionRecipe(ItemVariant compressed, class_1937 world) {
        class_1799 compressedStack = compressed.toStack();
        return this.findRecipes(compressedStack, 1, world).flatMap(decompressed -> IntStream.of(3, 2, 1).filter(size -> this.findRecipes((class_1799)decompressed, size, world).anyMatch(compressed2 -> class_1799.method_7973((class_1799)compressedStack, (class_1799)compressed2))).mapToObj(size -> new RecipePair(compressed, ItemVariant.of((class_1799)decompressed), size * size))).findFirst().orElse(null);
    }

    private Stream<class_1799> findRecipes(class_1799 stack, int size, class_1937 world) {
        class_1715 inventory = this.createInventory(stack, size);
        return this.recipeManager.method_17877(class_3956.field_17545, (class_1263)inventory, world).stream().filter(recipe -> recipe.method_8111((class_1263)inventory).stream().allMatch(class_1799::method_7960)).map(recipe -> recipe.method_8116((class_1263)inventory, world.method_30349())).filter(result -> !result.method_7960());
    }

    private class_1715 createInventory(class_1799 stack, int size) {
        class_1715 inventory = new class_1715(new class_1703(null, -1){

            public class_1799 method_7601(class_1657 player, int slot) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }
        }, size, size);
        for (int i = 0; i < size * size; ++i) {
            inventory.method_5447(i, stack);
        }
        return inventory;
    }

    public static interface Provider {
        default public CompressionRecipeManager extended_drawers$getCompactingManager() {
            throw new AssertionError((Object)"extended_drawers$getCompactingManager must be overridden");
        }
    }

    private record RecipePair(ItemVariant compressed, ItemVariant decompressed, int scale) {
    }
}

