/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.client.resources.language;

import com.google.common.collect.Maps;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.config.ClientConfig;
import fuzs.universalenchants.mixin.client.accessor.I18nAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.class_1078;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class NumericClientLanguage
extends class_2477 {
    private static final TreeMap<Integer, String> ROMAN_NUMERALS = (TreeMap)class_156.method_654((Object)Maps.newTreeMap(), map -> {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    });
    private final class_2477 language;
    private final Map<String, String> numeralsCache = Maps.newHashMap();

    public NumericClientLanguage(class_2477 language) {
        this.language = language;
    }

    public static void injectLanguage(NumericClientLanguage numericLanguage) {
        if (((ClientConfig)UniversalEnchants.CONFIG.get(ClientConfig.class)).fixRomanNumerals == ClientConfig.NumeralLanguage.NONE) {
            return;
        }
        if (numericLanguage.language instanceof class_1078) {
            I18nAccessor.universalenchants$callSetLanguage(numericLanguage);
            class_2477.method_29427((class_2477)numericLanguage);
        }
    }

    public String method_4679(String string, String fallback) {
        if ((fallback == null || Objects.equals(string, fallback)) && this.isNumeral(string)) {
            return this.numeralsCache.computeIfAbsent(string, this::computeLanguageNumeral);
        }
        return this.language.method_4679(string, fallback);
    }

    private boolean isNumeral(String string) {
        return string.startsWith("potion.potency.") || string.startsWith("enchantment.level.");
    }

    private String computeLanguageNumeral(String translationKey) {
        if (!this.language.method_4678(translationKey) || ((ClientConfig)UniversalEnchants.CONFIG.get(ClientConfig.class)).fixRomanNumerals == ClientConfig.NumeralLanguage.ARABIC) {
            String number = translationKey.substring(translationKey.lastIndexOf(".") + 1);
            if (number.chars().allMatch(Character::isDigit)) {
                int intNumber = Integer.parseInt(number);
                if (translationKey.startsWith("potion.potency.")) {
                    ++intNumber;
                }
                return this.toNumeral(intNumber);
            }
            return translationKey;
        }
        return this.language.method_48307(translationKey);
    }

    private String toNumeral(int number) {
        if (number > 0 && number < 4000 && ((ClientConfig)UniversalEnchants.CONFIG.get(ClientConfig.class)).fixRomanNumerals == ClientConfig.NumeralLanguage.ROMAN) {
            return NumericClientLanguage.toRomanNumeral(number);
        }
        return String.valueOf(number);
    }

    private static String toRomanNumeral(int number) {
        int l = ROMAN_NUMERALS.floorKey(number);
        if (number == l) {
            return ROMAN_NUMERALS.get(number);
        }
        return ROMAN_NUMERALS.get(l) + NumericClientLanguage.toRomanNumeral(number - l);
    }

    public boolean method_4678(String string) {
        if (this.language.method_4678(string)) {
            return true;
        }
        return this.isNumeral(string);
    }

    public boolean method_29428() {
        return this.language.method_29428();
    }

    public class_5481 method_30934(class_5348 formattedText) {
        return this.language.method_30934(formattedText);
    }
}

